# transformers-keras

![Python package](https://github.com/luozhouyang/transformers-keras/workflows/Python%20package/badge.svg)
[![PyPI version](https://badge.fury.io/py/transformers-keras.svg)](https://badge.fury.io/py/transformers-keras)
[![Python](https://img.shields.io/pypi/pyversions/transformers-keras.svg?style=plastic)](https://badge.fury.io/py/transformers-keras)


基于`tf.keras`的Transformers系列模型实现。

所有的`Model`都是keras模型，可以直接用于训练模型、评估模型或者导出模型用于部署。

在线文档：[transformers-keras文档](https://transformers-keras.readthedocs.io/zh_CN/latest/index.html)

本库功能预览：

* 加载各种预训练模型的权重
* 掩码语言模型(Masked Language Model)解决方案
* 句向量(Sentence Embedding)的解决方案
* 抽取式问答任务(Question Answering)的解决方案
* 序列分类任务(Sequence Classification)的解决方案
* 序列标注任务(Token Classification)的解决方案
* 知识蒸馏(Knowledge Distillation)的框架

以上任务的数据处理、模型构建都完成了，可以一键开始训练。这里有两个例子：

* [使用BERT微调文本分类任务](https://transformers-keras.readthedocs.io/zh_CN/latest/start.html#id4)
* [使用BERT微调问答任务](https://transformers-keras.readthedocs.io/zh_CN/latest/start.html#id5)


更多使用方法和介绍，请查看在线文档：[transformers-keras文档](https://transformers-keras.readthedocs.io/zh_CN/latest/index.html)


## 联系方式

> 由于二维码过期限制，加微信讨论群请先加我微信邀请加入。

* 微信: luozhouyang0528
* 邮箱: zhouyang.luo@gmail.com

