# coding: utf-8

"""
    Criteo API Transition Swagger

    This is used to help Criteo clients transition from MAPI to Criteo API  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class StatisticsReportQueryMessage(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'advertiser_ids': 'str',
        'dimensions': 'list[str]',
        'metrics': 'list[str]',
        'currency': 'str',
        'format': 'str',
        'timezone': 'str',
        'start_date': 'datetime',
        'end_date': 'datetime'
    }

    attribute_map = {
        'advertiser_ids': 'advertiserIds',
        'dimensions': 'dimensions',
        'metrics': 'metrics',
        'currency': 'currency',
        'format': 'format',
        'timezone': 'timezone',
        'start_date': 'startDate',
        'end_date': 'endDate'
    }

    def __init__(self, advertiser_ids=None, dimensions=None, metrics=None, currency=None, format=None, timezone='UTC', start_date=None, end_date=None):  # noqa: E501
        """StatisticsReportQueryMessage - a model defined in OpenAPI"""  # noqa: E501

        self._advertiser_ids = None
        self._dimensions = None
        self._metrics = None
        self._currency = None
        self._format = None
        self._timezone = None
        self._start_date = None
        self._end_date = None
        self.discriminator = None

        if advertiser_ids is not None:
            self.advertiser_ids = advertiser_ids
        self.dimensions = dimensions
        self.metrics = metrics
        self.currency = currency
        self.format = format
        if timezone is not None:
            self.timezone = timezone
        self.start_date = start_date
        self.end_date = end_date

    @property
    def advertiser_ids(self):
        """Gets the advertiser_ids of this StatisticsReportQueryMessage.  # noqa: E501

        The comma-separated list of advertiser ids. If empty, all the advertisers in the portfolio will be used  # noqa: E501

        :return: The advertiser_ids of this StatisticsReportQueryMessage.  # noqa: E501
        :rtype: str
        """
        return self._advertiser_ids

    @advertiser_ids.setter
    def advertiser_ids(self, advertiser_ids):
        """Sets the advertiser_ids of this StatisticsReportQueryMessage.

        The comma-separated list of advertiser ids. If empty, all the advertisers in the portfolio will be used  # noqa: E501

        :param advertiser_ids: The advertiser_ids of this StatisticsReportQueryMessage.  # noqa: E501
        :type: str
        """

        self._advertiser_ids = advertiser_ids

    @property
    def dimensions(self):
        """Gets the dimensions of this StatisticsReportQueryMessage.  # noqa: E501

        The dimensions for the report.  # noqa: E501

        :return: The dimensions of this StatisticsReportQueryMessage.  # noqa: E501
        :rtype: list[str]
        """
        return self._dimensions

    @dimensions.setter
    def dimensions(self, dimensions):
        """Sets the dimensions of this StatisticsReportQueryMessage.

        The dimensions for the report.  # noqa: E501

        :param dimensions: The dimensions of this StatisticsReportQueryMessage.  # noqa: E501
        :type: list[str]
        """
        if dimensions is None:
            raise ValueError("Invalid value for `dimensions`, must not be `None`")  # noqa: E501

        self._dimensions = dimensions

    @property
    def metrics(self):
        """Gets the metrics of this StatisticsReportQueryMessage.  # noqa: E501

        The list of metrics to report.  # noqa: E501

        :return: The metrics of this StatisticsReportQueryMessage.  # noqa: E501
        :rtype: list[str]
        """
        return self._metrics

    @metrics.setter
    def metrics(self, metrics):
        """Sets the metrics of this StatisticsReportQueryMessage.

        The list of metrics to report.  # noqa: E501

        :param metrics: The metrics of this StatisticsReportQueryMessage.  # noqa: E501
        :type: list[str]
        """
        if metrics is None:
            raise ValueError("Invalid value for `metrics`, must not be `None`")  # noqa: E501

        self._metrics = metrics

    @property
    def currency(self):
        """Gets the currency of this StatisticsReportQueryMessage.  # noqa: E501

        The currency used for the report. ISO 4217 code (three-letter capitals).  # noqa: E501

        :return: The currency of this StatisticsReportQueryMessage.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this StatisticsReportQueryMessage.

        The currency used for the report. ISO 4217 code (three-letter capitals).  # noqa: E501

        :param currency: The currency of this StatisticsReportQueryMessage.  # noqa: E501
        :type: str
        """
        if currency is None:
            raise ValueError("Invalid value for `currency`, must not be `None`")  # noqa: E501

        self._currency = currency

    @property
    def format(self):
        """Gets the format of this StatisticsReportQueryMessage.  # noqa: E501

        The file format of the generated report: csv, xml, excel or json.  # noqa: E501

        :return: The format of this StatisticsReportQueryMessage.  # noqa: E501
        :rtype: str
        """
        return self._format

    @format.setter
    def format(self, format):
        """Sets the format of this StatisticsReportQueryMessage.

        The file format of the generated report: csv, xml, excel or json.  # noqa: E501

        :param format: The format of this StatisticsReportQueryMessage.  # noqa: E501
        :type: str
        """
        if format is None:
            raise ValueError("Invalid value for `format`, must not be `None`")  # noqa: E501

        self._format = format

    @property
    def timezone(self):
        """Gets the timezone of this StatisticsReportQueryMessage.  # noqa: E501

        The timezone used for the report. Timezone Database format (Tz).  # noqa: E501

        :return: The timezone of this StatisticsReportQueryMessage.  # noqa: E501
        :rtype: str
        """
        return self._timezone

    @timezone.setter
    def timezone(self, timezone):
        """Sets the timezone of this StatisticsReportQueryMessage.

        The timezone used for the report. Timezone Database format (Tz).  # noqa: E501

        :param timezone: The timezone of this StatisticsReportQueryMessage.  # noqa: E501
        :type: str
        """

        self._timezone = timezone

    @property
    def start_date(self):
        """Gets the start_date of this StatisticsReportQueryMessage.  # noqa: E501

        Start date of the report. Date component of ISO 8061 format, any time or timezone component is ignored.  # noqa: E501

        :return: The start_date of this StatisticsReportQueryMessage.  # noqa: E501
        :rtype: datetime
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """Sets the start_date of this StatisticsReportQueryMessage.

        Start date of the report. Date component of ISO 8061 format, any time or timezone component is ignored.  # noqa: E501

        :param start_date: The start_date of this StatisticsReportQueryMessage.  # noqa: E501
        :type: datetime
        """
        if start_date is None:
            raise ValueError("Invalid value for `start_date`, must not be `None`")  # noqa: E501

        self._start_date = start_date

    @property
    def end_date(self):
        """Gets the end_date of this StatisticsReportQueryMessage.  # noqa: E501

        End date of the report. Date component of ISO 8061 format, any time or timezone component is ignored.  # noqa: E501

        :return: The end_date of this StatisticsReportQueryMessage.  # noqa: E501
        :rtype: datetime
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date):
        """Sets the end_date of this StatisticsReportQueryMessage.

        End date of the report. Date component of ISO 8061 format, any time or timezone component is ignored.  # noqa: E501

        :param end_date: The end_date of this StatisticsReportQueryMessage.  # noqa: E501
        :type: datetime
        """
        if end_date is None:
            raise ValueError("Invalid value for `end_date`, must not be `None`")  # noqa: E501

        self._end_date = end_date

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StatisticsReportQueryMessage):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
