from datetime import datetime
from sphinx.application import Sphinx

author = "Lamin Labs"
copyright = f"{datetime.now():%Y}, {author}"

extensions = [
    "myst_nb",
    "ablog",
    "sphinxext.opengraph",
    "sphinx.ext.autodoc",
    "sphinx.ext.napoleon",
    "sphinx.ext.autosummary",
    "IPython.sphinxext.ipython_console_highlighting",  # noqa https://github.com/spatialaudio/nbsphinx/issues/24
]

templates_path = ["lamin_sphinx/_templates"]
source_suffix = [".md", ".ipynb"]
exclude_patterns = [
    ".nox",
    "_build",
    "Thumbs.db",
    ".DS_Store",
    "node_modules",
    "README.md",
    "**/README.md",
    "profile",
    "private",
]

html_theme = "pydata_sphinx_theme"

html_theme_options = {
    "show_prev_next": False,
    "use_edit_page_button": False,  # currently unused
    "search_bar_text": "Search",  # currently unused
    "navbar_end": ["theme-switcher"],
    "navbar_align": "left",
    "footer_items": ["copyright"],
}

html_context = {
    "default_mode": "auto",
    "github_user": "laminlabs",
    "github_version": "main",
}

html_logo = "lamin_sphinx/_static/img/logo.svg"
html_favicon = "lamin_sphinx/_static/img/favicon.ico"
html_static_path = ["lamin_sphinx/_static"]

# Other configurations
panels_add_bootstrap_css = False
myst_enable_extensions = [
    "deflist",
    "colon_fence",
]

# Generate the API documentation
autosummary_generate = True
autodoc_member_order = "bysource"
napoleon_google_docstring = True
napoleon_include_init_with_doc = False
napoleon_use_rtype = True  # a separate entry helps readability
napoleon_use_param = True
todo_include_todos = False

ogp_image = "https://lamin.ai/_static/img/logo.png"

# stored as off until we change the design (and this is fixed)
jupyter_execute_notebooks = "off"

nitpicky = True  # report broken links


def setup(app: Sphinx):
    # Don’t allow broken links. DO NOT CHANGE THIS LINE, fix problems instead.
    app.warningiserror = False
    app.add_css_file("custom.css")
