"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFormationDeployStackInstancesAction = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const action_1 = require("../action");
const common_1 = require("../common");
const singleton_policy_1 = require("./private/singleton-policy");
/**
 * CodePipeline action to create/update Stack Instances of a StackSet
 *
 * After the initial creation of a stack set, you can add new stack instances by
 * using CloudFormationStackInstances. Template parameter values can be
 * overridden at the stack instance level during create or update stack set
 * instance operations.
 *
 * Each stack set has one template and set of template parameters. When you
 * update the template or template parameters, you update them for the entire
 * set. Then all instance statuses are set to OUTDATED until the changes are
 * deployed to that instance.
 */
class CloudFormationDeployStackInstancesAction extends action_1.Action {
    constructor(props) {
        var _b, _c, _d, _e;
        super({
            ...props,
            region: props.stackSetRegion,
            provider: 'CloudFormationStackInstances',
            category: codepipeline.ActionCategory.DEPLOY,
            artifactBounds: {
                minInputs: 0,
                maxInputs: 3,
                minOutputs: 0,
                maxOutputs: 0,
            },
            inputs: [
                ...(_c = (_b = props.parameterOverrides) === null || _b === void 0 ? void 0 : _b._artifactsReferenced) !== null && _c !== void 0 ? _c : [],
                ...(_e = (_d = props.stackInstances) === null || _d === void 0 ? void 0 : _d._artifactsReferenced) !== null && _e !== void 0 ? _e : [],
            ],
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_codepipeline_actions_CloudFormationDeployStackInstancesActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.props = props;
        common_1.validatePercentage('failureTolerancePercentage', props.failureTolerancePercentage);
        common_1.validatePercentage('maxAccountConcurrencyPercentage', props.maxAccountConcurrencyPercentage);
    }
    bound(scope, _stage, options) {
        var _b, _c;
        const singletonPolicy = singleton_policy_1.SingletonPolicy.forRole(options.role);
        singletonPolicy.grantCreateUpdateStackSet(this.props);
        const instancesResult = (_b = this.props.stackInstances) === null || _b === void 0 ? void 0 : _b._bind(scope);
        if ((this.actionProperties.inputs || []).length > 0) {
            options.bucket.grantRead(singletonPolicy);
        }
        return {
            configuration: {
                StackSetName: this.props.stackSetName,
                ParameterOverrides: (_c = this.props.parameterOverrides) === null || _c === void 0 ? void 0 : _c._render(),
                FailureTolerancePercentage: this.props.failureTolerancePercentage,
                MaxConcurrentPercentage: this.props.maxAccountConcurrencyPercentage,
                ...instancesResult === null || instancesResult === void 0 ? void 0 : instancesResult.stackSetConfiguration,
            },
        };
    }
}
exports.CloudFormationDeployStackInstancesAction = CloudFormationDeployStackInstancesAction;
_a = JSII_RTTI_SYMBOL_1;
CloudFormationDeployStackInstancesAction[_a] = { fqn: "@aws-cdk/aws-codepipeline-actions.CloudFormationDeployStackInstancesAction", version: "1.155.0" };
//# sourceMappingURL=data:application/json;base64,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