import os
from os.path import dirname, realpath, join


SECRET_KEY = 'fake-key'

INSTALLED_APPS = [
    # Django apps
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.sites',

    # Local apps
    "tests",
]

OAI_PROVIDER_ROOT = dirname(realpath(__file__))

ALLOWED_HOSTS = ['testserver']

MIDDLEWARE = (
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware'
)

TEMPLATES = [{
    'BACKEND': 'django.template.backends.django.DjangoTemplates',
    'DIRS': [
        join(
            dirname(dirname(os.path.realpath(__file__))),
            'core_oaipmh_provider_app',
            'templates'
        )
    ],
    'OPTIONS': {
        'context_processors': [
            'django.contrib.auth.context_processors.auth',
            'django.contrib.messages.context_processors.messages',
        ]
    }
}]

ROOT_URLCONF = 'core_oaipmh_provider_app.urls'
