"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MyRedis = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const k8s = require("./imports/k8s");
/**
 * @experimental
 */
class MyRedis extends constructs_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, name, opts) {
        var _b, _c, _d, _e, _f;
        super(scope, name);
        const namespace = (_b = opts.namespace) !== null && _b !== void 0 ? _b : 'default';
        this.namespace = namespace;
        const volumeRequest = {
            storage: k8s.Quantity.fromString(String(opts.volumeSize)),
        };
        const replicas = (_c = opts.replicas) !== null && _c !== void 0 ? _c : 1;
        const resources = {
            limits: convertQuantity((_d = opts.resources) === null || _d === void 0 ? void 0 : _d.limits, {
                cpu: '400m',
                memory: '512Mi',
            }),
            requests: convertQuantity((_e = opts.resources) === null || _e === void 0 ? void 0 : _e.requests, {
                cpu: '200m',
                memory: '256Mi',
            }),
        };
        const nodeSelectorParams = (_f = opts.nodeSelectorParams) !== null && _f !== void 0 ? _f : undefined;
        const label = {
            ...opts.labels,
            app: name,
        };
        const serviceOpts = {
            metadata: {
                labels: label,
                name: name,
                namespace: namespace,
            },
            spec: {
                type: 'ClusterIP',
                selector: label,
                ports: [{ port: 6379, targetPort: k8s.IntOrString.fromNumber(6379) }],
            },
        };
        const svc = new k8s.KubeService(this, 'service', serviceOpts);
        this.name = svc.name;
        const pvcProps = {
            metadata: {
                name: name,
                namespace: namespace,
            },
            spec: {
                accessModes: ['ReadWriteOnce'],
                storageClassName: opts.storageClassName,
                resources: {
                    requests: volumeRequest,
                },
            },
        };
        // const initRedis: k8s.Container = {
        //   name: 'init-redis',
        //   image: opts.image,
        //   command: [
        //     'bash',
        //     '-c',
        //     'set -ex\n# Generate mysql server-id from pod ordinal index.\nmkdir -p /etc/redis\n[[ `hostname` =~ -([0-9]+)$ ]] || exit 1\nordinal=${BASH_REMATCH[1]}\n# Copy appropriate conf.d files from config-map to emptyDir.\nif [[ $ordinal -eq 0 ]]; then\ncp /mnt/redis/master.conf /etc/redis/redis.conf\nelse\ncp /mnt/redis/slave.conf /etc/redis/redis.conf\nfi',
        //   ],
        //   volumeMounts: [{
        //     name: name,
        //     mountPath: '/data',
        //   },
        //   {
        //     name: `${name}-redis-conf`,
        //     mountPath: '/mnt/config-map',
        //   }],
        // };
        const redis = {
            name: 'redis',
            image: opts.image,
            ports: [{
                    containerPort: 6379,
                }],
            command: [
                'bash',
                '-c',
                '[[ `hostname` =~ -([0-9]+)$ ]] || exit 1\nordinal=${BASH_REMATCH[1]}\nif [[ $ordinal -eq 0 ]]; then\nredis-server /mnt/redis/master.conf\nelse\nredis-server /mnt/redis/slave.conf\nfi',
            ],
            resources: resources,
            env: renderEnv(opts.env),
            volumeMounts: [{
                    name: name,
                    mountPath: '/data',
                },
                {
                    name: `${name}-redis-conf`,
                    mountPath: '/mnt/redis/',
                }],
        };
        const stsOpts = {
            metadata: {
                labels: label,
                name: name,
                namespace: namespace,
            },
            spec: {
                serviceName: svc.name,
                replicas: replicas,
                selector: { matchLabels: label },
                template: {
                    metadata: { labels: label },
                    spec: {
                        containers: [
                            redis,
                        ],
                        terminationGracePeriodSeconds: 10,
                        nodeSelector: nodeSelectorParams,
                        volumes: [{
                                name: `${name}-redis-conf`,
                                configMap: {
                                    name: `${name}-redis-conf`,
                                },
                            }],
                    },
                },
                volumeClaimTemplates: [pvcProps],
            },
        };
        const sts = new k8s.KubeStatefulSet(this, 'statefulset', stsOpts);
        this.name = sts.name;
    }
}
exports.MyRedis = MyRedis;
_a = JSII_RTTI_SYMBOL_1;
MyRedis[_a] = { fqn: "@Hunter-Thompson/cdk8s-redis-sts.MyRedis", version: "0.0.2" };
function renderEnv(env = {}) {
    const result = new Array();
    for (const [key, value] of Object.entries(env)) {
        result.push({
            name: key,
            value: value,
        });
    }
    return result;
}
/**
 * Converts a `ResourceQuantity` type to a k8s.Quantity map.
 *
 * If `user` is defined, the values provided there (or lack thereof) will be
 * passed on. This means that if the user, for example, did not specify a value
 * for `cpu`, this value will be omitted from the resource requirements. This is
 * intentional, in case the user intentionally wants to omit a constraint.
 *
 * If `user` is not defined, `defaults` are used.
 */
function convertQuantity(user, defaults) {
    // defaults
    if (!user) {
        return {
            cpu: k8s.Quantity.fromString(defaults.cpu),
            memory: k8s.Quantity.fromString(defaults.memory),
        };
    }
    const result = {};
    if (user.cpu) {
        result.cpu = k8s.Quantity.fromString(user.cpu);
    }
    if (user.memory) {
        result.memory = k8s.Quantity.fromString(user.memory);
    }
    return result;
}
//# sourceMappingURL=data:application/json;base64,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