# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['abimca']

package_data = \
{'': ['*']}

install_requires = \
['coloredlogs>=15.0.1,<16.0.0',
 'matplotlib>=3.5.3,<4.0.0',
 'numpy>=1.23.2,<2.0.0',
 'pandas>=1.4.3,<2.0.0',
 'scikit-learn>=1.1.2,<2.0.0',
 'scipy>=1.9.0,<2.0.0',
 'torch>=1.12.1,<2.0.0',
 'tqdm>=4.64.0,<5.0.0']

setup_kwargs = {
    'name': 'abimca',
    'version': '0.2.4',
    'description': 'Autoencoder based iterative modeling and multivariate time-series subsequence clustering algorithm (ABIMCA)',
    'long_description': '[![DOI](https://zenodo.org/badge/529262007.svg)](https://zenodo.org/badge/latestdoi/529262007) [![Python 3.9](https://img.shields.io/badge/Python-3.9-blue)](https://www.python.org/downloads/release/python-390/)\n\n# Autoencoder Based Iterative Modeling and Subsequence Clustering Algorithm (ABIMCA)\n\nThis repository contains the python code for the Autoencoder Based Iterative Modeling and Subsequence Clustering Algorithm (ABIMCA)[^koehn] which is a deep learning method to separate multivariate time-series data (MTSD) into subsequences. It is beneficial in a variety of fields, to cluster MTSD into smaller segments or subsequences in an unsupervised manner. The ability to filter measurement data based on specific subsequences can improve downstream development products such as anomaly detection or machine diagnosis in condition based maintenance (CbM) strategies. Our algorithm is specifically useful for MTSD generated by a mechatronic system in a transient environment. It can be used offline as well as online for streaming data. It utilizes recurrent neural network (RNN) based Autoencoders (AE) by iteratively training a Base Autoencoder (BAE), generating a segmentation score and saving the intermediate parameters of the BAE to recognize previously identified subsequences.\n\n![Autoencoder Based Iterative Modeling and Subsequence Clustering Algorithm (ABIMCA)](abimca.gif)\n\n# Usage\n\nPackage can be installed with pip\n\n```bash\n$ pip install abimca\n```\n\nor clone the repository, and cd into the directory. Then recommendation is to create a virtual environment after installing and using python 3.9 with [pyenv](https://github.com/pyenv/pyenv)\n\n```python\npython -m venv .venv\n```\nactivate the environment\nLinux:\n    $ source .venv/bin/activate\n\nWindows cmd:\n    C:\\> .venv\\Scripts\\activate.bat\n\nThen install with [poetry](https://python-poetry.org/)\n\n```bash\n$ poetry install\n```\n\nFinally run the minimal example in *main.py*\n\n```bash\n$ python -m main\n```\n\nThe above graphic example was generated with the *run_lorenz.py* script. The minimal example is as follows:\n\n```python\nimport numpy as np\nfrom abimca import SubsequenceIdentifier\n\n# Generating random data. This will produce no class predictions or all points have the same class. For more reasonable results replace the data input with your mechatronic measurement data.\n\n# Number of datapoints (time-steps)\nn_p = 1000\n# Number of dimensions or features\ndim = 5\nX = np.random.rand(n_p, dim)\n# Number of clusters\nn_c = 5\ny = np.random.randint(n_c, size=n_p)\n\n# Compute online clustering\nsi = SubsequenceIdentifier(disable_progress_bar=False)\nsi.fit(X)\nprint(f"Label array from online fitting: \\n{si.label_array}")\n\n# Compute offline clustering\nlabels = si.predict(X)\nprint(f"Label array from online fitting: \\n{labels}")\n```\n\n## References\n[^koehn]: Köhne, J. et al. Autoencoder based iterative modeling and multivariate time-series subsequence clustering algorithm\n',
    'author': 'Jonas Köhne',
    'author_email': 'j.koehne@tu-berlin.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Jokonu/abimca',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<3.12',
}


setup(**setup_kwargs)
