import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageContainerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/storage_container#allowed_origins StorageContainer#allowed_origins}
    */
    readonly allowedOrigins?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/storage_container#exposed_headers StorageContainer#exposed_headers}
    */
    readonly exposedHeaders?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/storage_container#id StorageContainer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/storage_container#max_age StorageContainer#max_age}
    */
    readonly maxAge?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/storage_container#metadata StorageContainer#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/storage_container#name StorageContainer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/storage_container#primary_key StorageContainer#primary_key}
    */
    readonly primaryKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/storage_container#quota_bytes StorageContainer#quota_bytes}
    */
    readonly quotaBytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/storage_container#quota_count StorageContainer#quota_count}
    */
    readonly quotaCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/storage_container#read_acls StorageContainer#read_acls}
    */
    readonly readAcls?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/storage_container#secondary_key StorageContainer#secondary_key}
    */
    readonly secondaryKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/storage_container#write_acls StorageContainer#write_acls}
    */
    readonly writeAcls?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opc/r/storage_container opc_storage_container}
*/
export declare class StorageContainer extends cdktf.TerraformResource {
    static readonly tfResourceType = "opc_storage_container";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opc/r/storage_container opc_storage_container} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageContainerConfig
    */
    constructor(scope: Construct, id: string, config: StorageContainerConfig);
    private _allowedOrigins?;
    get allowedOrigins(): string[];
    set allowedOrigins(value: string[]);
    resetAllowedOrigins(): void;
    get allowedOriginsInput(): string[] | undefined;
    private _exposedHeaders?;
    get exposedHeaders(): string[];
    set exposedHeaders(value: string[]);
    resetExposedHeaders(): void;
    get exposedHeadersInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maxAge?;
    get maxAge(): number;
    set maxAge(value: number);
    resetMaxAge(): void;
    get maxAgeInput(): number | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _primaryKey?;
    get primaryKey(): string;
    set primaryKey(value: string);
    resetPrimaryKey(): void;
    get primaryKeyInput(): string | undefined;
    private _quotaBytes?;
    get quotaBytes(): number;
    set quotaBytes(value: number);
    resetQuotaBytes(): void;
    get quotaBytesInput(): number | undefined;
    private _quotaCount?;
    get quotaCount(): number;
    set quotaCount(value: number);
    resetQuotaCount(): void;
    get quotaCountInput(): number | undefined;
    private _readAcls?;
    get readAcls(): string[];
    set readAcls(value: string[]);
    resetReadAcls(): void;
    get readAclsInput(): string[] | undefined;
    private _secondaryKey?;
    get secondaryKey(): string;
    set secondaryKey(value: string);
    resetSecondaryKey(): void;
    get secondaryKeyInput(): string | undefined;
    private _writeAcls?;
    get writeAcls(): string[];
    set writeAcls(value: string[]);
    resetWriteAcls(): void;
    get writeAclsInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
