# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pybaqus', 'pybaqus.plot_utils']

package_data = \
{'': ['*']}

install_requires = \
['matplotlib>=3.2.1,<4.0.0',
 'numpy>=1.18.2,<2.0.0',
 'pyvista>=0.37.0,<0.38.0',
 'scipy>=1.4.1,<2.0.0',
 'tqdm>=4.62.3,<5.0.0',
 'vtk>=9.0.3,<10.0.0']

setup_kwargs = {
    'name': 'pybaqus',
    'version': '0.2.6',
    'description': '',
    'long_description': '# Pybaqus\n\nPybaqus is a python library to import the output files generated by [Abaqus][1] in the ASCII `*.fil` format, and create a [VTK][2] object from the data.\nThe results can then be analyzed in pure python (i.e. no Abaqus licence needed) with the great tools provided by [PyVista][3].\n\n# Features\n\nPybaqus is in a very early development stage.\nTherefore, there are still many unimplemented functionalities.\nHowever, basic operations like importing the mesh and the nodal and element results is implemented and can be used for some analysis.\n\nThe following features are either already implemented or planned:\n\n- [x] Import 2D meshes\n- [x] Import 3D meshes\n- [x] Import nodal results\n- [x] Import element results\n- [x] Element and node sets\n- [x] Extrapolate element results from Gaussian points to nodes _(implemented for some elements)_\n- [ ] Import history output\n- [x] Compute stresses along paths\n- [ ] Compute section forces and moments\n\n# Installation\n\n```\npip install pybaqus\n```\n\n# Quick-start\n\nThe first thing you need is to tell Abaqus that you want am ASCII `*.fil` result file.\nTo get that you need to write the following lines in your `*.inp` file, within the step definition (before the `*End Step` command) e.g.:\n\n```\n...\n*FILE FORMAT, ASCII\n*EL FILE, DIRECTIONS=YES\nS, E, COORD\n*NODE FILE\nCOORD, U\n\n*End Step\n...\n```\n\nYou can specify different output variables (as long as they are available for the elements you are using, of course).\nAfter submitting your model you will get a `*.fil` file.\nThis is the file you need to import it with Pybaqus.\n\nImport the `*.fil` file like this:\n\n```python\nfrom pybaqus import open_fil\n\nres = open_fil("your_result.fil")\n\n```\n\nGreat!\nThat was it. :)\n\nNow you have your results as a VTK object, wrapped by PyVista, and there\'s nothing that can get in your way to analyze your results with pure python.\n\n### Plot the mesh\n\n```python\nimport pyvista as pv\n\nmesh = res.get_mesh()\n\n\nplot = pv.Plotter()\nplot.add_mesh(mesh, show_edges=True, color="white")\nplot.view_xy()\nplot.show()\n```\n\n![Mesh](examples/mesh_hole.png)\n\nCool! But something\'s missing there. Colors!\nWe can plot some of our results like this:\n\n```python\nmesh = res.get_deformed_mesh(step=1, inc=1, scale=3)\ns2 = res.get_nodal_result(var="S2", step=1, inc=1)\nmesh.point_arrays["S2"] = s2\n\nplot = pv.Plotter()\nplot.add_mesh(mesh, show_edges=True, color="white",\n           scalars="S2", show_scalar_bar=True)\nplot.view_xy()\nplot.show()\n```\n\n![Mesh](examples/mesh_results.png)\n\nThat\'s it!\nSince the API is still under development, some of these functions might change.\n\nAnd now you can de whatever you want with your results in python.\nHave fun!\n\n[1]: https://www.3ds.com/products-services/simulia/products/abaqus/\n[2]: https://vtk.org/\n[3]: https://www.pyvista.org/\n',
    'author': 'Cristóbal Tapia Camú',
    'author_email': 'crtapia@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/cristobaltapia/pybaqus',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7.7,<4.0.0',
}


setup(**setup_kwargs)
