
class Label(object):
    def __init__(self, labeldict):
        pass

    
def _v1_applabel_to_piplabel(k=None):
    d = {"P002_P002C001_Closing": "person_closes_car_door",
         "P002_P002C001_Entering": "person_enters_car",
         "P002_P002C001_Exiting": "person_exits_car",
         "P002_P002C001_Opening": "person_opens_car_door",
         "P002_P002C002_Closing": "person_closes_car_trunk",
         "P002_P002C002_Loading": "person_loads_car",
         "P002_P002C002_Opening": "person_opens_car_trunk",
         "P002_P002C002_Unloading": "person_unloads_car",
         "P002_P002C003_Turning left": "car_turns_left",
         "P002_P002C003_Turning right": "car_turns_right",
         "P002_P002C003_U-turn": "car_makes_u_turn",
         "P002_P002C004_Picking up": "car_picks_up_person",
         "P002_P002C004_Starting": "car_starts",
         "P002_P002C004_Stopping": "car_stops",
         "P002_P002C005_Dropping off": "car_drops_off_person",
         "P002_P002C005_Starting": "car_starts",
         "P002_P002C005_Stopping": "car_stops",
         "P002_P002C006_Transferring": "person_transfers_object_to_car",
         "P002_P002C007_Reversing": "car_reverses",
         "P003_P003C001_Closing": "person_closes_motorcycle_door",  # remove me, meaningless
         "P003_P003C001_Entering": "person_enters_motorcycle",
         "P003_P003C001_Exiting": "person_exits_motorcycle",
         "P003_P003C001_Opening": "person_opens_motorcycle_door",  # remove me, meaningless
         "P003_P003C002_Closing": "person_closes_motorcycle_trunk",
         "P003_P003C002_Loading": "person_loads_motorcycle",
         "P003_P003C002_Opening": "person_opens_motorcycle_trunk",
         "P003_P003C002_Unloading": "person_unloads_motorcycle",
         "P003_P003C003_Turning left": "motorcycle_turns_left",
         "P003_P003C003_Turning right": "motorcycle_turns_right",
         "P003_P003C003_U-turn": "motorcycle_makes_u_turn",
         "P003_P003C004_Picking up": "motorcycle_picks_up_person",
         "P003_P003C004_Starting": "motorcycle_starts",
         "P003_P003C004_Stopping": "motorcycle_stops",
         "P003_P003C005_Dropping off": "motorcycle_drops_off_person",
         "P003_P003C005_Starting": "motorcycle_starts",
         "P003_P003C005_Stopping": "motorcycle_stops",
         "P003_P003C006_Transferring": "person_transfers_object_to_motorcycle",
         "P003_P003C007_Reversing": "motorcycle_reverses",
         "P004_P004C001_Closing": "person_closes_facility_door",
         "P004_P004C001_Entering": "person_enters_scene_through_structure",
         "P004_P004C001_Exiting": "person_exits_scene_through_structure",
         "P004_P004C001_Opening": "person_opens_facility_door",
         "P004_P004C002_Entering": "person_enters_scene_through_structure",
         "P004_P004C002_Exiting": "person_exits_scene_through_structure",
         "P004_P004C003_Reading": "person_reads_document",
         "P004_P004C003_Sitting": "person_sits_down",
         "P004_P004C003_Standing": "person_stands_up",
         "P004_P004C004_Dropping off": "person_puts_down_object",
         "P004_P004C004_Picking up": "person_picks_up_object",
         "P004_P004C005_Abandoning": "person_abandons_package",
         "P004_P004C005_Sets down": "person_puts_down_object",
         "P004_P004C006_Carrying": "person_carries_heavy_object",
         "P004_P004C007_Talking on": "person_talks_on_phone",
         "P004_P004C007_Texting on": "person_texts_on_phone",
         "P004_P004C008_Sitting": "person_sits_down",
         "P004_P004C008_Standing": "person_stands_up",
         "P004_P004C008_Using laptop": "person_interacts_with_laptop",
         "P004_P004C009_Purchasing": "person_purchases_from_machine",
         "P004_P004C010_Dropping off": "person_puts_down_object",
         "P004_P004C010_Picking up": "person_picks_up_object",
         "P004_P004C010_Riding": "person_rides_bicycle",
         "P005_P005C001_Talking to": "person_talks_to_person",
         "P005_P005C001_Touching hands": "hand_interacts_with_person_highfive",
         "P005_P005C002_Stealing": "person_steals_object",
         "P005_P005C003_Purchasing": "person_purchases_from_cashier",  # Remove me
         "P005_P005C004_Transferring": "person_transfers_object_to_person",
         "P005_P005C005_Hugging": "person_embraces_person",
         "P005_P005C005_Touching hands": "hand_interacts_with_person_holdhands",
         "P005_P005C006_Talking to": "person_talks_to_person",
         "P005_P005C006_Touching hands": "hand_interacts_with_person_shakehands",
    }
    return d[k] if k is not None else d


def piplabel_to_mevalabel():
    d = {v: v for (k, v) in _v1_applabel_to_piplabel().items()}

    d = {k: "hand_interacts_with_person" if "hand" in v else v for (k, v) in d.items()}
    d = {
        k: v.replace("car", "vehicle")
        if (("_car" in v or "car_" in v) and ("carries" not in v))
        else v
        for (k, v) in d.items()
    }
    d = {
        k: v.replace("motorcycle", "vehicle") if "motorcycle" in v else v
        for (k, v) in d.items()
    }
    d = {
        k: v.replace("vehicle_trunk", "trunk") if "vehicle_trunk" in v else v
        for (k, v) in d.items()
    }
    d["person_transfers_object_to_car"] = "person_transfers_object"
    d["person_transfers_object_to_motorcycle"] = "person_transfers_object"
    d["person_transfers_object_to_person"] = "person_transfers_object"
    d["person_purchases_from_machine"] = "person_purchases"
    d["person_purchases_from_cashier"] = "person_purchases"
    d = {
        k: v
        for (k, v) in d.items()
        if k
        not in set(["person_closes_motorcycle_door", "person_opens_motorcycle_door"])
    }
    return d


def mevalabel_to_index():

    return {
        "hand_interacts_with_person": 0,
        "person_abandons_package": 1,
        "person_carries_heavy_object": 2,
        "person_closes_facility_door": 3,
        "person_closes_trunk": 4,
        "person_closes_vehicle_door": 5,
        "person_embraces_person": 6,
        "person_enters_scene_through_structure": 7,
        "person_enters_vehicle": 8,
        "person_exits_scene_through_structure": 9,
        "person_exits_vehicle": 10,
        "person_interacts_with_laptop": 11,
        "person_loads_vehicle": 12,
        "person_opens_facility_door": 13,
        "person_opens_trunk": 14,
        "person_opens_vehicle_door": 15,
        "person_picks_up_object": 16,
        "person_purchases": 17,
        "person_puts_down_object": 18,
        "person_reads_document": 19,
        "person_rides_bicycle": 20,
        "person_sits_down": 21,
        "person_stands_up": 22,
        "person_steals_object": 23,
        "person_talks_on_phone": 24,
        "person_talks_to_person": 25,
        "person_texts_on_phone": 26,
        "person_transfers_object": 27,
        "person_unloads_vehicle": 28,
        "vehicle_drops_off_person": 29,
        "vehicle_makes_u_turn": 30,
        "vehicle_picks_up_person": 31,
        "vehicle_reverses": 32,
        "vehicle_starts": 33,
        "vehicle_stops": 34,
        "vehicle_turns_left": 35,
        "vehicle_turns_right": 36,
    }


def piplabel_to_index():
    return {
        "car_drops_off_person": 0,
        "car_makes_u_turn": 1,
        "car_picks_up_person": 2,
        "car_reverses": 3,
        "car_starts": 4,
        "car_stops": 5,
        "car_turns_left": 6,
        "car_turns_right": 7,
        "hand_interacts_with_person_highfive": 8,
        "hand_interacts_with_person_holdhands": 9,
        "hand_interacts_with_person_shakehands": 10,
        "motorcycle_drops_off_person": 11,
        "motorcycle_makes_u_turn": 12,
        "motorcycle_picks_up_person": 13,
        "motorcycle_reverses": 14,
        "motorcycle_starts": 15,
        "motorcycle_stops": 16,
        "motorcycle_turns_left": 17,
        "motorcycle_turns_right": 18,
        "person_abandons_package": 19,
        "person_carries_heavy_object": 20,
        "person_closes_car_door": 21,
        "person_closes_car_trunk": 22,
        "person_closes_facility_door": 23,
        "person_closes_motorcycle_trunk": 24,
        "person_embraces_person": 25,
        "person_enters_car": 26,
        "person_enters_scene_through_structure": 27,
        "person_exits_car": 28,
        "person_exits_scene_through_structure": 29,
        "person_interacts_with_laptop": 30,
        "person_loads_car": 31,
        "person_loads_motorcycle": 32,
        "person_opens_car_door": 33,
        "person_opens_car_trunk": 34,
        "person_opens_facility_door": 35,
        "person_opens_motorcycle_trunk": 36,
        "person_picks_up_object": 37,
        "person_purchases_from_machine": 38,
        "person_puts_down_object": 39,
        "person_reads_document": 40,
        "person_rides_bicycle": 41,
        "person_sits_down": 42,
        "person_stands_up": 43,
        "person_steals_object": 44,
        "person_talks_on_phone": 45,
        "person_talks_to_person": 46,
        "person_texts_on_phone": 47,
        "person_transfers_object_to_car": 48,
        "person_transfers_object_to_motorcycle": 49,
        "person_transfers_object_to_person": 50,
        "person_unloads_car": 51,
        "person_unloads_motorcycle": 52,
    }



def pip_250k_powerset():
    return {('car_drops_off_person',): 0,
            ('car_drops_off_person', 'car_starts'): 1,
            ('car_drops_off_person', 'car_starts', 'car_stops'): 2,
            ('car_drops_off_person', 'car_stops'): 3,
            ('car_makes_u_turn',): 4,
            ('car_makes_u_turn', 'car_turns_left'): 5,
            ('car_makes_u_turn', 'car_turns_left', 'car_turns_right'): 6,
            ('car_makes_u_turn', 'car_turns_right'): 7,
            ('car_picks_up_person',): 8,
            ('car_picks_up_person', 'car_starts'): 9,
            ('car_picks_up_person', 'car_starts', 'car_stops'): 10,
            ('car_picks_up_person', 'car_stops'): 11,
            ('car_reverses',): 12,
            ('car_reverses', 'car_turns_left'): 13,
            ('car_reverses', 'car_turns_right'): 14,
            ('car_starts',): 15,
            ('car_starts', 'car_stops'): 16,
            ('car_starts', 'car_turns_left'): 17,
            ('car_starts', 'car_turns_right'): 18,
            ('car_stops',): 19,
            ('car_stops', 'car_turns_left'): 20,
            ('car_stops', 'car_turns_right'): 21,
            ('car_turns_left',): 22,
            ('car_turns_left', 'car_turns_right'): 23,
            ('car_turns_right',): 24,
            ('hand_interacts_with_person_highfive',): 25,
            ('hand_interacts_with_person_highfive', 'person_talks_to_person'): 26,
            ('motorcycle_drops_off_person',): 27,
            ('motorcycle_drops_off_person', 'motorcycle_starts'): 28,
            ('motorcycle_drops_off_person', 'motorcycle_starts', 'motorcycle_stops'): 29,
            ('motorcycle_drops_off_person', 'motorcycle_stops'): 30,
            ('motorcycle_makes_u_turn',): 31,
            ('motorcycle_makes_u_turn', 'motorcycle_turns_left'): 32,
            ('motorcycle_makes_u_turn',
             'motorcycle_turns_left',
             'motorcycle_turns_right'): 33,
            ('motorcycle_makes_u_turn', 'motorcycle_turns_right'): 34,
            ('motorcycle_picks_up_person',): 35,
            ('motorcycle_picks_up_person', 'motorcycle_starts'): 36,
            ('motorcycle_picks_up_person', 'motorcycle_starts', 'motorcycle_stops'): 37,
            ('motorcycle_picks_up_person', 'motorcycle_stops'): 38,
            ('motorcycle_reverses',): 39,
            ('motorcycle_starts',): 40,
            ('motorcycle_starts', 'motorcycle_stops'): 41,
            ('motorcycle_stops',): 42,
            ('motorcycle_turns_left',): 43,
            ('motorcycle_turns_left', 'motorcycle_turns_right'): 44,
            ('motorcycle_turns_right',): 45,
            ('person',): 46,
            ('person_abandons_object',): 47,
            ('person_abandons_object', 'person_puts_down_object_on_floor'): 48,
            ('person_carries_heavy_object',): 49,
            ('person_closes_car_door',): 50,
            ('person_closes_car_door', 'person_enters_car'): 51,
            ('person_closes_car_door',
             'person_enters_car',
             'person_exits_car',
             'person_opens_car_door'): 52,
            ('person_closes_car_door', 'person_enters_car', 'person_opens_car_door'): 53,
            ('person_closes_car_door', 'person_exits_car'): 54,
            ('person_closes_car_door', 'person_exits_car', 'person_opens_car_door'): 55,
            ('person_closes_car_door', 'person_loads_car'): 56,
            ('person_closes_car_door', 'person_opens_car_door'): 57,
            ('person_closes_car_door', 'person_unloads_car'): 58,
            ('person_closes_car_trunk',): 59,
            ('person_closes_car_trunk', 'person_loads_car'): 60,
            ('person_closes_car_trunk', 'person_loads_car', 'person_opens_car_trunk'): 61,
            ('person_closes_car_trunk', 'person_opens_car_trunk'): 62,
            ('person_closes_car_trunk',
             'person_opens_car_trunk',
             'person_unloads_car'): 63,
            ('person_closes_car_trunk', 'person_unloads_car'): 64,
            ('person_closes_facility_door',): 65,
            ('person_closes_facility_door', 'person_enters_scene_through_structure'): 66,
            ('person_closes_facility_door',
             'person_enters_scene_through_structure',
             'person_exits_scene_through_structure',
             'person_opens_facility_door'): 67,
            ('person_closes_facility_door',
             'person_enters_scene_through_structure',
             'person_opens_facility_door'): 68,
            ('person_closes_facility_door',
             'person_enters_scene_through_structure',
             'person_opens_facility_door',
             'person_talks_on_phone'): 69,
            ('person_closes_facility_door',
             'person_enters_scene_through_structure',
             'person_talks_on_phone'): 70,
            ('person_closes_facility_door', 'person_exits_scene_through_structure'): 71,
            ('person_closes_facility_door',
             'person_exits_scene_through_structure',
             'person_opens_facility_door'): 72,
            ('person_closes_facility_door',
             'person_exits_scene_through_structure',
             'person_opens_facility_door',
             'person_talks_on_phone'): 73,
            ('person_closes_facility_door',
             'person_exits_scene_through_structure',
             'person_talks_on_phone'): 74,
            ('person_closes_facility_door', 'person_opens_facility_door'): 75,
            ('person_closes_facility_door',
             'person_opens_facility_door',
             'person_talks_on_phone'): 76,
            ('person_closes_facility_door', 'person_talks_on_phone'): 77,
            ('person_closes_motorcycle_trunk',): 78,
            ('person_closes_motorcycle_trunk', 'person_loads_motorcycle'): 79,
            ('person_closes_motorcycle_trunk',
             'person_loads_motorcycle',
             'person_opens_motorcycle_trunk'): 80,
            ('person_closes_motorcycle_trunk', 'person_opens_motorcycle_trunk'): 81,
            ('person_closes_motorcycle_trunk',
             'person_opens_motorcycle_trunk',
             'person_unloads_motorcycle'): 82,
            ('person_closes_motorcycle_trunk', 'person_unloads_motorcycle'): 83,
            ('person_embraces_person',): 84,
            ('person_embraces_person', 'person_holds_hand'): 85,
            ('person_embraces_person', 'person_talks_to_person'): 86,
            ('person_enters_car',): 87,
            ('person_enters_car', 'person_opens_car_door'): 88,
            ('person_enters_scene_through_structure',): 89,
            ('person_enters_scene_through_structure',
             'person_exits_scene_through_structure'): 90,
            ('person_enters_scene_through_structure',
             'person_exits_scene_through_structure',
             'person_opens_facility_door'): 91,
            ('person_enters_scene_through_structure', 'person_opens_facility_door'): 92,
            ('person_enters_scene_through_structure', 'person_talks_on_phone'): 93,
            ('person_exits_car',): 94,
            ('person_exits_car', 'person_opens_car_door'): 95,
            ('person_exits_scene_through_structure',): 96,
            ('person_exits_scene_through_structure', 'person_opens_facility_door'): 97,
            ('person_exits_scene_through_structure', 'person_talks_on_phone'): 98,
            ('person_holds_hand',): 99,
            ('person_holds_hand', 'person_talks_to_person'): 100,
            ('person_interacts_with_laptop',): 101,
            ('person_interacts_with_laptop', 'person_sits_down'): 102,
            ('person_interacts_with_laptop', 'person_stands_up'): 103,
            ('person_loads_car',): 104,
            ('person_loads_car', 'person_opens_car_trunk'): 105,
            ('person_loads_motorcycle',): 106,
            ('person_loads_motorcycle', 'person_opens_motorcycle_trunk'): 107,
            ('person_opens_car_door',): 108,
            ('person_opens_car_trunk',): 109,
            ('person_opens_facility_door',): 110,
            ('person_opens_facility_door', 'person_talks_on_phone'): 111,
            ('person_opens_motorcycle_trunk',): 112,
            ('person_opens_motorcycle_trunk', 'person_unloads_motorcycle'): 113,
            ('person_picks_up_object_from_floor',): 114,
            ('person_picks_up_object_from_shelf',): 115,
            ('person_picks_up_object_from_table',): 116,
            ('person_picks_up_object_from_table',
             'person_puts_down_object_on_table',
             'person_reads_document'): 117,
            ('person_picks_up_object_from_table', 'person_reads_document'): 118,
            ('person_purchases_from_cashier',): 119,
            ('person_purchases_from_machine',): 120,
            ('person_puts_down_object_on_floor',): 121,
            ('person_puts_down_object_on_shelf',): 122,
            ('person_puts_down_object_on_table',): 123,
            ('person_puts_down_object_on_table', 'person_reads_document'): 124,
            ('person_reads_document',): 125,
            ('person_reads_document', 'person_sits_down'): 126,
            ('person_reads_document', 'person_sits_down', 'person_stands_up'): 127,
            ('person_reads_document', 'person_stands_up'): 128,
            ('person_rides_bicycle',): 129,
            ('person_shakes_hand',): 130,
            ('person_shakes_hand', 'person_talks_to_person'): 131,
            ('person_sits_down',): 132,
            ('person_stands_up',): 133,
            ('person_steals_object_from_person',): 134,
            ('person_talks_on_phone',): 135,
            ('person_talks_to_person',): 136,
            ('person_texts_on_phone',): 137,
            ('person_transfers_object_to_car',): 138,
            ('person_transfers_object_to_motorcycle',): 139,
            ('person_transfers_object_to_person',): 140,
            ('person_unloads_car',): 141,
            ('person_unloads_motorcycle',): 142}




pip_to_meva = {'person_closes_car_door': 'person_closes_vehicle_door',
               'person_enters_car': 'person_enters_vehicle',
               'person_exits_car': 'person_exits_vehicle',
               'person_opens_car_door': 'person_opens_vehicle_door',
               'person_closes_car_trunk': 'person_closes_trunk',
               'person_loads_car': 'person_loads_vehicle',
               'person_opens_car_trunk': 'person_opens_trunk',
               'person_unloads_car': 'person_unloads_vehicle',
               'car_turns_left': 'vehicle_turns_left',
               'car_turns_right': 'vehicle_turns_right',
               'car_makes_u_turn': 'vehicle_makes_u_turn',
               'car_picks_up_person': 'vehicle_picks_up_person',
               'car_starts': 'vehicle_starts',
               'car_stops': 'vehicle_stops',
               'car_drops_off_person': 'vehicle_drops_off_person',
               'person_transfers_object_to_car': 'person_transfers_object',
               'car_reverses': 'vehicle_reverses',
               'person_enters_motorcycle': 'person_enters_vehicle',
               'person_exits_motorcycle': 'person_exits_vehicle',
               'person_closes_motorcycle_trunk': 'person_closes_trunk',
               'person_loads_motorcycle': 'person_loads_vehicle',
               'person_opens_motorcycle_trunk': 'person_opens_trunk',
               'person_unloads_motorcycle': 'person_unloads_vehicle',
               'motorcycle_turns_left': 'vehicle_turns_left',
               'motorcycle_turns_right': 'vehicle_turns_right',
               'motorcycle_makes_u_turn': 'vehicle_makes_u_turn',
               'motorcycle_picks_up_person': 'vehicle_picks_up_person',
               'motorcycle_starts': 'vehicle_starts',
               'motorcycle_stops': 'vehicle_stops',
               'motorcycle_drops_off_person': 'vehicle_drops_off_person',
               'person_transfers_object_to_motorcycle': 'person_transfers_object',
               'motorcycle_reverses': 'vehicle_reverses',
               'person_closes_facility_door': 'person_closes_facility_door',
               'person_enters_scene_through_structure': 'person_enters_scene_through_structure',
               'person_comes_into_scene_through_structure': 'person_enters_scene_through_structure',
               'person_exits_scene_through_structure': 'person_exits_scene_through_structure',
               'person_leaves_scene_through_structure': 'person_exits_scene_through_structure',
               'person_opens_facility_door': 'person_opens_facility_door',
               'person_reads_document': 'person_reads_document',
               'person_sits_down': 'person_sits_down',
               'person_stands_up': 'person_stands_up',
               'person_puts_down_object': 'person_puts_down_object',
               'person_picks_up_object': 'person_picks_up_object',
               'person_picks_up_object_from_table': 'person_picks_up_object',
               'person_picks_up_object_from_floor': 'person_picks_up_object',
               'person_picks_up_object_from_shelf': 'person_picks_up_object',
               'person_puts_down_object_on_table': 'person_puts_down_object',
               'person_puts_down_object_on_floor': 'person_puts_down_object',
               'person_puts_down_object_on_shelf': 'person_puts_down_object',
               'person_abandons_object': 'person_abandons_package',               
               'person_abandons_package': 'person_abandons_package',
               'person_abandons_bag': 'person_abandons_package',
               'person_carries_heavy_object': 'person_carries_heavy_object',
               'person_talks_on_phone': 'person_talks_on_phone',
               'person_texts_on_phone': 'person_texts_on_phone',
               'person_interacts_with_laptop': 'person_interacts_with_laptop',
               'person_purchases_from_machine': 'person_purchases',
               'person_rides_bicycle': 'person_rides_bicycle',
               'person_talks_to_person': 'person_talks_to_person',
               'hand_interacts_with_person_highfive': 'hand_interacts_with_person',
               'person_steals_object': 'person_steals_object',
               'person_steals_object_from_person': 'person_steals_object',
               'person_purchases_from_cashier': 'person_purchases',
               'person_transfers_object_to_person': 'person_transfers_object',
               'person_embraces_person': 'person_embraces_person',
               'hand_interacts_with_person_holdhands': 'hand_interacts_with_person',
               'hand_interacts_with_person_shakehands': 'hand_interacts_with_person',
               'person_shakes_hand': 'hand_interacts_with_person',
               'person_holds_hand': 'hand_interacts_with_person'}
    

pip_to_shortlabel = {'car_drops_off_person': 'drops-off person',
                     'car_makes_u_turn': 'u-turn',
                     'car_picks_up_person': 'picks-up person',
                     'car_reverses': 'reverses',
                     'car_starts': 'starts',
                     'car_stops': 'stops',
                     'car_turns_left': 'turns left',
                     'car_turns_right': 'turns right',
                     'hand_interacts_with_person_highfive': 'high five',
                     'hand_interacts_with_person_holdhands': 'hold hands',
                     'hand_interacts_with_person_shakehands': 'shake hands',
                     'motorcycle_drops_off_person': 'drops-off person',
                     'motorcycle_makes_u_turn': 'u-turn',
                     'motorcycle_picks_up_person': 'picks-up person',
                     'motorcycle_reverses': 'reverses',
                     'motorcycle_starts': 'starts',
                     'motorcycle_stops': 'stops',
                     'motorcycle_turns_left': 'turns left',
                     'motorcycle_turns_right': 'turns right',
                     'person_abandons_object': 'abandons',                     
                     'person_abandons_bag': 'abandons',
                     'person_abandons_package': 'abandons',
                     'person_carries_heavy_object': 'carries',
                     'person_closes_car_door': 'closes car door',
                     'person_closes_car_trunk': 'closes trunk',
                     'person_closes_facility_door': 'closes door',
                     'person_closes_motorcycle_trunk': 'closes trunk',
                     'person_comes_into_scene_through_structure': 'enters scene',
                     'person_embraces_person': 'hugs',
                     'person_enters_car': 'enters car',
                     'person_enters_motorcycle': 'enters motorcycle',
                     'person_enters_scene_through_structure': 'enters scene',
                     'person_exits_car': 'exits car',
                     'person_exits_motorcycle': 'exits motorcycle',
                     'person_exits_scene_through_structure': 'exits scene',
                     'person_holds_hand': 'hold hands',
                     'person_interacts_with_laptop': 'uses laptop',
                     'person_leaves_scene_through_structure': 'exits scene',
                     'person_loads_car': 'loads',
                     'person_loads_motorcycle': 'loads',
                     'person_opens_car_door': 'opens car door',
                     'person_opens_car_trunk': 'opens trunk',
                     'person_opens_facility_door': 'opens door',
                     'person_opens_motorcycle_trunk': 'opens trunk',
                     'person_picks_up_object': 'picks up',
                     'person_picks_up_object_from_floor': 'picks up',
                     'person_picks_up_object_from_shelf': 'picks up',
                     'person_picks_up_object_from_table': 'picks up',
                     'person_purchases_from_cashier': 'purchases (cashier)',
                     'person_purchases_from_machine': 'purchases (machine)',
                     'person_puts_down_object': 'puts down',
                     'person_puts_down_object_on_floor': 'puts down',
                     'person_puts_down_object_on_shelf': 'puts down',
                     'person_puts_down_object_on_table': 'puts down',
                     'person_reads_document': 'reads',
                     'person_rides_bicycle': 'rides',
                     'person_shakes_hand': 'shake hands',
                     'person_sits_down': 'sits',
                     'person_stands_up': 'stands',
                     'person_steals_object': 'steals',
                     'person_steals_object_from_person': 'steals',
                     'person_talks_on_phone': 'talks on phone',
                     'person_talks_to_person': 'talks to',
                     'person_texts_on_phone': 'texts',
                     'person_transfers_object_to_car': 'transfers',
                     'person_transfers_object_to_motorcycle': 'transfers',
                     'person_transfers_object_to_person': 'transfers',
                     'person_unloads_car': 'unloads',
                     'person_unloads_motorcycle': 'unloads',
                     'person_walks': 'walks',
                     'person':'person',
                     'vehicle':'vehicle'}
