import * as ec2 from '@aws-cdk/aws-ec2';
import * as ecs from '@aws-cdk/aws-ecs';
import * as elbv2 from '@aws-cdk/aws-elasticloadbalancingv2';
import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface DualAlbFargateServiceProps {
    /**
     * @stability stable
     */
    readonly vpc?: ec2.IVpc;
    /**
     * @stability stable
     */
    readonly tasks: FargateTaskProps[];
    /**
     * @stability stable
     */
    readonly route53Ops?: Route53Options;
    /**
     * create a FARGATE_SPOT only cluster.
     *
     * @default false
     * @stability stable
     */
    readonly spot?: boolean;
    /**
     * Whether to enable ECS Exec support.
     *
     * @default false
     * @see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-exec.html
     * @stability stable
     */
    readonly enableExecuteCommand?: boolean;
}
/**
 * @stability stable
 */
export interface FargateTaskProps {
    /**
     * @stability stable
     */
    readonly task: ecs.FargateTaskDefinition;
    /**
     * @stability stable
     */
    readonly listenerPort: number;
    /**
     * desired number of tasks for the service.
     *
     * @default 1
     * @stability stable
     */
    readonly desiredCount?: number;
    /**
     * service autoscaling policy.
     *
     * @stability stable
     */
    readonly scalingPolicy?: ServiceScalingPolicy;
    /**
     * @stability stable
     */
    readonly capacityProviderStretegy?: ecs.CapacityProviderStrategy[];
}
/**
 * @stability stable
 */
export interface ServiceScalingPolicy {
    /**
     * max capacity for the service autoscaling.
     *
     * @default 10
     * @stability stable
     */
    readonly maxCapacity?: number;
    /**
     * target cpu utilization.
     *
     * @default 50
     * @stability stable
     */
    readonly targetCpuUtilization?: number;
    /**
     * request per target.
     *
     * @default 1000
     * @stability stable
     */
    readonly requestPerTarget?: number;
}
/**
 * @stability stable
 */
export interface Route53Options {
    /**
     * private zone name.
     *
     * @default svc.local
     * @stability stable
     */
    readonly zoneName?: string;
    /**
     * the external ALB record name.
     *
     * @default external
     * @stability stable
     */
    readonly externalAlbRecordName?: string;
    /**
     * the internal ALB record name.
     *
     * @default internal
     * @stability stable
     */
    readonly internalAlbRecordName?: string;
}
/**
 * @stability stable
 */
export declare class DualAlbFargateService extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly externalAlb: elbv2.ApplicationLoadBalancer;
    /**
     * @stability stable
     */
    readonly internalAlb: elbv2.ApplicationLoadBalancer;
    /**
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * The service(s) created from the task(s).
     *
     * @stability stable
     */
    readonly service: ecs.FargateService[];
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: DualAlbFargateServiceProps);
}
