"""
Official CNA short name to org id mapping. This is created using the below code snippet from the latest CVE v5 list

```shell
git clone https://github.com/CVEProject/cvelistV5
cd cvelistV5
```

```python
from pathlib import Path
import json

assigner_map = {}
for f in Path(".").glob('**/*/CVE*.json'):
    print (f)
    with open(f, mode="r") as fp:
        obj = json.load(fp)
        if obj.get("cveMetadata", {}).get("assignerShortName"):
            assigner_map[obj.get("cveMetadata", {}).get("assignerShortName").lower()] = obj.get("cveMetadata", {}).get("assignerOrgId")

with open("maps.json", mode="w") as fp:
    json.dump(assigner_map, fp, indent=4)
```
"""
ASSIGNER_UUID_MAP = {
    "nvd@nist.gov": "8254265b-2729-46b6-b9e3-3dfca2d5bfca",
    "cve@mitre.org": "8254265b-2729-46b6-b9e3-3dfca2d5bfca",
    "mitre": "8254265b-2729-46b6-b9e3-3dfca2d5bfca",
    "redhat": "53f830b8-0a3f-465b-8143-3b8a9948e749",
    "certcc": "37e5125f-f79b-445b-8fad-9564f167944b",
    "sgi": "bc94ec7e-8909-4cbb-83df-d2fc9330fa88",
    "apple": "286789f9-fbc2-4510-9f9a-43facdede74c",
    "debian": "79363d38-fa19-49d1-9214-5f28da3f3ac5",
    "adobe": "078d4453-3bcd-4900-85e6-15281da43538",
    "ibm": "9a959283-ebb5-44b6-b705-dcc2bbced522",
    "freebsd": "63664ac6-956c-4cba-a5d0-f46076e16109",
    "canonical": "cc1ad9ee-3454-478d-9317-d3e869d708bc",
    "microsoft": "f38d906d-7342-40ea-92c1-6c4a2c6478c8",
    "vuldb": "1af790b2-7ee1-4545-860a-a788eba489b5",
    "microfocus": "f81092c5-7f14-476d-80dc-24857f90be84",
    "symantec": "80d3bcb6-88de-48c2-a47e-aebf795f19b5",
    "apache": "f0158376-9dc2-43b6-827c-5f631a4d8d09",
    "flexera": "44d08088-2bea-4760-83a6-1e9be26b15ab",
    "cisco": "d1c1063e-7a18-46af-9102-31f8928bc633",
    "oracle": "43595867-4340-4103-b7a2-9a5208d29a85",
    "hp": "74586083-13ce-40fd-b46a-8e5d23cfbcb2",
    "jpcert": "ede6fdc4-6654-4307-a26d-3331c018e2ce",
    "dell": "c550e75a-17ff-4988-97f0-544cde3820fe",
    "mozilla": "f16b083a-5664-49f3-a51e-8d479e5ed7fe",
    "airbus": "24a3c815-5f22-4d74-967a-30958d6466f4",
    "icscert": "7d14cffa-0d7d-4270-9dc0-52cabd5a23a6",
    "chrome": "ebfee0ef-53dd-4cf3-9e2a-08a5bd7a7e28",
    "isc": "404fd4d2-a609-4245-b543-2c944a302a22",
    "vmware": "dcf2e128-44bd-42ed-91e8-88f912c1401d",
    "go": "1bb62c36-49e3-4200-9d77-64a1400537cc",
    "larry_cashdollar": "461b2335-328f-427d-ae3d-eff7d6814455",
    "google_android": "baff130e-b8d5-4e15-b3d3-c3cf5d5545c6",
    "intel": "6dda929c-bb53-4a77-a76d-48e79601a1ce",
    "qualcomm": "2cfc7d3e-20d3-47ac-8db7-1b7285aff15f",
    "hackerone": "36234546-b8fa-4601-9d6f-f4e334aa8ea1",
    "fortinet": "6abe59d8-c742-4dff-8ce8-9b0ca1073da8",
    "siemens": "cec7a2ec-15b4-4faf-bd53-b40f371f3a77",
    "huawei": "25ac1063-e409-4190-8079-24548c77ea2e",
    "wpscan": "1bfdd5d7-9bf6-4a53-96ea-42e2716d7a81",
    "certvde": "270ccfa6-a436-4e77-922e-914ec3a9685c",
    "wordfence": "b15e7b5b-3da4-40ae-a43c-f7aa60e62599",
    "zdi": "99f1926a-a320-47d8-bbb5-42feb611262e",
    "ca": "e291eae9-7c0a-46ac-ba7d-5251811f8b7f",
    "hpe": "eb103674-0d28-4225-80f8-39fb86215de0",
    "juniper": "8cbe9d5a-a066-4c94-8978-4b15efeae968",
    "tibco": "4f830c72-39e4-45f6-a99f-78cc01ae04db",
    "elastic": "271b6943-45a9-4f3a-ab4e-976f3fa05b5a",
    "synology": "db201096-a0cc-46c7-9a55-61d9e221bf01",
    "blackberry": "dbe78b00-5e7b-4fda-8748-329789ecfc5c",
    "nvidia": "9576f279-3576-44b5-a4af-b9a8644b2de6",
    "f5": "9dacffd4-cb11-413f-8451-fbbfd4ddc0ab",
    "puppet": "ca2a266c-be2f-4d4b-92d0-47b76b1a9c4e",
    "rapid7": "9974b330-7714-4307-a722-5648477acda7",
    "netapp": "11fdca00-0482-4c88-a206-37f9c182c87d",
    "openssl": "3a12439a-ef3a-4c79-92e6-6081a721f1e5",
    "checkpoint": "897c38be-0345-43cd-b6cf-fe179e0c4f45",
    "trellix": "01626437-bf8f-4d1c-912a-893b5eb04808",
    "brocade": "87b297d7-335e-4844-9551-11b97995a791",
    "lenovo": "da227ddf-6e25-4b41-b023-0f976dcaca4b",
    "talos": "b86d76f8-0f8a-4a96-a78d-d8abfc7fc29b",
    "yandex": "a51c9250-e584-488d-808b-03e6f1386796",
    "obdev": "e0cebea7-a708-4bfe-81c1-855d35eb4544",
    "marklogic": "e0dcfa7a-8a53-4e5c-958e-bbea8ff83f37",
    "krcert": "cdd7a122-0fae-4202-8d86-14efbacc2863",
    "joshbressers": "46fe6300-5254-4a98-9594-a9567bec8179",
    "kubernetes": "a6081bf6-c852-4425-ad4f-a67919267565",
    "fedora": "92fb86c3-55a5-4fb5-9c3f-4757b9e96dc5",
    "dwf": "7556d962-6fb7-411e-85fa-6cd62f095ba8",
    "netflix": "ea63fd80-a441-4c7b-ba78-e48a8071cae2",
    "zte": "6786b568-6808-4982-b61f-398b0d9679eb",
    "trendmicro": "7f7bd7df-cffe-4fdb-ab6d-859363b89272",
    "duo": "7cd4c57f-0a88-4dda-be53-70336b413766",
    "tenable": "5ac1ecc2-367a-4d16-a0b2-35d495ddd0be",
    "kaspersky": "e45d732a-8f6b-4b6b-be76-7420f6a2b988",
    "qnap": "2fd009eb-170a-4625-932b-17a53af1051f",
    "zephyr": "e2e69745-5e70-4e92-8431-deb5529a81ad",
    "atlassian": "f08a6ab8-ed46-4c22-8884-d911ccfe3c66",
    "forcepoint": "e23ea22c-8c39-4eff-8980-2881e5ae54e2",
    "nodejs": "386269d4-a6c6-4eaa-bf8e-bc0b0d010558",
    "sap": "e4686d1a-f260-4930-ac4c-2f5c992778dd",
    "hcl": "1e47fe04-f25f-42fa-b674-36de2c5e3cfc",
    "vaadin": "9e0f3122-90e9-42d5-93de-8c6b98deef7e",
    "incibe": "0cbda920-cd7f-484a-8e76-bf7f4b7f4516",
    "axis": "f2daf9a0-02c2-4b83-a01d-63b3b304b807",
    "drupal": "2c85b837-eb8b-40ed-9d74-228c62987387",
    "netgear": "a2826606-91e7-4eb6-899e-8484bd4575d5",
    "eclipse": "e51fbebd-6053-4e49-959f-1b94eeb69a2c",
    "schneider": "076d1eb6-cfab-4401-b34d-6dfc2a413bdb",
    "dahua": "79ee569e-7d1e-4364-98f0-3a18e2a739ad",
    "snyk": "bae035ff-b466-4ff4-94d0-fc9efd9e1730",
    "palo_alto": "d6c1279f-00f6-4ef7-9217-f89ffe703ec0",
    "hillstone": "2b565742-f273-46f9-b583-07c1fcdea31a",
    "naver": "f9629fae-ca2e-4fbf-9785-3ed86476aef6",
    "avaya": "9d670455-bdb5-4cca-a883-5914865f5d96",
    "odoo": "22c90092-d340-4fb8-a06e-f1193e012523",
    "tcpdump": "cfdbb673-b408-4d03-89c1-c3d73ed80896",
    "cspcert": "8207d157-a9c5-4c55-ab16-b67a7ac0b646",
    "twcert": "cded6c7f-6ce5-4948-8f87-aa7a3bbb6b0e",
    "360st": "40f8fa2f-7875-43d0-a30e-e901a5537754",
    "facebook": "4fc57720-52fe-4431-a0fb-3d2c8747b827",
    "mongodb": "a39b4221-9bd0-4244-95fc-f3e2e07f1deb",
    "hikvision": "da451dce-859b-4e51-8b87-9c8b60d19b32",
    "sonicwall": "44b2ff79-1416-4492-88bb-ed0da00c7315",
    "jenkins": "39769cd5-e6e2-4dc8-927e-97b3aa056f5b",
    "php": "dd77f84a-d19a-4638-8c3d-a322d820ed2b",
    "pivotal": "862b2186-222f-48b9-af87-f1fb7bb26d03",
    "bosch": "c95f66b2-7e7c-41c5-8f09-6f86ec68659c",
    "bitdefender": "b3d5ebe7-963e-41fb-98e1-2edaeabb8f82",
    "floragunn": "9f311a02-c44f-4938-8530-9219246b8255",
    "salesforce": "c9b25dee-ae6d-4083-ba23-638c500cc364",
    "github_m": "a0819718-46f1-4df5-94e2-005712e83aaa",
    "suse": "404e59f5-483d-4b8a-8e7a-e67604dd8afb",
    "abb": "2b718523-d88f-4f37-9bbd-300c20644bf9",
    "opera": "9aee7086-24f5-48b4-9428-908ac90b8b54",
    "linux": "416baaa9-dc9f-4396-8d5f-8c081fb06d67",
    "autodesk": "7e40ea87-bc65-4944-9723-dd79dd760601",
    "jci": "7281d04a-a537-43df-bfb4-fa4110af9d01",
    "document fdn.": "4fe7d05b-1353-44cc-8b7a-1e416936dff2",
    "alias": "dc524f69-879d-41dc-ab8f-724e78658a1a",
    "github_p": "82327ea3-741d-41e4-88f8-2cf9e791e760",
    "zscaler": "73c6f63b-efac-410d-a0a9-569700f85a04",
    "oppo": "7f2b1ad8-5432-4d64-91a1-9099af1cc695",
    "opentext": "f81092c5-7f14-476d-80dc-24857f90be84",
    "silver peak": "83cc1b1a-46b0-4ac1-94f2-bbef3319bc4c",
    "vivo": "c6f5cd8e-fe3d-4460-82c2-f8a4e7b272c8",
    "amd": "b58fc414-a1e4-4f92-9d70-1add41838648",
    "teradici": "ba3c294d-a544-4fff-ad44-2de7c7bbb6be",
    "gitlab": "ceab7361-8a18-47b1-92ba-4d7d25f6715a",
    "tigera": "e6d453f4-3dae-4941-bcea-9af25f4e824d",
    "swi": "747bec18-acd0-4d99-a5c8-5e366c66ab7e",
    "xiaomi": "b57733aa-7326-4f07-8e09-0be8e0df1909",
    "openvpn": "36a55730-e66d-4d39-8ca6-3c3b3017965e",
    "openeuler": "7e1ac599-2767-43fa-b3ea-f10178cc98f2",
    "gallagher": "0c426f27-3ee1-4eff-be88-288d5a1822bc",
    "otrs": "2e1bf29f-dc29-4ed8-830c-7b9348b6f0e8",
    "cloudflare": "a22f1246-ba21-4bb4-a601-ad51614c1513",
    "crafter": "4ff2b028-869f-4b00-a7b2-05997f6f14fd",
    "vdoo": "6b4ace4a-d6e0-415b-9ce8-aa20e97e4b24",
    "ea": "442d7a9f-d735-4edc-91a9-bdd618cbff51",
    "mend": "478c68dd-22c1-4a41-97cd-654224dfacff",
    "nlnet labs": "206fc3a0-e175-490b-9eaa-a5738056c9f6",
    "secomea": "f2815942-3388-4c08-ba09-6c15850fda90",
    "csw": "ee1bbb37-1770-46bd-bba8-910037954ee0",
    "mattermost": "9302f53e-dde5-4bf3-b2f2-a83f91ac0eee",
    "sick ag": "a6863dd2-93fc-443d-bef1-79f0b5020988",
    "hitachi": "50d0f415-c707-4733-9afc-8f6c0e9b3f82",
    "joomla": "6ff30186-7fb7-4ad9-be33-533e7b05e586",
    "sophos": "526a354d-e866-4174-ae7d-bac848e5c4c5",
    "eaton": "63703b7d-23e2-41ef-94b3-a3c6333f7759",
    "google": "14ed7db2-1595-443d-9d34-6215bf890778",
    "mitsubishi": "e0f77b61-78fd-4786-b3fb-1ee347a748ad",
    "nec": "f2760a35-e0d8-4637-ac4c-cc1a2de3e282",
    "patchstack": "21595511-bba5-4825-b968-b78d1f9984a3",
    "mirantis": "ac17a704-eccd-4263-a802-5cee95c1d547",
    "jfrog": "48a46f29-ae42-4e1d-90dd-c1676c1e5e6d",
    "samsung mobile": "3af57064-a867-422c-b2ad-40307b65c458",
    "splunk": "42b59230-ec95-491e-8425-5a5befa1a469",
    "octopus": "6f4f8c89-ef06-4bae-a2a5-6734ddf76272",
    "nozomi": "bec8025f-a851-46e5-b3a3-058e6b0aa23c",
    "pega": "c91e5604-2bd1-401f-a0ec-b25342b57ef9",
    "mautic": "4e531c38-7a33-45d3-98dd-d909c0d8852e",
    "tianocore": "65518388-201a-4f93-8712-366d21fe8d2c",
    "arista": "c8b34d1a-69ae-45c3-88fe-f3b3d44f39b7",
    "xen": "23aa2041-22e1-471f-9209-9b7396fa234f",
    "esri": "cedc17bb-4939-4f40-a1f4-30ae8af1094e",
    "deepsurface": "17539d52-06bd-4776-9c7a-95dc115e9083",
    "mediatek": "ee979b05-11f8-4f25-a7e0-a1fa9c190374",
    "ping identity": "5998a2e9-ae88-42cd-b6e0-7564fd979f9e",
    "solarwinds": "49f11609-934d-4621-84e6-e02e032104d6",
    "@huntrdev": "c09c270a-b464-47c1-9133-acb35b22c19a",
    "snps": "8cad7728-009c-4a3d-a95e-ca62e6ff8a0b",
    "f-secureus": "126858f1-1b65-4b74-81ca-7034f7f7723f",
    "alibaba": "0cc2b86d-1d45-434d-ae74-11d09ec61ae8",
    "zoom": "99b9af0d-a833-4a5d-9e2f-8b1324f35351",
    "acronis": "73dc0fef-1c66-4a72-9d2d-0a0f4012c175",
    "zyxel": "96e50032-ad0d-4058-a115-4d2c13821f9f",
    "fidelis": "11ea3a0d-87b4-4e67-a1fa-f5a6be5d6676",
    "hitachi energy": "e383dce4-0c27-4495-91c4-0db157728d17",
    "line": "657f3255-0560-4aed-82e4-7f579ec6acfb",
    "incd": "a57ee1ae-c9c1-4f40-aa7b-cf10760fde3f",
    "eset": "4a9b9929-2450-4021-b7b9-469a0255b215",
    "synaptics": "54bb2a58-4278-44a9-851f-17e74ee51f48",
    "tr-cert": "ca940d4e-fea4-4aa2-9a58-591a58b1ce21",
    "netmotion": "b6533044-ea05-4482-8458-7bddeca0d079",
    "appcheck": "2c188fdb-58e1-4908-8fce-3e437b94f1ae",
    "snow": "ea911274-ddd9-4e68-b39a-d7d6ae8b8a65",
    "m-files corporation": "bcf7a16e-bfdc-46e4-9e42-4187da3f4410",
    "ncsc.ch": "455daabc-a392-441d-aa46-37d35189897c",
    "divd": "b87402ff-ae37-4194-9dae-31abdbd6f217",
    "devolutions": "bfee16bd-18e6-446c-9a65-f5b2e3d89c23",
    "tha-psirt": "9d5917ae-205d-4ae5-8749-1f49479b1395",
    "govtech csg": "1a37b84a-8e51-4525-b3d6-87e2fae01dbd",
    "replicated": "7d06583b-61c8-4499-8067-80a92a3b48e1",
    "netskope": "bf992f6a-e49d-4e94-9479-c4cff32c62bc",
    "hitvan": "dce6e192-ff49-4263-9134-f0beccb9bc13",
    "artica": "63375d6c-d89a-45ed-8ecc-c8c361b0e04c",
    "forgerock": "6b18ae97-0aab-4af2-9ba4-74b2b139ddfa",
    "zowe": "b1336bef-059d-4e13-b11b-9a6ef21b3c78",
    "cert-in": "66834db9-ab24-42b4-be80-296b2e40335c",
    "swift": "e4a1ddda-f4f5-496e-96c8-82c37d06abd0",
    "fluid attacks": "84fe0718-d6bb-4716-a7e8-81a6d1daa869",
    "logitech": "b573e801-1dd3-4adf-bd73-c9b814fbe067",
    "okta": "59b22baa-87b2-4371-8e4a-e080df12f74a",
    "anolis": "cb8f1db9-b4b1-487b-a760-f65c4f368d8e",
    "hypr": "0dc7baee-4a9f-419f-bd0a-e21ec5dac512",
    "bd": "2325d071-eabf-4b7b-a4ea-0819b6629a18",
    "wdc psirt": "cb3b742e-5145-4748-b44b-5ffd45bf3b6a",
    "zabbix": "72de3e22-0555-4a0d-ae81-9249e0f0a1e8",
    "tv": "13430f76-86eb-43b2-a71c-82c956ef31b6",
    "lge": "42f21055-226c-4bce-a3c8-ecf55a3551fb",
    "ncsc-nl": "cf4a7ff5-dd38-4ede-a530-ffaa7ea59c39",
    "silabs": "030b2754-1501-44a4-bef8-48be86a33bf4",
    "profelis": "3039e14d-1e9f-46c2-98a6-44436e4ca5d5",
    "citrix": "e437aed5-38e0-4fa3-a98b-cb73e7acaec6",
    "baxter": "dba971b9-eb30-4121-91e1-3b45611354aa",
    "palantir": "bbcbe11d-db20-4bc2-8a6e-c79f87041fd4",
    "jetbrains": "547ada31-17d8-4964-bc5f-1b8238ba8014",
    "nlok": "dbd8429d-f261-4b1e-94cc-ae3132817e2e",
    "hw": "ff95705b-1a40-4639-8017-a58fa868baee",
    "openbmc": "7eaec9cd-e18a-43f9-bb90-5f82d308c514",
    "unisoc": "63f92e9c-2193-4c24-98a9-93640392c3d3",
    "carrier": "e24e6442-3ae1-4538-a7b8-7ac95586db8f",
    "medtronic": "3c337f33-b2bd-4529-9792-f48cdb2838b4",
    "shopbeat": "d3f162d7-5820-4c58-beef-03f43baaf8ad",
    "openharmony": "0cf5dd6e-1214-4398-a481-30441e48fafd",
    "yugabyte": "d4ae51d3-4db5-465e-bc8a-eb6768324078",
    "asustor1": "f35eaae9-79f2-4d0d-a5c7-7bea6ed6be77",
    "ge gp": "2cf0fb33-79e2-44e0-beb8-826cc5ce3250",
    "cybellum": "24e70c8d-eeca-431d-8285-199a41b4014e",
    "rockwell": "b73dd486-f505-4403-b634-40b078b177f0",
    "tml": "07aac9b9-e3e9-4d03-a447-764bd31371d7",
    "sn": "303448ea-6ef3-4077-ad29-5c9bf253c375",
    "hashicorp": "67fedba0-ff2e-4543-ba5b-aa93e87718cc",
    "tribe29": "f7d6281c-4801-44ce-ace2-493291dedb0f",
    "honeywell": "0dc86260-d7e3-4e81-ba06-3508e030ce8d",
    "arm": "56a131ea-b967-4a0d-a41e-5f3549952846",
    "knime": "296541fb-a0e3-4ca7-ab3d-683e666d143e",
    "sailpoint": "2cfc7547-56a0-4049-8b52-c3078e8a8719",
    "dragos": "12bdf821-1545-4a87-aac5-61670cc6fcef",
    "zuso art": "256c161b-b921-402b-8c3b-c6c9c14d5d88",
    "proofpoint": "d83a79dd-e128-4b83-8b64-84faf54eed46",
    "baidu": "7b443bca-21a2-4df8-b477-ec36491d9932",
    "securifera": "c35fbbdf-8d87-49b6-8120-920a36e62b7f",
    "onekey": "2d533b80-6e4a-4e20-93e2-171235122846",
    "xylem": "15c01472-ff32-4bec-916d-912e60a9fe4c",
    "grafana": "57da9224-a3e2-4646-9d0e-c4dc2e05e7da",
    "docker": "686469e6-3ff6-451b-ab8b-cf5b9e89401e",
    "aha": "26969f82-7e87-44d8-9cb5-f6fb926ddd43",
    "baicells": "084566ad-deee-4e89-acff-6b7b1bf9d4b7",
    "opennms": "70b007e9-5235-4ee5-90b5-a71a81beeda0",
    "canon": "f98c90f0-e9bd-4fa7-911b-51993f3571fd",
    "b.braun": "653264ec-f98b-4e8f-b8b4-540a01b7657d",
    "3ds": "f5a594e6-46a7-4e60-8a08-0a786e70e433",
    "genetec": "f2b06212-cb4b-41a4-9501-fa2e367495b8",
    "asrg": "c15abc07-96a9-4d11-a503-5d621bfe42ba",
    "star_labs": "b1571b85-cbc9-431f-830b-0c8155323a69",
    "honor": "3836d913-7555-4dd0-a509-f5667fdf5fe4",
    "checkmk": "f7d6281c-4801-44ce-ace2-493291dedb0f",
    "ox": "8ce71d90-2354-404b-a86e-bec2cc4e6981",
    "gandc": "ace9cabe-4f4f-416b-8c39-b0e002761924",
    "qualys": "8a309ac4-d8c7-4735-9c1d-ca39c5dfbcda",
    "purestorage": "3895c224-4e1d-482a-adb3-fa64795683ac",
    "panasonic corporation": "2163caeb-3942-4e93-a74b-8c75338146ce",
    "sel": "5804bb70-792c-43e0-8596-486cc0efe699",
    "42gears": "e5d7a401-f4d6-4559-911a-da9b371cd8ce",
    "@huntr_ai": "c09c270a-b464-47c1-9133-acb35b22c19a",
    "cyberdanube": "7d092a75-6bbd-48c6-a15a-0297458009bc",
    "halborn": "79d7e77b-4bd9-4e64-ae2c-02965b1d2b73",
    "vulncheck": "83251b91-4cc7-4094-a5c7-464a1b83ea10",
    "phoenix": "22d9ba52-f336-4b0d-bf1f-0efbdcc3c1de",
    "idemia": "a87f365f-9d39-4848-9b3a-58c7cae69cab",
    "moxa": "2e0a0ee2-d866-482a-9f5e-ac03d156dbaa",
    "liferay": "8b54e794-c6f0-462e-9faa-c1001a673ac3",
    "ami": "7e9044f1-7f56-4c38-8864-c0c7302263d6",
    "perforce": "ca2a266c-be2f-4d4b-92d0-47b76b1a9c4e",
    "dotcms": "5b9d93f2-25c7-46b4-ab60-d201718c9dd8",
    "blsops": "27b6da8a-f51d-48d9-9eef-9b7f3405d20d",
    "panasonic_holdings_corporation": "2163caeb-3942-4e93-a74b-8c75338146ce",
    "temporal": "61241ed8-fa44-4f23-92db-b8c443751968",
    "sk-cert": "bc375322-d3d7-4481-b261-e29662236cfd",
    "wolfssl": "50d2cd11-d01a-48ed-9441-5bfce9d63b27",
    "google_devices": "83238938-5644-45f0-9007-c0392bcf6222",
    "mim": "f77a3b2e-a86f-4a4e-80d3-3d1378fbb974",
    "opencloudos": "03686db1-8513-43c4-b487-c6ad847afd3a",
    "progresssoftware": "f9fea0b6-671e-4eea-8fde-31911902ae05",
    "vulsec": "2fdefc65-d750-4b8d-96ee-6e2c0c42dbfe",
    "xi": "902ff664-2e36-43e3-a1aa-3210c82d1b67",
    "samsung.tv_appliance": "ca193ba2-0cff-4e34-b04e-1ea07103c6fe",
    "payara": "769c9ae7-73c3-4e47-ae19-903170fc3eb8",
    "pandorafms": "63375d6c-d89a-45ed-8ecc-c8c361b0e04c",
    "cert-pl": "4bb8329e-dd38-46c1-aafb-9bf32bcb93c6",
    "samsungmobile": "3af57064-a867-422c-b2ad-40307b65c458",
    "softiron": "0a72a055-908d-47f5-a16a-1f09049c16c6",
    "1e": "4a68d2b9-b68a-4765-95bd-17f35092666b",
    "algosec": "ca5f073f-8266-4d43-b3e3-6eb0bb18a738",
    "sec-vlab": "551230f0-3615-47bd-b7cc-93e92e730bbf",
    "asr": "68630edc-a58c-4cbd-9b01-0e130455c8ae",
    "cisa-cg": "9119a7d8-5eab-497f-8521-727c672e3725",
    "mandiant": "027e81ed-0dd4-4685-ab4d-884aec5bb484",
    "ni": "bca5b2e8-03a4-4781-b4ca-c6a078c0bfd4",
    "greenrocketsecurity": "6a7d5611-ec52-41f4-b33a-a457deec1320",
    "lexmark": "7bc73191-a2b6-4c63-9918-753964601853",
    "hanwha_vision": "fc9afe74-3f80-4fb7-a313-e6f036a89882",
    "oda": "8a9629cb-c5e7-4d2a-a894-111e8039b7ea",
    "illumio": "ea070963-4842-4451-bceb-906a17f8dc69",
    "psf": "28c92f92-d60d-412d-b760-e73465c3df22",
    "yokogawagroup": "7168b535-132a-4efe-a076-338f829b2eb9",
    "papercut": "eb41dac7-0af8-4f84-9f6d-0272772514f4",
    "dfinity": "6b35d637-e00f-4228-858c-b20ad6e1d07b",
    "sra": "57dba5dd-1a03-47f6-8b36-e84e47d335d8",
    "nx": "96d4e157-0bf0-48b3-8efd-382c68caf4e0",
    "wso2": "ed10eef1-636d-4fbe-9993-6890dfa878f8",
    "fortra": "df4dee71-de3a-4139-9588-11b62fe6c0ff",
    "manageengine": "0fc0942c-577d-436f-ae8e-945763c79b02",
    "elan": "36106deb-8e95-420b-a0a0-e70af5d245df",
    "curl": "2499f714-1537-4658-8207-48ae4bb9eae9",
    "postgresql": "f86ef6dc-4d3a-42ad-8f28-e6d5547a5007",
    "sonatype": "103e4ec9-0a87-450b-af77-479448ddef11",
    "concretecms": "ff5b8ace-8b95-4078-9743-eac1ca5451de",
    "bt": "13061848-ea10-403d-bd75-c83a022c2891",
    "ly-corporation": "657f3255-0560-4aed-82e4-7f579ec6acfb",
    "hiddenlayer": "6f8de1f0-f67e-45a6-b68f-98777fdb759c",
    "ciena": "7bd90cf1-1651-495e-9ae8-9415fb3c9feb",
    "libreswan": "d42dc95b-23f1-4e06-9076-20753a0fb0df"
}
