#! /usr/bin/env python

# ***********************************************************************************
# * Copyright 2010 - 2016 Paulo A. Herrera. All rights reserved.                    *
# *                                                                                 *
# * Redistribution and use in source and binary forms, with or without              *
# * modification, are permitted provided that the following conditions are met:     *
# *                                                                                 *
# *  1. Redistributions of source code must retain the above copyright notice,      *
# *  this list of conditions and the following disclaimer.                          *
# *                                                                                 *
# *  2. Redistributions in binary form must reproduce the above copyright notice,   *
# *  this list of conditions and the following disclaimer in the documentation      *
# *  and/or other materials provided with the distribution.                         *
# *                                                                                 *
# * THIS SOFTWARE IS PROVIDED BY PAULO A. HERRERA ``AS IS'' AND ANY EXPRESS OR      *
# * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF    *
# * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO      *
# * EVENT SHALL <COPYRIGHT HOLDER> OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,        *
# * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,  *
# * BUT NOT LIMITED TO, PROCUREMEN OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,    *
# * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY           *
# * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING  *
# * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS              *
# * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                    *
# ***********************************************************************************

# **************************************************************
# * Example of how to use the high level imageToVTK function.  *
# **************************************************************

from pyevtk.hl import imageToVTK
import numpy as np

# Dimensions
nx, ny, nz = 6, 6, 2
ncells = nx * ny * nz
npoints = (nx + 1) * (ny + 1) * (nz + 1)

# Variables
pressure = np.random.rand(ncells).reshape((nx, ny, nz), order="C")
temp = np.random.rand(npoints).reshape((nx + 1, ny + 1, nz + 1))

imageToVTK("./image", cellData={"pressure": pressure}, pointData={"temp": temp})

fluxx = np.random.rand(ncells).reshape((nx, ny, nz), order="F")
fluxy = np.random.rand(ncells).reshape((nx, ny, nz), order="F")
fluxz = np.random.rand(ncells).reshape((nx, ny, nz), order="F")
flux = (fluxx, fluxy, fluxz)

Efieldx = np.random.rand(npoints).reshape((nx + 1, ny + 1, nz + 1), order="F")
Efieldy = np.random.rand(npoints).reshape((nx + 1, ny + 1, nz + 1), order="F")
Efieldz = np.random.rand(npoints).reshape((nx + 1, ny + 1, nz + 1), order="F")
Efield = (Efieldx, Efieldy, Efieldz)

imageToVTK("./image", cellData={"flux": flux}, pointData={"Efield": Efieldx})
