from mona_sdk import Client

print("Starting test ...")

# Es monitor test
client_id = "40c08ee6-f411-41b1-9752-80d98897aae6"
secret_key = "5694fad0-e372-488e-89cf-22ed8693a5a2"
user_id = "01971934-5acd-4888-9894-071e32fa867c"

# Let's have 4 context classes - the 4th will take the default value (0.7).
my_mona_client = Client(
    api_key=client_id,
    secret=secret_key,
    user_id=user_id,
    raise_export_exceptions=True,
    #raise_service_exceptions=True,
)


context_class_config_no_good = {
    "fields": {
        "number_of_something": {"type": "numeric"},
        "on_camera": {"type": "boolean"},
        "on_microphone": {"type": "boolean"},
        "another_numeric_source": {"type": "numeric"},
        "field_that_shouldnt_pass": {"type": "ahalan"},
    }
}

context_class_config_all_good = {
    "fields": {
        "number_of_something": {"type": "numeric"},
        "on_camera": {"type": "boolean"},
        "on_microphone": {"type": "boolean"},
        "another_numeric_source": {"type": "numeric"},
    }
}

context_class_config_all_good2 = {
    "fields": {
        "number_of_something": {"type": "numeric"},
        "on_camera": {"type": "boolean"},
        "on_microphone": {"type": "boolean"},
    }
}

context_class_config_identical = {
    "fields": {
        "number_of_something": {"type": "numeric"},
        "on_camera": {"type": "boolean"},
        "on_microphone": {"type": "boolean"},
    }
}
context_class_name = "context_class"
# ret = my_mona_client.upload_config_per_context_class(
#    author="smadar@monalabs.io",
#    commit_message="test for cc config upload",
#    context_class=context_class_name,
#    config=context_class_config_all_good,
# )
# print(ret)
# ret = my_mona_client.upload_config_per_context_class(
#    author="smadar@monalabs.io",
#    commit_message="test for cc config upload",
#    context_class=context_class_name,
#    config=context_class_config_all_good2,
# )
# print(ret)

# ret = my_mona_client.upload_config_per_context_class(
#   author="smadar@monalabs.io",
#   commit_message="test for cc config upload",
#   context_class=context_class_name,
#   config=context_class_config_identical,
# )
# print(ret)

# print("sending upload cc config")
# ret = my_mona_client.upload_config_per_context_class(
#    author="smadar@monalabs.io",
#    commit_message="test for cc config upload",
#    context_class=context_class_name,
#    config=context_class_config_no_good,
# )
# print(ret)

print("sending upload config")

config_no_good = {
    "ef3a7c1a-cf94-489b-8c69-5075136003f2": {
        "context_class_name": {
            "fields": {
                "number_of_something": {"type": "numeric"},
                "field_that_shouldnt_pass": {"type": "ahalan"},
            }
        }
    }
}

config_good = {
    "ef3a7c1a-cf94-489b-8c69-5075136003f2": {
        "context_class_name": {
            "fields": {
                "number_of_something": {"type": "numeric"},
                "on_camera": {"type": "boolean"},
                "on_microphone": {"type": "boolean"},
            }
        }
    }
}

ret = my_mona_client.upload_config(
    author="smadar@monalabs.io",
    commit_message="test for config upload",
    config=config_no_good,
)
print(f"upload_config bad: {ret}")

ret = my_mona_client.upload_config(
    author="smadar@monalabs.io",
    commit_message="test for config upload",
    config=config_good,
)
print(f"upload_config good: {ret}")

# sampling factors
sampling_factors = my_mona_client.get_sampling_factors()
print(f"sampling_factors: {sampling_factors}")
events = {
    "userId": user_id,
    "messages": [
        {
            "arcClass": "arcClassName",
            "contextId": "ID_123",
            "message": {
                "company-id": "79sg7723-0253438g3453",
                "browser": "chrome",
                "text_length": 50,
                "top_tagged_brand": "adidas",
            },
        },
        {
            "arcClass": "arcClassName",
            "contextId": "ID_123",
            "message": {"coutry": "usa"},
        },
        {
            "arcClass": "arcClassName",
            "contextId": "ID_124",
            "message": {
                "company-id": "2435f32-02ve3538g5232",
                "browser": "safari",
                "text_length": 30,
                "top_tagged_brand": "nike",
            },
        },
    ],
}
suggested_config = my_mona_client.get_suggested_config_from_user_input(events)
print(f"suggested_config: {suggested_config}")

config = my_mona_client.get_config()
print(f"get_config res: {config}")

res = my_mona_client.validate_config(config)
print(f"validate_config res: {res}")
res = my_mona_client.validate_config(config_no_good)
print(f"validate_config bad res: {res}")

res = my_mona_client.get_config_history()
print(f"get_config_history res: {res}")

# create_sampling_factor()
res = my_mona_client.create_sampling_factor(
    config_name="smadar_neti_test", sampling_factor=1, context_class=context_class_name
)
print(f"create_sampling_factor res: {res}")

# get_insights
res = my_mona_client.get_insights(
    context_class="context_class", min_segment_size=0
)
print(f"get_insights res: {res}")

print("all done ... ")