// Copyright (c) Mito
import React, { useState } from 'react';
import DropdownItem from '../../../elements/DropdownItem';
import Select from '../../../elements/Select';
import Col from '../../../spacing/Col';
import Row from '../../../spacing/Row';
const DTYPE_DESCRIPTION = 'Changes the dtype of the selected column in the underlying dataframe.';
// The dtypes accepted by the change column dtype change
var ColumnDtypes;
(function (ColumnDtypes) {
    ColumnDtypes["BOOL"] = "bool";
    ColumnDtypes["INT"] = "int";
    ColumnDtypes["FLOAT"] = "float";
    ColumnDtypes["STRING"] = "str";
    ColumnDtypes["DATETIME"] = "datetime";
    ColumnDtypes["TIMEDELTA"] = "timedelta";
})(ColumnDtypes || (ColumnDtypes = {}));
/*
    Given the raw dtype of the column (e.g. 'int64'), gets
    the dtype that will choosen in the value dropdown for
    that column.
*/
export function getDtypeValue(dtype) {
    if (dtype === undefined) {
        return ColumnDtypes.STRING;
    }
    if (dtype.includes('bool')) {
        return ColumnDtypes.BOOL;
    }
    else if (dtype.includes('int')) {
        return ColumnDtypes.INT;
    }
    else if (dtype.includes('float')) {
        return ColumnDtypes.FLOAT;
    }
    else if (dtype.includes('str') || dtype.includes('object')) {
        return ColumnDtypes.STRING;
    }
    else if (dtype.includes('datetime')) {
        return ColumnDtypes.DATETIME;
    }
    else if (dtype.includes('timedelta')) {
        return ColumnDtypes.TIMEDELTA;
    }
    return ColumnDtypes.STRING;
}
/*
    A card that allows a user to change the dtype of a column if it
    is a data column. If it is a formula column, just displays the
    dtype.
*/
function DtypeCard(props) {
    const [stepID, setStepID] = useState(undefined);
    async function changeColumnDtype(newDtype) {
        const newStepID = await props.mitoAPI.editChangeColumnDtype(props.selectedSheetIndex, props.columnID, newDtype, stepID);
        setStepID(newStepID);
    }
    return (React.createElement(React.Fragment, null,
        React.createElement(Row, { justify: 'space-between', align: 'center' },
            React.createElement(Col, { span: 4, title: DTYPE_DESCRIPTION },
                React.createElement("p", { className: 'text-header-3' }, "Dtype")),
            React.createElement(Col, { offset: 2, flex: '1' },
                props.columnFormula === '' &&
                    React.createElement(Select, { value: getDtypeValue(props.columnDtype), onChange: (newDtype) => {
                            void changeColumnDtype(newDtype);
                        }, dropdownWidth: 'small' },
                        React.createElement(DropdownItem, { title: ColumnDtypes.BOOL }),
                        React.createElement(DropdownItem, { title: ColumnDtypes.INT }),
                        React.createElement(DropdownItem, { title: ColumnDtypes.FLOAT }),
                        React.createElement(DropdownItem, { title: ColumnDtypes.STRING }),
                        React.createElement(DropdownItem, { title: ColumnDtypes.DATETIME }),
                        React.createElement(DropdownItem, { title: ColumnDtypes.TIMEDELTA })),
                props.columnFormula !== '' &&
                    React.createElement("p", { className: 'text-header-3 text-align-right' }, getDtypeValue(props.columnDtype)))),
        props.columnFormula !== '' &&
            React.createElement(Row, null,
                React.createElement(Col, null,
                    React.createElement("p", { className: 'text-subtext-1' }, "Edit the formula to DATEVALUE, VALUE, or TEXT to change the type.")))));
}
export default DtypeCard;
//# sourceMappingURL=DtypeCard.js.map