#==============================================================================#
#  Author:       Dominik Müller                                                #
#  Copyright:    2022 IT-Infrastructure for Translational Medical Research,    #
#                University of Augsburg                                        #
#                                                                              #
#  This program is free software: you can redistribute it and/or modify        #
#  it under the terms of the GNU General Public License as published by        #
#  the Free Software Foundation, either version 3 of the License, or           #
#  (at your option) any later version.                                         #
#                                                                              #
#  This program is distributed in the hope that it will be useful,             #
#  but WITHOUT ANY WARRANTY; without even the implied warranty of              #
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               #
#  GNU General Public License for more details.                                #
#                                                                              #
#  You should have received a copy of the GNU General Public License           #
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.       #
#==============================================================================#
#-----------------------------------------------------#
#                    Documentation                    #
#-----------------------------------------------------#
""" Library of evaluation functions in the AUCMEDI environment.

The idea of the evaluation function library is to provide quick and simple functionality
for inspecting and analyzing data as well as results generated by AUCMEDI.

AUCMEDI currently supports the following evaluation techniques:

| Evaluation Technique                                     | Description                                                                           |
| -------------------------------------------------------- | ------------------------------------------------------------------------------------- |
| [Dataset Analysis][aucmedi.evaluation.dataset]           | Peak into the loaded medical imaging dataset.                                         |
| [Fitting Evaluation][aucmedi.evaluation.fitting]         | Evaluate the fitting curve of a model training process.                               |
| [Performance Evaluation][aucmedi.evaluation.performance] | Evaluate the performance of a single model / prediction list through various metrics. |
| [Performance Comparison][aucmedi.evaluation.comparison]  | Compare the performance of predictions from multiple models.                          |

"""
#-----------------------------------------------------#
#                   Library imports                   #
#-----------------------------------------------------#
from aucmedi.evaluation.fitting import evaluate_fitting
from aucmedi.evaluation.performance import evaluate_performance
from aucmedi.evaluation.comparison import evaluate_comparison
from aucmedi.evaluation.dataset import evaluate_dataset
