from collections.abc import Callable
from io import BufferedIOBase, BufferedRandom, BytesIO
from typing import Any

COPY_BYTES: int
STRBUF_LIMIT: int

class FileBasedBuffer:
    remain: int = ...
    file: BytesIO = ...
    def __init__(self, file: BytesIO, from_buffer: BytesIO | None = None) -> None: ...
    def __len__(self) -> int: ...
    def __nonzero__(self) -> bool: ...
    __bool__: Callable[[], bool] = ...
    def append(self, s: Any) -> None: ...
    def get(self, numbytes: int = -1, skip: bool = False) -> bytes: ...
    def skip(self, numbytes: int, allow_prune: int = 0) -> None: ...
    def newfile(self) -> Any: ...
    def prune(self) -> None: ...
    def getfile(self) -> Any: ...
    def close(self) -> None: ...

class TempfileBasedBuffer(FileBasedBuffer):
    def __init__(self, from_buffer: BytesIO | None = None) -> None: ...
    def newfile(self) -> BufferedRandom: ...

class BytesIOBasedBuffer(FileBasedBuffer):
    file: BytesIO = ...
    def __init__(self, from_buffer: BytesIO | None = None) -> None: ...
    def newfile(self) -> BytesIO: ...

class ReadOnlyFileBasedBuffer(FileBasedBuffer):
    file: BytesIO = ...
    block_size: int = ...
    def __init__(self, file: BytesIO, block_size: int = 32768) -> None: ...
    remain: int = ...
    def prepare(self, size: int | None = None) -> int: ...
    def get(self, numbytes: int = -1, skip: bool = False) -> bytes: ...
    def __iter__(self) -> ReadOnlyFileBasedBuffer: ...
    def next(self) -> bytes | None: ...
    __next__: Callable[[], bytes | None] = ...
    def append(self, s: Any) -> None: ...

class OverflowableBuffer:
    overflowed: bool = ...
    buf: BufferedIOBase | None = ...
    strbuf: bytes = ...
    overflow: int = ...
    def __init__(self, overflow: int) -> None: ...
    def __len__(self) -> int: ...
    def __nonzero__(self) -> bool: ...
    __bool__: Callable[[], bool] = ...
    def append(self, s: bytes) -> None: ...
    def get(self, numbytes: int = -1, skip: bool = False) -> bytes: ...
    def skip(self, numbytes: int, allow_prune: bool = False) -> None: ...
    def prune(self) -> None: ...
    def getfile(self) -> BytesIO: ...
    def close(self) -> None: ...
