"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyAttachment = exports.PolicyAttachmentProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const resourcemanager_generated_1 = require("./resourcemanager.generated");
Object.defineProperty(exports, "PolicyAttachmentProperty", { enumerable: true, get: function () { return resourcemanager_generated_1.RosPolicyAttachment; } });
/**
 * A ROS resource type:  `ALIYUN::ResourceManager::PolicyAttachment`
 */
class PolicyAttachment extends ros.Resource {
    /**
     * Create a new `ALIYUN::ResourceManager::PolicyAttachment`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosPolicyAttachment = new resourcemanager_generated_1.RosPolicyAttachment(this, id, {
            policyType: props.policyType,
            resourceGroupId: props.resourceGroupId,
            policyName: props.policyName,
            principalName: props.principalName,
            principalType: props.principalType,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosPolicyAttachment;
        this.attrAttachDate = rosPolicyAttachment.attrAttachDate;
        this.attrDescription = rosPolicyAttachment.attrDescription;
        this.attrPolicyName = rosPolicyAttachment.attrPolicyName;
        this.attrPolicyType = rosPolicyAttachment.attrPolicyType;
        this.attrPrincipalName = rosPolicyAttachment.attrPrincipalName;
        this.attrPrincipalType = rosPolicyAttachment.attrPrincipalType;
        this.attrResourceGroupId = rosPolicyAttachment.attrResourceGroupId;
    }
}
exports.PolicyAttachment = PolicyAttachment;
//# sourceMappingURL=data:application/json;base64,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