#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['reportsrender']

package_data = \
{'': ['*'],
 'reportsrender': ['templates/*',
                   'templates/adaptive-bootstrap/*',
                   'templates/adaptive-bootstrap/lang/*',
                   'templates/adaptive-bootstrap/lang/da/*',
                   'templates/adaptive-bootstrap/lang/en/*',
                   'templates/adaptive-bootstrap/menu/*',
                   'templates/adaptive-bootstrap/menu/css/*',
                   'templates/adaptive-bootstrap/menu/css/skins/*',
                   'templates/adaptive-bootstrap/menu/css/skins/images/*',
                   'templates/adaptive-bootstrap/menu/js/*']}

install_requires = \
['docopt',
 'ipython',
 'jupytext>=1.3.0',
 'papermill',
 'nbconvert',
 'ipykernel',
 'get_version',
 'lxml']

extras_require = \
{'doc': ['sphinx', 'sphinx_autodoc_typehints', 'sphinx_rtd_theme'],
 'test': ['pytest', 'matplotlib']}

entry_points = \
{'console_scripts': ['reportsrender = reportsrender.cli:main']}

setup(name='reportsrender',
      version='0.3.1',
      description='Execute and Render notebooks as HTML reports. ',
      author='Gregor Sturm',
      author_email='mail@gregor-sturm.de',
      url='https://github.com/grst/reportsrender',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>= 3.6',
     )
