

CREATE TABLE "AirInterface" (
	"air_PM_concen" TEXT, 
	alt TEXT, 
	barometric_press TEXT, 
	carb_dioxide TEXT, 
	carb_monoxide TEXT, 
	chem_administration TEXT, 
	collection_date TEXT, 
	depth TEXT, 
	ecosystem TEXT, 
	ecosystem_category TEXT, 
	ecosystem_subtype TEXT, 
	ecosystem_type TEXT, 
	elev TEXT, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	experimental_factor TEXT, 
	geo_loc_name TEXT, 
	horizon_meth TEXT, 
	humidity TEXT, 
	lat_lon TEXT, 
	methane TEXT, 
	misc_param TEXT, 
	organism_count TEXT, 
	oxy_stat_samp VARCHAR(17), 
	oxygen TEXT, 
	perturbation TEXT, 
	pollutants TEXT, 
	rel_to_oxygen VARCHAR(17), 
	salinity TEXT, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	size_frac TEXT, 
	solar_irradiance TEXT, 
	specific_ecosystem TEXT, 
	"temp" TEXT, 
	ventilation_rate TEXT, 
	ventilation_type TEXT, 
	volatile_org_comp TEXT, 
	wind_direction TEXT, 
	wind_speed TEXT, 
	analysis_type VARCHAR(19) NOT NULL, 
	samp_name TEXT, 
	source_mat_id TEXT, 
	env_package TEXT NOT NULL, 
	sample_link TEXT, 
	PRIMARY KEY ("air_PM_concen", alt, barometric_press, carb_dioxide, carb_monoxide, chem_administration, collection_date, depth, ecosystem, ecosystem_category, ecosystem_subtype, ecosystem_type, elev, env_broad_scale, env_local_scale, env_medium, experimental_factor, geo_loc_name, horizon_meth, humidity, lat_lon, methane, misc_param, organism_count, oxy_stat_samp, oxygen, perturbation, pollutants, rel_to_oxygen, salinity, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, samp_store_dur, samp_store_loc, samp_store_temp, size_frac, solar_irradiance, specific_ecosystem, "temp", ventilation_rate, ventilation_type, volatile_org_comp, wind_direction, wind_speed, analysis_type, samp_name, source_mat_id, env_package, sample_link)
);

CREATE TABLE "BiofilmInterface" (
	alkalinity TEXT, 
	alkyl_diethers TEXT, 
	alt TEXT, 
	aminopept_act TEXT, 
	ammonium TEXT, 
	bacteria_carb_prod TEXT, 
	biomass TEXT, 
	bishomohopanol TEXT, 
	bromide TEXT, 
	calcium TEXT, 
	carb_nitro_ratio TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	chlorophyll TEXT, 
	collection_date TEXT, 
	depth TEXT, 
	diether_lipids TEXT, 
	diss_carb_dioxide TEXT, 
	diss_hydrogen TEXT, 
	diss_inorg_carb TEXT, 
	diss_org_carb TEXT, 
	diss_org_nitro TEXT, 
	diss_oxygen TEXT, 
	ecosystem TEXT, 
	ecosystem_category TEXT, 
	ecosystem_subtype TEXT, 
	ecosystem_type TEXT, 
	elev TEXT, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	experimental_factor TEXT, 
	geo_loc_name TEXT, 
	glucosidase_act TEXT, 
	horizon_meth TEXT, 
	lat_lon TEXT, 
	magnesium TEXT, 
	mean_frict_vel TEXT, 
	mean_peak_frict_vel TEXT, 
	methane TEXT, 
	misc_param TEXT, 
	n_alkanes TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	nitro TEXT, 
	org_carb TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	organism_count TEXT, 
	oxy_stat_samp VARCHAR(17), 
	part_org_carb TEXT, 
	perturbation TEXT, 
	petroleum_hydrocarb TEXT, 
	ph FLOAT, 
	ph_meth TEXT, 
	phaeopigments TEXT, 
	phosphate TEXT, 
	phosplipid_fatt_acid TEXT, 
	potassium TEXT, 
	pressure TEXT, 
	redox_potential TEXT, 
	rel_to_oxygen VARCHAR(17), 
	salinity TEXT, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	silicate TEXT, 
	size_frac TEXT, 
	sodium TEXT, 
	specific_ecosystem TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	"temp" TEXT, 
	tot_carb TEXT, 
	tot_nitro_content TEXT, 
	tot_org_carb TEXT, 
	turbidity TEXT, 
	water_content TEXT, 
	analysis_type VARCHAR(19) NOT NULL, 
	samp_name TEXT, 
	source_mat_id TEXT, 
	env_package TEXT NOT NULL, 
	sample_link TEXT, 
	PRIMARY KEY (alkalinity, alkyl_diethers, alt, aminopept_act, ammonium, bacteria_carb_prod, biomass, bishomohopanol, bromide, calcium, carb_nitro_ratio, chem_administration, chloride, chlorophyll, collection_date, depth, diether_lipids, diss_carb_dioxide, diss_hydrogen, diss_inorg_carb, diss_org_carb, diss_org_nitro, diss_oxygen, ecosystem, ecosystem_category, ecosystem_subtype, ecosystem_type, elev, env_broad_scale, env_local_scale, env_medium, experimental_factor, geo_loc_name, glucosidase_act, horizon_meth, lat_lon, magnesium, mean_frict_vel, mean_peak_frict_vel, methane, misc_param, n_alkanes, nitrate, nitrite, nitro, org_carb, org_matter, org_nitro, organism_count, oxy_stat_samp, part_org_carb, perturbation, petroleum_hydrocarb, ph, ph_meth, phaeopigments, phosphate, phosplipid_fatt_acid, potassium, pressure, redox_potential, rel_to_oxygen, salinity, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, samp_store_dur, samp_store_loc, samp_store_temp, silicate, size_frac, sodium, specific_ecosystem, sulfate, sulfide, "temp", tot_carb, tot_nitro_content, tot_org_carb, turbidity, water_content, analysis_type, samp_name, source_mat_id, env_package, sample_link)
);

CREATE TABLE "BuiltEnvInterface" (
	abs_air_humidity TEXT, 
	address TEXT, 
	adj_room TEXT, 
	aero_struc TEXT, 
	air_temp TEXT, 
	alt TEXT, 
	amount_light TEXT, 
	arch_struc VARCHAR(8), 
	avg_dew_point TEXT, 
	avg_occup TEXT, 
	avg_temp TEXT, 
	bathroom_count TEXT, 
	bedroom_count TEXT, 
	build_docs VARCHAR(28), 
	build_occup_type VARCHAR(14), 
	building_setting VARCHAR(8), 
	built_struc_age TEXT, 
	built_struc_set TEXT, 
	built_struc_type TEXT, 
	carb_dioxide TEXT, 
	ceil_area TEXT, 
	ceil_cond VARCHAR(12), 
	ceil_finish_mat VARCHAR(29), 
	ceil_struc TEXT, 
	ceil_texture VARCHAR(16), 
	ceil_thermal_mass TEXT, 
	ceil_type VARCHAR(13), 
	ceil_water_mold TEXT, 
	collection_date TEXT, 
	cool_syst_id TEXT, 
	date_last_rain TEXT, 
	depth TEXT, 
	dew_point TEXT, 
	door_comp_type VARCHAR(13), 
	door_cond VARCHAR(12), 
	door_direct VARCHAR(8), 
	door_loc VARCHAR(5), 
	door_mat VARCHAR(22), 
	door_move VARCHAR(15), 
	door_size TEXT, 
	door_type VARCHAR(9), 
	door_type_metal VARCHAR(16), 
	door_type_wood VARCHAR(24), 
	door_water_mold TEXT, 
	drawings VARCHAR(23), 
	ecosystem TEXT, 
	ecosystem_category TEXT, 
	ecosystem_subtype TEXT, 
	ecosystem_type TEXT, 
	elev TEXT, 
	elevator TEXT, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	escalator TEXT, 
	exp_duct TEXT, 
	exp_pipe TEXT, 
	experimental_factor TEXT, 
	ext_door TEXT, 
	ext_wall_orient VARCHAR(9), 
	ext_window_orient VARCHAR(9), 
	filter_type VARCHAR(39), 
	fireplace_type TEXT, 
	floor_age TEXT, 
	floor_area TEXT, 
	floor_cond VARCHAR(12), 
	floor_count TEXT, 
	floor_finish_mat VARCHAR(22), 
	floor_struc VARCHAR(14), 
	floor_thermal_mass TEXT, 
	floor_water_mold VARCHAR(26), 
	freq_clean TEXT, 
	freq_cook TEXT, 
	furniture VARCHAR(7), 
	gender_restroom VARCHAR(15), 
	geo_loc_name TEXT, 
	hall_count TEXT, 
	handidness VARCHAR(16), 
	heat_cool_type VARCHAR(17), 
	heat_deliv_loc VARCHAR(5), 
	heat_sys_deliv_meth TEXT, 
	heat_system_id TEXT, 
	height_carper_fiber TEXT, 
	horizon_meth TEXT, 
	indoor_space VARCHAR(11), 
	indoor_surf VARCHAR(11), 
	inside_lux TEXT, 
	int_wall_cond VARCHAR(12), 
	last_clean TEXT, 
	lat_lon TEXT, 
	light_type VARCHAR(18), 
	max_occup TEXT, 
	mech_struc VARCHAR(9), 
	number_pets TEXT, 
	number_plants TEXT, 
	number_resident TEXT, 
	occup_density_samp TEXT, 
	occup_document VARCHAR(15), 
	occup_samp TEXT, 
	organism_count TEXT, 
	pres_animal_insect TEXT, 
	quad_pos VARCHAR(10), 
	rel_air_humidity TEXT, 
	rel_humidity_out TEXT, 
	rel_samp_loc VARCHAR(13), 
	room_air_exch_rate TEXT, 
	room_architec_elem TEXT, 
	room_condt VARCHAR(28), 
	room_connected VARCHAR(15), 
	room_count TEXT, 
	room_dim TEXT, 
	room_door_dist TEXT, 
	room_door_share TEXT, 
	room_hallway TEXT, 
	room_loc VARCHAR(13), 
	room_moist_dam_hist INTEGER, 
	room_net_area TEXT, 
	room_occup TEXT, 
	room_samp_pos VARCHAR(16), 
	room_type VARCHAR(29), 
	room_vol TEXT, 
	room_wall_share TEXT, 
	room_window_count INTEGER, 
	samp_floor VARCHAR(9), 
	samp_room_id TEXT, 
	samp_sort_meth TEXT, 
	samp_time_out TEXT, 
	samp_weather VARCHAR(9), 
	season TEXT, 
	season_use VARCHAR(6), 
	shad_dev_water_mold TEXT, 
	shading_device_cond VARCHAR(12), 
	shading_device_loc TEXT, 
	shading_device_mat TEXT, 
	shading_device_type VARCHAR(21), 
	size_frac TEXT, 
	space_typ_state TEXT, 
	specific VARCHAR(12), 
	specific_ecosystem TEXT, 
	specific_humidity TEXT, 
	substructure_type VARCHAR(13), 
	surf_air_cont VARCHAR(26), 
	surf_humidity TEXT, 
	surf_material VARCHAR(15), 
	surf_moisture TEXT, 
	surf_moisture_ph FLOAT, 
	surf_temp TEXT, 
	"temp" TEXT, 
	temp_out TEXT, 
	train_line VARCHAR(6), 
	train_stat_loc VARCHAR(26), 
	train_stop_loc VARCHAR(8), 
	typ_occup_density FLOAT, 
	ventilation_type TEXT, 
	vis_media VARCHAR(63), 
	wall_area TEXT, 
	wall_const_type VARCHAR(23), 
	wall_finish_mat VARCHAR(20), 
	wall_height TEXT, 
	wall_loc VARCHAR(5), 
	wall_surf_treatment VARCHAR(12), 
	wall_texture VARCHAR(16), 
	wall_thermal_mass TEXT, 
	wall_water_mold TEXT, 
	water_feat_size TEXT, 
	water_feat_type VARCHAR(16), 
	weekday VARCHAR(9), 
	window_cond VARCHAR(12), 
	window_cover VARCHAR(8), 
	window_horiz_pos VARCHAR(6), 
	window_loc VARCHAR(5), 
	window_mat VARCHAR(10), 
	window_open_freq TEXT, 
	window_size TEXT, 
	window_status TEXT, 
	window_type VARCHAR(23), 
	window_vert_pos VARCHAR(6), 
	window_water_mold TEXT, 
	analysis_type VARCHAR(19) NOT NULL, 
	samp_name TEXT, 
	source_mat_id TEXT, 
	env_package TEXT NOT NULL, 
	sample_link TEXT, 
	PRIMARY KEY (abs_air_humidity, address, adj_room, aero_struc, air_temp, alt, amount_light, arch_struc, avg_dew_point, avg_occup, avg_temp, bathroom_count, bedroom_count, build_docs, build_occup_type, building_setting, built_struc_age, built_struc_set, built_struc_type, carb_dioxide, ceil_area, ceil_cond, ceil_finish_mat, ceil_struc, ceil_texture, ceil_thermal_mass, ceil_type, ceil_water_mold, collection_date, cool_syst_id, date_last_rain, depth, dew_point, door_comp_type, door_cond, door_direct, door_loc, door_mat, door_move, door_size, door_type, door_type_metal, door_type_wood, door_water_mold, drawings, ecosystem, ecosystem_category, ecosystem_subtype, ecosystem_type, elev, elevator, env_broad_scale, env_local_scale, env_medium, escalator, exp_duct, exp_pipe, experimental_factor, ext_door, ext_wall_orient, ext_window_orient, filter_type, fireplace_type, floor_age, floor_area, floor_cond, floor_count, floor_finish_mat, floor_struc, floor_thermal_mass, floor_water_mold, freq_clean, freq_cook, furniture, gender_restroom, geo_loc_name, hall_count, handidness, heat_cool_type, heat_deliv_loc, heat_sys_deliv_meth, heat_system_id, height_carper_fiber, horizon_meth, indoor_space, indoor_surf, inside_lux, int_wall_cond, last_clean, lat_lon, light_type, max_occup, mech_struc, number_pets, number_plants, number_resident, occup_density_samp, occup_document, occup_samp, organism_count, pres_animal_insect, quad_pos, rel_air_humidity, rel_humidity_out, rel_samp_loc, room_air_exch_rate, room_architec_elem, room_condt, room_connected, room_count, room_dim, room_door_dist, room_door_share, room_hallway, room_loc, room_moist_dam_hist, room_net_area, room_occup, room_samp_pos, room_type, room_vol, room_wall_share, room_window_count, samp_floor, samp_room_id, samp_sort_meth, samp_time_out, samp_weather, season, season_use, shad_dev_water_mold, shading_device_cond, shading_device_loc, shading_device_mat, shading_device_type, size_frac, space_typ_state, specific, specific_ecosystem, specific_humidity, substructure_type, surf_air_cont, surf_humidity, surf_material, surf_moisture, surf_moisture_ph, surf_temp, "temp", temp_out, train_line, train_stat_loc, train_stop_loc, typ_occup_density, ventilation_type, vis_media, wall_area, wall_const_type, wall_finish_mat, wall_height, wall_loc, wall_surf_treatment, wall_texture, wall_thermal_mass, wall_water_mold, water_feat_size, water_feat_type, weekday, window_cond, window_cover, window_horiz_pos, window_loc, window_mat, window_open_freq, window_size, window_status, window_type, window_vert_pos, window_water_mold, analysis_type, samp_name, source_mat_id, env_package, sample_link)
);

CREATE TABLE "EmslInterface" (
	emsl_store_temp TEXT NOT NULL, 
	project_id TEXT NOT NULL, 
	replicate_number TEXT, 
	sample_shipped TEXT NOT NULL, 
	sample_type VARCHAR(18) NOT NULL, 
	technical_reps TEXT, 
	analysis_type VARCHAR(19) NOT NULL, 
	samp_name TEXT, 
	source_mat_id TEXT, 
	PRIMARY KEY (emsl_store_temp, project_id, replicate_number, sample_shipped, sample_type, technical_reps, analysis_type, samp_name, source_mat_id)
);

CREATE TABLE "HcrCoresInterface" (
	additional_info TEXT, 
	alkalinity TEXT, 
	alkalinity_method TEXT, 
	alt TEXT, 
	ammonium TEXT, 
	api TEXT, 
	aromatics_pc TEXT, 
	asphaltenes_pc TEXT, 
	basin TEXT, 
	benzene TEXT, 
	calcium TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	collection_date TEXT, 
	density TEXT, 
	depos_env VARCHAR(24), 
	depth TEXT, 
	diss_carb_dioxide TEXT, 
	diss_inorg_carb TEXT, 
	diss_inorg_phosp TEXT, 
	diss_iron TEXT, 
	diss_org_carb TEXT, 
	diss_oxygen_fluid TEXT, 
	ecosystem TEXT, 
	ecosystem_category TEXT, 
	ecosystem_subtype TEXT, 
	ecosystem_type TEXT, 
	elev TEXT, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	ethylbenzene TEXT, 
	experimental_factor TEXT, 
	field TEXT, 
	geo_loc_name TEXT, 
	hc_produced VARCHAR(15), 
	hcr VARCHAR(19), 
	hcr_fw_salinity TEXT, 
	hcr_geol_age VARCHAR(13), 
	hcr_pressure TEXT, 
	hcr_temp TEXT, 
	horizon_meth TEXT, 
	lat_lon TEXT, 
	lithology VARCHAR(12), 
	magnesium TEXT, 
	misc_param TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	org_count_qpcr_info TEXT, 
	organism_count TEXT, 
	owc_tvdss TEXT, 
	oxy_stat_samp VARCHAR(17), 
	permeability TEXT, 
	ph FLOAT, 
	ph_meth TEXT, 
	porosity TEXT, 
	potassium TEXT, 
	pour_point TEXT, 
	pressure TEXT, 
	rel_to_oxygen VARCHAR(17), 
	reservoir TEXT, 
	resins_pc TEXT, 
	salinity TEXT, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_md TEXT, 
	samp_size TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	samp_subtype VARCHAR(14), 
	samp_transport_cond TEXT, 
	samp_tvdss TEXT, 
	samp_type TEXT, 
	samp_well_name TEXT, 
	saturates_pc TEXT, 
	size_frac TEXT, 
	sodium TEXT, 
	specific_ecosystem TEXT, 
	sr_dep_env VARCHAR(14), 
	sr_geol_age VARCHAR(13), 
	sr_kerog_type VARCHAR(8), 
	sr_lithology VARCHAR(13), 
	sulfate TEXT, 
	sulfate_fw TEXT, 
	sulfide TEXT, 
	suspend_solids TEXT, 
	tan TEXT, 
	"temp" TEXT, 
	toluene TEXT, 
	tot_iron TEXT, 
	tot_nitro TEXT, 
	tot_phosp TEXT, 
	tot_sulfur TEXT, 
	tvdss_of_hcr_press TEXT, 
	tvdss_of_hcr_temp TEXT, 
	vfa TEXT, 
	vfa_fw TEXT, 
	viscosity TEXT, 
	win TEXT, 
	xylene TEXT, 
	analysis_type VARCHAR(19) NOT NULL, 
	samp_name TEXT, 
	source_mat_id TEXT, 
	PRIMARY KEY (additional_info, alkalinity, alkalinity_method, alt, ammonium, api, aromatics_pc, asphaltenes_pc, basin, benzene, calcium, chem_administration, chloride, collection_date, density, depos_env, depth, diss_carb_dioxide, diss_inorg_carb, diss_inorg_phosp, diss_iron, diss_org_carb, diss_oxygen_fluid, ecosystem, ecosystem_category, ecosystem_subtype, ecosystem_type, elev, env_broad_scale, env_local_scale, env_medium, ethylbenzene, experimental_factor, field, geo_loc_name, hc_produced, hcr, hcr_fw_salinity, hcr_geol_age, hcr_pressure, hcr_temp, horizon_meth, lat_lon, lithology, magnesium, misc_param, nitrate, nitrite, org_count_qpcr_info, organism_count, owc_tvdss, oxy_stat_samp, permeability, ph, ph_meth, porosity, potassium, pour_point, pressure, rel_to_oxygen, reservoir, resins_pc, salinity, samp_collec_device, samp_collec_method, samp_mat_process, samp_md, samp_size, samp_store_dur, samp_store_loc, samp_store_temp, samp_subtype, samp_transport_cond, samp_tvdss, samp_type, samp_well_name, saturates_pc, size_frac, sodium, specific_ecosystem, sr_dep_env, sr_geol_age, sr_kerog_type, sr_lithology, sulfate, sulfate_fw, sulfide, suspend_solids, tan, "temp", toluene, tot_iron, tot_nitro, tot_phosp, tot_sulfur, tvdss_of_hcr_press, tvdss_of_hcr_temp, vfa, vfa_fw, viscosity, win, xylene, analysis_type, samp_name, source_mat_id)
);

CREATE TABLE "HcrFluidsSwabsInterface" (
	add_recov_method TEXT, 
	additional_info TEXT, 
	alkalinity TEXT, 
	alkalinity_method TEXT, 
	alt TEXT, 
	ammonium TEXT, 
	api TEXT, 
	aromatics_pc TEXT, 
	asphaltenes_pc TEXT, 
	basin TEXT, 
	benzene TEXT, 
	biocide TEXT, 
	biocide_admin_method TEXT, 
	calcium TEXT, 
	chem_administration TEXT, 
	chem_treat_method TEXT, 
	chem_treatment TEXT, 
	chloride TEXT, 
	collection_date TEXT, 
	density TEXT, 
	depos_env VARCHAR(24), 
	depth TEXT, 
	diss_carb_dioxide TEXT, 
	diss_inorg_carb TEXT, 
	diss_inorg_phosp TEXT, 
	diss_iron TEXT, 
	diss_org_carb TEXT, 
	diss_oxygen_fluid TEXT, 
	ecosystem TEXT, 
	ecosystem_category TEXT, 
	ecosystem_subtype TEXT, 
	ecosystem_type TEXT, 
	elev TEXT, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	ethylbenzene TEXT, 
	experimental_factor TEXT, 
	field TEXT, 
	geo_loc_name TEXT, 
	hc_produced VARCHAR(15), 
	hcr VARCHAR(19), 
	hcr_fw_salinity TEXT, 
	hcr_geol_age VARCHAR(13), 
	hcr_pressure TEXT, 
	hcr_temp TEXT, 
	horizon_meth TEXT, 
	iw_bt_date_well TEXT, 
	iwf TEXT, 
	lat_lon TEXT, 
	lithology VARCHAR(12), 
	magnesium TEXT, 
	misc_param TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	org_count_qpcr_info TEXT, 
	organism_count TEXT, 
	oxy_stat_samp VARCHAR(17), 
	ph FLOAT, 
	ph_meth TEXT, 
	potassium TEXT, 
	pour_point TEXT, 
	pressure TEXT, 
	prod_rate TEXT, 
	prod_start_date TEXT, 
	rel_to_oxygen VARCHAR(17), 
	reservoir TEXT, 
	resins_pc TEXT, 
	salinity TEXT, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_collect_point VARCHAR(12), 
	samp_loc_corr_rate TEXT, 
	samp_mat_process TEXT, 
	samp_preserv TEXT, 
	samp_size TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	samp_subtype VARCHAR(14), 
	samp_transport_cond TEXT, 
	samp_type TEXT, 
	samp_well_name TEXT, 
	saturates_pc TEXT, 
	size_frac TEXT, 
	sodium TEXT, 
	specific_ecosystem TEXT, 
	sulfate TEXT, 
	sulfate_fw TEXT, 
	sulfide TEXT, 
	suspend_solids TEXT, 
	tan TEXT, 
	"temp" TEXT, 
	toluene TEXT, 
	tot_iron TEXT, 
	tot_nitro TEXT, 
	tot_phosp TEXT, 
	tot_sulfur TEXT, 
	tvdss_of_hcr_press TEXT, 
	tvdss_of_hcr_temp TEXT, 
	vfa TEXT, 
	vfa_fw TEXT, 
	viscosity TEXT, 
	water_cut TEXT, 
	water_prod_rate TEXT, 
	win TEXT, 
	xylene TEXT, 
	analysis_type VARCHAR(19) NOT NULL, 
	samp_name TEXT, 
	source_mat_id TEXT, 
	PRIMARY KEY (add_recov_method, additional_info, alkalinity, alkalinity_method, alt, ammonium, api, aromatics_pc, asphaltenes_pc, basin, benzene, biocide, biocide_admin_method, calcium, chem_administration, chem_treat_method, chem_treatment, chloride, collection_date, density, depos_env, depth, diss_carb_dioxide, diss_inorg_carb, diss_inorg_phosp, diss_iron, diss_org_carb, diss_oxygen_fluid, ecosystem, ecosystem_category, ecosystem_subtype, ecosystem_type, elev, env_broad_scale, env_local_scale, env_medium, ethylbenzene, experimental_factor, field, geo_loc_name, hc_produced, hcr, hcr_fw_salinity, hcr_geol_age, hcr_pressure, hcr_temp, horizon_meth, iw_bt_date_well, iwf, lat_lon, lithology, magnesium, misc_param, nitrate, nitrite, org_count_qpcr_info, organism_count, oxy_stat_samp, ph, ph_meth, potassium, pour_point, pressure, prod_rate, prod_start_date, rel_to_oxygen, reservoir, resins_pc, salinity, samp_collec_device, samp_collec_method, samp_collect_point, samp_loc_corr_rate, samp_mat_process, samp_preserv, samp_size, samp_store_dur, samp_store_loc, samp_store_temp, samp_subtype, samp_transport_cond, samp_type, samp_well_name, saturates_pc, size_frac, sodium, specific_ecosystem, sulfate, sulfate_fw, sulfide, suspend_solids, tan, "temp", toluene, tot_iron, tot_nitro, tot_phosp, tot_sulfur, tvdss_of_hcr_press, tvdss_of_hcr_temp, vfa, vfa_fw, viscosity, water_cut, water_prod_rate, win, xylene, analysis_type, samp_name, source_mat_id)
);

CREATE TABLE "HostAssociatedInterface" (
	alt TEXT, 
	ances_data TEXT, 
	biol_stat VARCHAR(16), 
	blood_press_diast TEXT, 
	blood_press_syst TEXT, 
	chem_administration TEXT, 
	collection_date TEXT, 
	depth TEXT, 
	ecosystem TEXT, 
	ecosystem_category TEXT, 
	ecosystem_subtype TEXT, 
	ecosystem_type TEXT, 
	elev TEXT, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	experimental_factor TEXT, 
	genetic_mod TEXT, 
	geo_loc_name TEXT, 
	gravidity TEXT, 
	horizon_meth TEXT, 
	host_age TEXT, 
	host_body_habitat TEXT, 
	host_body_product TEXT, 
	host_body_site TEXT, 
	host_body_temp TEXT, 
	host_color TEXT, 
	host_common_name TEXT, 
	host_diet TEXT, 
	host_dry_mass TEXT, 
	host_family_relation TEXT, 
	host_genotype TEXT, 
	host_growth_cond TEXT, 
	host_height TEXT, 
	host_last_meal TEXT, 
	host_length TEXT, 
	host_life_stage TEXT, 
	host_phenotype TEXT, 
	host_sex VARCHAR(13), 
	host_shape TEXT, 
	host_subject_id TEXT, 
	host_subspecf_genlin TEXT, 
	host_substrate TEXT, 
	host_symbiont TEXT, 
	host_taxid TEXT, 
	host_tot_mass TEXT, 
	lat_lon TEXT, 
	misc_param TEXT, 
	organism_count TEXT, 
	oxy_stat_samp VARCHAR(17), 
	perturbation TEXT, 
	rel_to_oxygen VARCHAR(17), 
	salinity TEXT, 
	samp_capt_status VARCHAR(48), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_dis_stage VARCHAR(23), 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	size_frac TEXT, 
	specific_ecosystem TEXT, 
	"temp" TEXT, 
	analysis_type VARCHAR(19) NOT NULL, 
	samp_name TEXT, 
	source_mat_id TEXT, 
	env_package TEXT NOT NULL, 
	sample_link TEXT, 
	PRIMARY KEY (alt, ances_data, biol_stat, blood_press_diast, blood_press_syst, chem_administration, collection_date, depth, ecosystem, ecosystem_category, ecosystem_subtype, ecosystem_type, elev, env_broad_scale, env_local_scale, env_medium, experimental_factor, genetic_mod, geo_loc_name, gravidity, horizon_meth, host_age, host_body_habitat, host_body_product, host_body_site, host_body_temp, host_color, host_common_name, host_diet, host_dry_mass, host_family_relation, host_genotype, host_growth_cond, host_height, host_last_meal, host_length, host_life_stage, host_phenotype, host_sex, host_shape, host_subject_id, host_subspecf_genlin, host_substrate, host_symbiont, host_taxid, host_tot_mass, lat_lon, misc_param, organism_count, oxy_stat_samp, perturbation, rel_to_oxygen, salinity, samp_capt_status, samp_collec_device, samp_collec_method, samp_dis_stage, samp_mat_process, samp_size, samp_store_dur, samp_store_loc, samp_store_temp, size_frac, specific_ecosystem, "temp", analysis_type, samp_name, source_mat_id, env_package, sample_link)
);

CREATE TABLE "JgiMgInterface" (
	dna_absorb1 TEXT, 
	dna_absorb2 TEXT, 
	dna_collect_site TEXT NOT NULL, 
	dna_concentration TEXT NOT NULL, 
	dna_cont_type VARCHAR(9) NOT NULL, 
	dna_cont_well TEXT NOT NULL, 
	dna_container_id TEXT NOT NULL, 
	dna_dnase VARCHAR(4) NOT NULL, 
	dna_isolate_meth TEXT NOT NULL, 
	dna_organisms TEXT, 
	dna_project_contact TEXT NOT NULL, 
	dna_samp_id TEXT NOT NULL, 
	dna_sample_format VARCHAR(19) NOT NULL, 
	dna_sample_name TEXT NOT NULL, 
	dna_seq_project TEXT NOT NULL, 
	dna_seq_project_name TEXT NOT NULL, 
	dna_seq_project_pi TEXT NOT NULL, 
	dna_volume TEXT NOT NULL, 
	proposal_dna TEXT NOT NULL, 
	analysis_type VARCHAR(19) NOT NULL, 
	samp_name TEXT, 
	source_mat_id TEXT, 
	PRIMARY KEY (dna_absorb1, dna_absorb2, dna_collect_site, dna_concentration, dna_cont_type, dna_cont_well, dna_container_id, dna_dnase, dna_isolate_meth, dna_organisms, dna_project_contact, dna_samp_id, dna_sample_format, dna_sample_name, dna_seq_project, dna_seq_project_name, dna_seq_project_pi, dna_volume, proposal_dna, analysis_type, samp_name, source_mat_id)
);

CREATE TABLE "JgiMtInterface" (
	dnase_rna VARCHAR(3) NOT NULL, 
	proposal_rna TEXT NOT NULL, 
	rna_absorb1 TEXT, 
	rna_absorb2 TEXT, 
	rna_collect_site TEXT NOT NULL, 
	rna_concentration TEXT NOT NULL, 
	rna_cont_type VARCHAR(5) NOT NULL, 
	rna_cont_well TEXT NOT NULL, 
	rna_container_id TEXT NOT NULL, 
	rna_isolate_meth TEXT NOT NULL, 
	rna_organisms TEXT, 
	rna_project_contact TEXT NOT NULL, 
	rna_samp_id TEXT NOT NULL, 
	rna_sample_format VARCHAR(19) NOT NULL, 
	rna_sample_name TEXT NOT NULL, 
	rna_seq_project TEXT NOT NULL, 
	rna_seq_project_name TEXT NOT NULL, 
	rna_seq_project_pi TEXT NOT NULL, 
	rna_volume TEXT NOT NULL, 
	analysis_type VARCHAR(19) NOT NULL, 
	samp_name TEXT, 
	source_mat_id TEXT, 
	PRIMARY KEY (dnase_rna, proposal_rna, rna_absorb1, rna_absorb2, rna_collect_site, rna_concentration, rna_cont_type, rna_cont_well, rna_container_id, rna_isolate_meth, rna_organisms, rna_project_contact, rna_samp_id, rna_sample_format, rna_sample_name, rna_seq_project, rna_seq_project_name, rna_seq_project_pi, rna_volume, analysis_type, samp_name, source_mat_id)
);

CREATE TABLE "MiscEnvsInterface" (
	alkalinity TEXT, 
	alt TEXT, 
	ammonium TEXT, 
	biomass TEXT, 
	bromide TEXT, 
	calcium TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	chlorophyll TEXT, 
	collection_date TEXT, 
	density TEXT, 
	depth TEXT, 
	diether_lipids TEXT, 
	diss_carb_dioxide TEXT, 
	diss_hydrogen TEXT, 
	diss_inorg_carb TEXT, 
	diss_org_nitro TEXT, 
	diss_oxygen TEXT, 
	ecosystem TEXT, 
	ecosystem_category TEXT, 
	ecosystem_subtype TEXT, 
	ecosystem_type TEXT, 
	elev TEXT, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	experimental_factor TEXT, 
	geo_loc_name TEXT, 
	horizon_meth TEXT, 
	lat_lon TEXT, 
	misc_param TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	nitro TEXT, 
	org_carb TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	organism_count TEXT, 
	oxy_stat_samp VARCHAR(17), 
	perturbation TEXT, 
	ph FLOAT, 
	ph_meth TEXT, 
	phosphate TEXT, 
	phosplipid_fatt_acid TEXT, 
	potassium TEXT, 
	pressure TEXT, 
	rel_to_oxygen VARCHAR(17), 
	salinity TEXT, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	silicate TEXT, 
	size_frac TEXT, 
	sodium TEXT, 
	specific_ecosystem TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	"temp" TEXT, 
	water_current TEXT, 
	analysis_type VARCHAR(19) NOT NULL, 
	samp_name TEXT, 
	source_mat_id TEXT, 
	PRIMARY KEY (alkalinity, alt, ammonium, biomass, bromide, calcium, chem_administration, chloride, chlorophyll, collection_date, density, depth, diether_lipids, diss_carb_dioxide, diss_hydrogen, diss_inorg_carb, diss_org_nitro, diss_oxygen, ecosystem, ecosystem_category, ecosystem_subtype, ecosystem_type, elev, env_broad_scale, env_local_scale, env_medium, experimental_factor, geo_loc_name, horizon_meth, lat_lon, misc_param, nitrate, nitrite, nitro, org_carb, org_matter, org_nitro, organism_count, oxy_stat_samp, perturbation, ph, ph_meth, phosphate, phosplipid_fatt_acid, potassium, pressure, rel_to_oxygen, salinity, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, samp_store_dur, samp_store_loc, samp_store_temp, silicate, size_frac, sodium, specific_ecosystem, sulfate, sulfide, "temp", water_current, analysis_type, samp_name, source_mat_id)
);

CREATE TABLE "PlantAssociatedInterface" (
	air_temp_regm TEXT, 
	alt TEXT, 
	ances_data TEXT, 
	antibiotic_regm TEXT, 
	biol_stat VARCHAR(16), 
	biotic_regm TEXT, 
	chem_administration TEXT, 
	chem_mutagen TEXT, 
	climate_environment TEXT, 
	collection_date TEXT, 
	cult_root_med TEXT, 
	depth TEXT, 
	ecosystem TEXT, 
	ecosystem_category TEXT, 
	ecosystem_subtype TEXT, 
	ecosystem_type TEXT, 
	elev TEXT, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	experimental_factor TEXT, 
	fertilizer_regm TEXT, 
	fungicide_regm TEXT, 
	gaseous_environment TEXT, 
	genetic_mod TEXT, 
	geo_loc_name TEXT, 
	gravity TEXT, 
	growth_facil TEXT, 
	growth_habit VARCHAR(10), 
	growth_hormone_regm TEXT, 
	herbicide_regm TEXT, 
	horizon_meth TEXT, 
	host_age TEXT, 
	host_common_name TEXT, 
	host_dry_mass TEXT, 
	host_genotype TEXT, 
	host_height TEXT, 
	host_length TEXT, 
	host_life_stage TEXT, 
	host_phenotype TEXT, 
	host_subspecf_genlin TEXT, 
	host_symbiont TEXT, 
	host_taxid TEXT, 
	host_tot_mass TEXT, 
	host_wet_mass TEXT, 
	humidity_regm TEXT, 
	lat_lon TEXT, 
	light_regm TEXT, 
	mechanical_damage TEXT, 
	mineral_nutr_regm TEXT, 
	misc_param TEXT, 
	non_min_nutr_regm TEXT, 
	organism_count TEXT, 
	oxy_stat_samp VARCHAR(17), 
	perturbation TEXT, 
	pesticide_regm TEXT, 
	ph_regm TEXT, 
	plant_growth_med TEXT, 
	plant_product TEXT, 
	plant_sex VARCHAR(19), 
	plant_struc TEXT, 
	radiation_regm TEXT, 
	rainfall_regm TEXT, 
	rel_to_oxygen VARCHAR(17), 
	root_cond TEXT, 
	root_med_carbon TEXT, 
	root_med_macronutr TEXT, 
	root_med_micronutr TEXT, 
	root_med_ph TEXT, 
	root_med_regl TEXT, 
	root_med_solid TEXT, 
	root_med_suppl TEXT, 
	salinity TEXT, 
	salt_regm TEXT, 
	samp_capt_status VARCHAR(48), 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_dis_stage VARCHAR(23), 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	season_environment TEXT, 
	size_frac TEXT, 
	specific_ecosystem TEXT, 
	standing_water_regm TEXT, 
	"temp" TEXT, 
	tiss_cult_growth_med TEXT, 
	water_temp_regm TEXT, 
	watering_regm TEXT, 
	analysis_type VARCHAR(19) NOT NULL, 
	samp_name TEXT, 
	source_mat_id TEXT, 
	env_package TEXT NOT NULL, 
	sample_link TEXT, 
	PRIMARY KEY (air_temp_regm, alt, ances_data, antibiotic_regm, biol_stat, biotic_regm, chem_administration, chem_mutagen, climate_environment, collection_date, cult_root_med, depth, ecosystem, ecosystem_category, ecosystem_subtype, ecosystem_type, elev, env_broad_scale, env_local_scale, env_medium, experimental_factor, fertilizer_regm, fungicide_regm, gaseous_environment, genetic_mod, geo_loc_name, gravity, growth_facil, growth_habit, growth_hormone_regm, herbicide_regm, horizon_meth, host_age, host_common_name, host_dry_mass, host_genotype, host_height, host_length, host_life_stage, host_phenotype, host_subspecf_genlin, host_symbiont, host_taxid, host_tot_mass, host_wet_mass, humidity_regm, lat_lon, light_regm, mechanical_damage, mineral_nutr_regm, misc_param, non_min_nutr_regm, organism_count, oxy_stat_samp, perturbation, pesticide_regm, ph_regm, plant_growth_med, plant_product, plant_sex, plant_struc, radiation_regm, rainfall_regm, rel_to_oxygen, root_cond, root_med_carbon, root_med_macronutr, root_med_micronutr, root_med_ph, root_med_regl, root_med_solid, root_med_suppl, salinity, salt_regm, samp_capt_status, samp_collec_device, samp_collec_method, samp_dis_stage, samp_mat_process, samp_size, samp_store_dur, samp_store_loc, samp_store_temp, season_environment, size_frac, specific_ecosystem, standing_water_regm, "temp", tiss_cult_growth_med, water_temp_regm, watering_regm, analysis_type, samp_name, source_mat_id, env_package, sample_link)
);

CREATE TABLE "SampleData" (
	air_data TEXT, 
	biofilm_data TEXT, 
	built_env_data TEXT, 
	host_associated_data TEXT, 
	plant_associated_data TEXT, 
	sediment_data TEXT, 
	soil_data TEXT, 
	wastewater_sludge_data TEXT, 
	water_data TEXT, 
	emsl_data TEXT, 
	jgi_mg_data TEXT, 
	jgi_mt_data TEXT, 
	PRIMARY KEY (air_data, biofilm_data, built_env_data, host_associated_data, plant_associated_data, sediment_data, soil_data, wastewater_sludge_data, water_data, emsl_data, jgi_mg_data, jgi_mt_data)
);

CREATE TABLE "SedimentInterface" (
	alkalinity TEXT, 
	alkyl_diethers TEXT, 
	alt TEXT, 
	aminopept_act TEXT, 
	ammonium TEXT, 
	bacteria_carb_prod TEXT, 
	biomass TEXT, 
	bishomohopanol TEXT, 
	bromide TEXT, 
	calcium TEXT, 
	carb_nitro_ratio TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	chlorophyll TEXT, 
	collection_date TEXT, 
	density TEXT, 
	depth TEXT, 
	diether_lipids TEXT, 
	diss_carb_dioxide TEXT, 
	diss_hydrogen TEXT, 
	diss_inorg_carb TEXT, 
	diss_org_carb TEXT, 
	diss_org_nitro TEXT, 
	diss_oxygen TEXT, 
	ecosystem TEXT, 
	ecosystem_category TEXT, 
	ecosystem_subtype TEXT, 
	ecosystem_type TEXT, 
	elev TEXT, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	experimental_factor TEXT, 
	geo_loc_name TEXT, 
	glucosidase_act TEXT, 
	horizon_meth TEXT, 
	lat_lon TEXT, 
	magnesium TEXT, 
	mean_frict_vel TEXT, 
	mean_peak_frict_vel TEXT, 
	methane TEXT, 
	misc_param TEXT, 
	n_alkanes TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	nitro TEXT, 
	org_carb TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	organism_count TEXT, 
	oxy_stat_samp VARCHAR(17), 
	part_org_carb TEXT, 
	particle_class TEXT, 
	perturbation TEXT, 
	petroleum_hydrocarb TEXT, 
	ph FLOAT, 
	ph_meth TEXT, 
	phaeopigments TEXT, 
	phosphate TEXT, 
	phosplipid_fatt_acid TEXT, 
	porosity TEXT, 
	potassium TEXT, 
	pressure TEXT, 
	redox_potential TEXT, 
	rel_to_oxygen VARCHAR(17), 
	salinity TEXT, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	sediment_type VARCHAR(11), 
	silicate TEXT, 
	size_frac TEXT, 
	sodium TEXT, 
	specific_ecosystem TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	"temp" TEXT, 
	tidal_stage VARCHAR(10), 
	tot_carb TEXT, 
	tot_depth_water_col TEXT, 
	tot_nitro_content TEXT, 
	tot_org_carb TEXT, 
	turbidity TEXT, 
	water_content TEXT, 
	analysis_type VARCHAR(19) NOT NULL, 
	samp_name TEXT, 
	source_mat_id TEXT, 
	env_package TEXT NOT NULL, 
	sample_link TEXT, 
	PRIMARY KEY (alkalinity, alkyl_diethers, alt, aminopept_act, ammonium, bacteria_carb_prod, biomass, bishomohopanol, bromide, calcium, carb_nitro_ratio, chem_administration, chloride, chlorophyll, collection_date, density, depth, diether_lipids, diss_carb_dioxide, diss_hydrogen, diss_inorg_carb, diss_org_carb, diss_org_nitro, diss_oxygen, ecosystem, ecosystem_category, ecosystem_subtype, ecosystem_type, elev, env_broad_scale, env_local_scale, env_medium, experimental_factor, geo_loc_name, glucosidase_act, horizon_meth, lat_lon, magnesium, mean_frict_vel, mean_peak_frict_vel, methane, misc_param, n_alkanes, nitrate, nitrite, nitro, org_carb, org_matter, org_nitro, organism_count, oxy_stat_samp, part_org_carb, particle_class, perturbation, petroleum_hydrocarb, ph, ph_meth, phaeopigments, phosphate, phosplipid_fatt_acid, porosity, potassium, pressure, redox_potential, rel_to_oxygen, salinity, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, samp_store_dur, samp_store_loc, samp_store_temp, sediment_type, silicate, size_frac, sodium, specific_ecosystem, sulfate, sulfide, "temp", tidal_stage, tot_carb, tot_depth_water_col, tot_nitro_content, tot_org_carb, turbidity, water_content, analysis_type, samp_name, source_mat_id, env_package, sample_link)
);

CREATE TABLE "SoilInterface" (
	agrochem_addition TEXT, 
	air_temp_regm TEXT, 
	al_sat TEXT, 
	al_sat_meth TEXT, 
	alt TEXT, 
	ammonium_nitrogen TEXT, 
	annual_precpt TEXT, 
	annual_temp TEXT, 
	biotic_regm TEXT, 
	biotic_relationship VARCHAR(11), 
	carb_nitro_ratio TEXT, 
	chem_administration TEXT, 
	climate_environment TEXT, 
	collection_date TEXT, 
	crop_rotation TEXT, 
	cur_land_use VARCHAR(93), 
	cur_vegetation TEXT, 
	cur_vegetation_meth TEXT, 
	depth TEXT, 
	drainage_class VARCHAR(19), 
	ecosystem TEXT, 
	ecosystem_category TEXT, 
	ecosystem_subtype TEXT, 
	ecosystem_type TEXT, 
	elev TEXT, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	experimental_factor TEXT, 
	extreme_event TEXT, 
	fao_class VARCHAR(13), 
	fire TEXT, 
	flooding TEXT, 
	gaseous_environment TEXT, 
	geo_loc_name TEXT, 
	growth_facil TEXT, 
	heavy_metals TEXT, 
	heavy_metals_meth TEXT, 
	horizon_meth TEXT, 
	humidity_regm TEXT, 
	lat_lon TEXT, 
	lbc_thirty TEXT, 
	lbceq TEXT, 
	light_regm TEXT, 
	link_class_info TEXT, 
	link_climate_info TEXT, 
	local_class TEXT, 
	local_class_meth TEXT, 
	manganese TEXT, 
	micro_biomass_c_meth TEXT, 
	micro_biomass_meth TEXT, 
	micro_biomass_n_meth TEXT, 
	microbial_biomass TEXT, 
	microbial_biomass_c TEXT, 
	microbial_biomass_n TEXT, 
	misc_param TEXT, 
	nitrate_nitrogen TEXT, 
	nitrite_nitrogen TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	oxy_stat_samp VARCHAR(17), 
	ph FLOAT, 
	ph_meth TEXT, 
	phosphate TEXT, 
	prev_land_use_meth TEXT, 
	previous_land_use TEXT, 
	profile_position VARCHAR(9), 
	rel_to_oxygen VARCHAR(17), 
	salinity TEXT, 
	salinity_meth TEXT, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	samp_store_temp TEXT, 
	season_precpt TEXT, 
	season_temp TEXT, 
	sieving TEXT, 
	size_frac_low TEXT, 
	size_frac_up TEXT, 
	slope_aspect TEXT, 
	slope_gradient TEXT, 
	soil_horizon VARCHAR(10), 
	soil_text_measure TEXT, 
	soil_texture_meth TEXT, 
	soil_type TEXT, 
	soil_type_meth TEXT, 
	specific_ecosystem TEXT, 
	store_cond TEXT, 
	"temp" TEXT, 
	tillage VARCHAR(13), 
	tot_carb TEXT, 
	tot_nitro_cont_meth TEXT, 
	tot_nitro_content TEXT, 
	tot_org_c_meth TEXT, 
	tot_org_carb TEXT, 
	tot_phosp TEXT, 
	water_cont_soil_meth TEXT, 
	water_content TEXT, 
	watering_regm TEXT, 
	zinc TEXT, 
	analysis_type VARCHAR(19) NOT NULL, 
	samp_name TEXT, 
	source_mat_id TEXT, 
	env_package TEXT NOT NULL, 
	sample_link TEXT, 
	collection_date_inc TEXT, 
	collection_time TEXT, 
	collection_time_inc TEXT, 
	experimental_factor_other TEXT, 
	filter_method TEXT, 
	isotope_exposure TEXT, 
	non_microb_biomass TEXT, 
	non_microb_biomass_method TEXT, 
	org_nitro_method TEXT, 
	other_treatment TEXT, 
	start_date_inc TEXT, 
	start_time_inc TEXT, 
	PRIMARY KEY (agrochem_addition, air_temp_regm, al_sat, al_sat_meth, alt, ammonium_nitrogen, annual_precpt, annual_temp, biotic_regm, biotic_relationship, carb_nitro_ratio, chem_administration, climate_environment, collection_date, crop_rotation, cur_land_use, cur_vegetation, cur_vegetation_meth, depth, drainage_class, ecosystem, ecosystem_category, ecosystem_subtype, ecosystem_type, elev, env_broad_scale, env_local_scale, env_medium, experimental_factor, extreme_event, fao_class, fire, flooding, gaseous_environment, geo_loc_name, growth_facil, heavy_metals, heavy_metals_meth, horizon_meth, humidity_regm, lat_lon, lbc_thirty, lbceq, light_regm, link_class_info, link_climate_info, local_class, local_class_meth, manganese, micro_biomass_c_meth, micro_biomass_meth, micro_biomass_n_meth, microbial_biomass, microbial_biomass_c, microbial_biomass_n, misc_param, nitrate_nitrogen, nitrite_nitrogen, org_matter, org_nitro, oxy_stat_samp, ph, ph_meth, phosphate, prev_land_use_meth, previous_land_use, profile_position, rel_to_oxygen, salinity, salinity_meth, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, samp_store_temp, season_precpt, season_temp, sieving, size_frac_low, size_frac_up, slope_aspect, slope_gradient, soil_horizon, soil_text_measure, soil_texture_meth, soil_type, soil_type_meth, specific_ecosystem, store_cond, "temp", tillage, tot_carb, tot_nitro_cont_meth, tot_nitro_content, tot_org_c_meth, tot_org_carb, tot_phosp, water_cont_soil_meth, water_content, watering_regm, zinc, analysis_type, samp_name, source_mat_id, env_package, sample_link, collection_date_inc, collection_time, collection_time_inc, experimental_factor_other, filter_method, isotope_exposure, non_microb_biomass, non_microb_biomass_method, org_nitro_method, other_treatment, start_date_inc, start_time_inc)
);

CREATE TABLE "WastewaterSludgeInterface" (
	alkalinity TEXT, 
	alt TEXT, 
	biochem_oxygen_dem TEXT, 
	chem_administration TEXT, 
	chem_oxygen_dem TEXT, 
	collection_date TEXT, 
	depth TEXT, 
	ecosystem TEXT, 
	ecosystem_category TEXT, 
	ecosystem_subtype TEXT, 
	ecosystem_type TEXT, 
	efficiency_percent TEXT, 
	elev TEXT, 
	emulsions TEXT, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	experimental_factor TEXT, 
	gaseous_substances TEXT, 
	geo_loc_name TEXT, 
	horizon_meth TEXT, 
	indust_eff_percent TEXT, 
	inorg_particles TEXT, 
	lat_lon TEXT, 
	misc_param TEXT, 
	nitrate TEXT, 
	org_particles TEXT, 
	organism_count TEXT, 
	oxy_stat_samp VARCHAR(17), 
	perturbation TEXT, 
	ph FLOAT, 
	ph_meth TEXT, 
	phosphate TEXT, 
	pre_treatment TEXT, 
	primary_treatment TEXT, 
	reactor_type TEXT, 
	rel_to_oxygen VARCHAR(17), 
	salinity TEXT, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	secondary_treatment TEXT, 
	sewage_type TEXT, 
	size_frac TEXT, 
	sludge_retent_time TEXT, 
	sodium TEXT, 
	soluble_inorg_mat TEXT, 
	soluble_org_mat TEXT, 
	specific_ecosystem TEXT, 
	suspend_solids TEXT, 
	"temp" TEXT, 
	tertiary_treatment TEXT, 
	tot_nitro TEXT, 
	tot_phosphate TEXT, 
	wastewater_type TEXT, 
	analysis_type VARCHAR(19) NOT NULL, 
	samp_name TEXT, 
	source_mat_id TEXT, 
	env_package TEXT NOT NULL, 
	sample_link TEXT, 
	PRIMARY KEY (alkalinity, alt, biochem_oxygen_dem, chem_administration, chem_oxygen_dem, collection_date, depth, ecosystem, ecosystem_category, ecosystem_subtype, ecosystem_type, efficiency_percent, elev, emulsions, env_broad_scale, env_local_scale, env_medium, experimental_factor, gaseous_substances, geo_loc_name, horizon_meth, indust_eff_percent, inorg_particles, lat_lon, misc_param, nitrate, org_particles, organism_count, oxy_stat_samp, perturbation, ph, ph_meth, phosphate, pre_treatment, primary_treatment, reactor_type, rel_to_oxygen, salinity, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, samp_store_dur, samp_store_loc, samp_store_temp, secondary_treatment, sewage_type, size_frac, sludge_retent_time, sodium, soluble_inorg_mat, soluble_org_mat, specific_ecosystem, suspend_solids, "temp", tertiary_treatment, tot_nitro, tot_phosphate, wastewater_type, analysis_type, samp_name, source_mat_id, env_package, sample_link)
);

CREATE TABLE "WaterInterface" (
	alkalinity TEXT, 
	alkalinity_method TEXT, 
	alkyl_diethers TEXT, 
	alt TEXT, 
	aminopept_act TEXT, 
	ammonium TEXT, 
	atmospheric_data TEXT, 
	bac_prod TEXT, 
	bac_resp TEXT, 
	bacteria_carb_prod TEXT, 
	biomass TEXT, 
	bishomohopanol TEXT, 
	bromide TEXT, 
	calcium TEXT, 
	carb_nitro_ratio TEXT, 
	chem_administration TEXT, 
	chloride TEXT, 
	chlorophyll TEXT, 
	collection_date TEXT, 
	conduc TEXT, 
	density TEXT, 
	depth TEXT, 
	diether_lipids TEXT, 
	diss_carb_dioxide TEXT, 
	diss_hydrogen TEXT, 
	diss_inorg_carb TEXT, 
	diss_inorg_nitro TEXT, 
	diss_inorg_phosp TEXT, 
	diss_org_carb TEXT, 
	diss_org_nitro TEXT, 
	diss_oxygen TEXT, 
	down_par TEXT, 
	ecosystem TEXT, 
	ecosystem_category TEXT, 
	ecosystem_subtype TEXT, 
	ecosystem_type TEXT, 
	elev TEXT, 
	env_broad_scale TEXT, 
	env_local_scale TEXT, 
	env_medium TEXT, 
	experimental_factor TEXT, 
	fluor TEXT, 
	geo_loc_name TEXT, 
	glucosidase_act TEXT, 
	horizon_meth TEXT, 
	lat_lon TEXT, 
	light_intensity TEXT, 
	mean_frict_vel TEXT, 
	mean_peak_frict_vel TEXT, 
	misc_param TEXT, 
	n_alkanes TEXT, 
	nitrate TEXT, 
	nitrite TEXT, 
	nitro TEXT, 
	org_carb TEXT, 
	org_matter TEXT, 
	org_nitro TEXT, 
	organism_count TEXT, 
	oxy_stat_samp VARCHAR(17), 
	part_org_carb TEXT, 
	part_org_nitro TEXT, 
	perturbation TEXT, 
	petroleum_hydrocarb TEXT, 
	ph FLOAT, 
	ph_meth TEXT, 
	phaeopigments TEXT, 
	phosphate TEXT, 
	phosplipid_fatt_acid TEXT, 
	photon_flux TEXT, 
	potassium TEXT, 
	pressure TEXT, 
	primary_prod TEXT, 
	redox_potential TEXT, 
	rel_to_oxygen VARCHAR(17), 
	salinity TEXT, 
	samp_collec_device TEXT, 
	samp_collec_method TEXT, 
	samp_mat_process TEXT, 
	samp_size TEXT, 
	samp_store_dur TEXT, 
	samp_store_loc TEXT, 
	samp_store_temp TEXT, 
	silicate TEXT, 
	size_frac TEXT, 
	size_frac_low TEXT, 
	size_frac_up TEXT, 
	sodium TEXT, 
	soluble_react_phosp TEXT, 
	specific_ecosystem TEXT, 
	sulfate TEXT, 
	sulfide TEXT, 
	suspend_part_matter TEXT, 
	"temp" TEXT, 
	tidal_stage VARCHAR(10), 
	tot_depth_water_col TEXT, 
	tot_diss_nitro TEXT, 
	tot_inorg_nitro TEXT, 
	tot_nitro TEXT, 
	tot_part_carb TEXT, 
	turbidity TEXT, 
	water_current TEXT, 
	analysis_type VARCHAR(19) NOT NULL, 
	samp_name TEXT, 
	source_mat_id TEXT, 
	env_package TEXT NOT NULL, 
	sample_link TEXT, 
	PRIMARY KEY (alkalinity, alkalinity_method, alkyl_diethers, alt, aminopept_act, ammonium, atmospheric_data, bac_prod, bac_resp, bacteria_carb_prod, biomass, bishomohopanol, bromide, calcium, carb_nitro_ratio, chem_administration, chloride, chlorophyll, collection_date, conduc, density, depth, diether_lipids, diss_carb_dioxide, diss_hydrogen, diss_inorg_carb, diss_inorg_nitro, diss_inorg_phosp, diss_org_carb, diss_org_nitro, diss_oxygen, down_par, ecosystem, ecosystem_category, ecosystem_subtype, ecosystem_type, elev, env_broad_scale, env_local_scale, env_medium, experimental_factor, fluor, geo_loc_name, glucosidase_act, horizon_meth, lat_lon, light_intensity, mean_frict_vel, mean_peak_frict_vel, misc_param, n_alkanes, nitrate, nitrite, nitro, org_carb, org_matter, org_nitro, organism_count, oxy_stat_samp, part_org_carb, part_org_nitro, perturbation, petroleum_hydrocarb, ph, ph_meth, phaeopigments, phosphate, phosplipid_fatt_acid, photon_flux, potassium, pressure, primary_prod, redox_potential, rel_to_oxygen, salinity, samp_collec_device, samp_collec_method, samp_mat_process, samp_size, samp_store_dur, samp_store_loc, samp_store_temp, silicate, size_frac, size_frac_low, size_frac_up, sodium, soluble_react_phosp, specific_ecosystem, sulfate, sulfide, suspend_part_matter, "temp", tidal_stage, tot_depth_water_col, tot_diss_nitro, tot_inorg_nitro, tot_nitro, tot_part_carb, turbidity, water_current, analysis_type, samp_name, source_mat_id, env_package, sample_link)
);
