/*
 * Copyright (C) 2003, 2004 Bjrn-Ove Heimsund
 * 
 * This file is part of MT.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package mt.test;

import mt.DenseMatrix;

/**
 * Test of a dense matrix
 */
public class DenseMatrixTest extends MatrixTest {

	public DenseMatrixTest(String arg0) {
		super(arg0);
	}

	protected void setup() throws Exception {
		int n = Utilities.getInt(max), m = Utilities.getInt(max);
		A = new DenseMatrix(n, m);
		Ad = Utilities.populate(A);
	}

	public void testMatrixSolve() {
		if (A.isSquare())
			super.testMatrixSolve();
	}

	public void testTransMatrixSolve() {
		if (A.isSquare())
			super.testTransMatrixSolve();
	}

	public void testTransVectorSolve() {
		if (A.isSquare())
			super.testTransVectorSolve();
	}

	public void testVectorSolve() {
		if (A.isSquare())
			super.testVectorSolve();
	}

}
