/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.util.data;

import ru.sscc.util.data.FloatPointer;
import ru.sscc.util.data.FloatVector;
import ru.sscc.util.data.RealContainer;
import ru.sscc.util.data.RealMath;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealVector;

public final class FloatContainer
extends RealContainer {
    float[] data;

    public FloatContainer(int n) {
        this.data = new float[n];
    }

    public FloatContainer(float[] fArray) {
        this.data = fArray;
    }

    public double add(int n, double d) {
        int n2 = n;
        float f = (float)((double)this.data[n2] + d);
        this.data[n2] = f;
        return f;
    }

    public void addVector(int n, int n2, int n3, int n4, double d, int n5) {
        RealMath.addVector(this.data, n, n2, this.data, n3, n4, d, n5);
    }

    public void assign(int n, int n2, int n3, int n4, int n5) {
        RealMath.assign(this.data, n, n2, this.data, n3, n4, n5);
    }

    public Object clone() {
        FloatContainer floatContainer = (FloatContainer)super.clone();
        floatContainer.data = (float[])this.data.clone();
        return floatContainer;
    }

    public double get(int n) {
        return this.data[n];
    }

    public Object getContainer() {
        return this.data;
    }

    public RealPointer getPointer() {
        return new FloatPointer(this.data);
    }

    public RealVector getVector(int n, int n2, int n3) {
        return new FloatVector(this.data, n3, n, n2);
    }

    public int indexOfNormMax(int n, int n2, int n3) {
        return RealMath.indexOfNormMax(this.data, n, n2, n3);
    }

    public void moveVector(RealVector realVector, int n) {
        try {
            FloatVector floatVector = (FloatVector)realVector;
            if (this.data.equals(floatVector.data)) {
                floatVector.index = n;
                return;
            }
        }
        catch (Exception exception) {}
        throw new IllegalArgumentException("Cannot move an alien vector");
    }

    public double mul(int n, double d) {
        int n2 = n;
        float f = (float)((double)this.data[n2] * d);
        this.data[n2] = f;
        return f;
    }

    public void multiply(int n, int n2, double d, int n3) {
        RealMath.multiply(this.data, n, n2, d, n3);
    }

    public RealContainer newContainer(int n) {
        return new FloatContainer(n);
    }

    public double normMax(int n, int n2, int n3) {
        return RealMath.normMax(this.data, n, n2, n3);
    }

    public double normSum(int n, int n2, int n3) {
        return RealMath.normSum(this.data, n, n2, n3);
    }

    public double normalize(int n, int n2, double d, int n3) {
        double d2 = 0.0;
        while (n3-- > 0) {
            int n4 = n;
            float f = (float)((double)this.data[n4] * d);
            this.data[n4] = f;
            d2 += (double)Math.abs(f);
            n += n2;
        }
        return d2;
    }

    public double postProduct(int n, int n2, int n3, int n4, int n5) {
        return RealMath.innerProduct(this.data, n, n2, this.data, n3, n4, n5);
    }

    public double postProduct(int n, int n2, RealPointer realPointer, int n3) {
        if (n3 <= 0) {
            return 0.0;
        }
        if (realPointer instanceof FloatPointer) {
            return RealMath.innerProduct(this.data, n, n2, ((FloatPointer)realPointer).data, realPointer.index, realPointer.step, n3);
        }
        double d = 0.0;
        int n4 = 0;
        while (n4 < n3) {
            d += (double)this.data[n] * realPointer.get();
            ++n4;
            n += n2;
            realPointer.next();
        }
        realPointer.shift(-n3);
        return d;
    }

    public double preProduct(int n, int n2, int n3, int n4, int n5) {
        return RealMath.innerProduct(this.data, n + n2, n2, this.data, n3 + n4, n4, n5);
    }

    public double preProduct(int n, int n2, RealPointer realPointer, int n3) {
        if (n3 <= 0) {
            return 0.0;
        }
        if (realPointer instanceof FloatPointer) {
            return RealMath.innerProduct(this.data, n + n2, n2, ((FloatPointer)realPointer).data, realPointer.index + realPointer.step, realPointer.step, n3);
        }
        double d = 0.0;
        int n4 = 0;
        while (n4 < n3) {
            realPointer.next();
            d += (double)this.data[n += n2] * realPointer.get();
            ++n4;
        }
        realPointer.shift(-n3);
        return d;
    }

    public double relativeAccuracy() {
        return 1.1920928955078125E-7;
    }

    public void resize(int n) {
        if (n == this.data.length) {
            return;
        }
        float[] fArray = new float[n];
        RealMath.assign(fArray, 0, 1, this.data, 0, 1, Math.min(this.data.length, n));
        this.data = fArray;
    }

    public void rotate(double d, double d2, int n, int n2, int n3, int n4, int n5) {
        while (n5-- > 0) {
            double d3 = this.data[n];
            double d4 = this.data[n3];
            this.data[n] = (float)(d3 * d + d4 * d2);
            this.data[n3] = (float)(-d3 * d2 + d4 * d);
            n += n2;
            n3 += n4;
        }
    }

    public double set(int n, double d) {
        this.data[n] = (float)d;
        return d;
    }

    public int size() {
        return this.data.length;
    }

    public void swap(int n, int n2, int n3, int n4, int n5) {
        RealMath.swap(this.data, n, n2, this.data, n3, n4, n5);
    }

    public double weightedNormMax(int n, int n2, RealPointer realPointer, int n3) {
        return RealMath.weightedNormMax(this.data, n, n2, realPointer, n3);
    }

    public double weightedNormSum(int n, int n2, RealPointer realPointer, int n3) {
        return RealMath.weightedNormSum(this.data, n, n2, realPointer, n3);
    }

    public double weightedProduct(int n, int n2, int n3, int n4, RealPointer realPointer, int n5) {
        return RealMath.weightedProduct(this.data, n, n2, this.data, n3, n4, realPointer, n5);
    }
}

