/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.util;

import ru.sscc.util.data.RealContainer;
import ru.sscc.util.data.RealPointer;

public final class Rotation {
    private double cos = 1.0;
    private double sin = 0.0;

    public void construct(double d) {
        double d2 = 2.0 / (1.0 + d * d);
        this.cos = d2 - 1.0;
        this.sin = d * d2;
    }

    public double construct(double d, double d2) {
        double d3;
        int n = 1;
        if (d < 0.0) {
            d = -d;
            d2 = -d2;
            n = -1;
        }
        int n2 = 1;
        if (d2 < 0.0) {
            d2 = -d2;
            n2 = -1;
        }
        if (d > d2) {
            d3 = Math.sqrt(1.0 + (d2 /= d) * d2);
            this.cos = 1.0 / d3;
            this.sin = (double)n2 * d2 / d3;
            d3 *= d;
        } else if (d2 > d || d != 0.0) {
            d3 = Math.sqrt((d /= d2) * d + 1.0);
            this.cos = d / d3;
            this.sin = (double)n2 / d3;
            d3 *= d2;
        } else {
            this.cos = 1.0;
            this.sin = 0.0;
            d3 = 0.0;
        }
        return (double)n * d3;
    }

    public void construct(RealPointer realPointer, RealPointer realPointer2) {
        realPointer.set(this.construct(realPointer.get(), realPointer2.get()));
        realPointer2.set(this.tan());
    }

    public void constructAndRotate(RealContainer realContainer, int n, int n2, int n3, int n4, int n5) {
        realContainer.set(n, this.construct(realContainer.get(n), realContainer.get(n3)));
        realContainer.set(n3, this.tan());
        this.rotate(realContainer, n + n2, n2, n3 + n4, n4, n5 - 1);
    }

    public final void rotate(RealContainer realContainer, int n, int n2, int n3, int n4, int n5) {
        if (this.sin != 0.0) {
            realContainer.rotate(this.cos, this.sin, n, n2, n3, n4, n5);
        }
    }

    public void rotate(RealPointer realPointer, RealPointer realPointer2) {
        double d = realPointer.get();
        double d2 = realPointer2.get();
        realPointer.set(d * this.cos + d2 * this.sin);
        realPointer2.set(-d * this.sin + d2 * this.cos);
    }

    public final double tan() {
        return this.sin / (1.0 + this.cos);
    }
}

