/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.spline.polynomial;

import java.io.Serializable;
import ru.sscc.matrix.RectBandedMatrix;
import ru.sscc.spline.base.SimpleMesh;
import ru.sscc.spline.polynomial.PSplineBody;
import ru.sscc.util.data.RealContainer;
import ru.sscc.util.data.RealMath;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealVector;

public class PSplineCalculator
implements Serializable {
    protected RectBandedMatrix h;
    protected PSplineBody body;
    private double[] p;
    private double[] r;
    private double[] multiples;

    public PSplineCalculator(PSplineBody pSplineBody, RectBandedMatrix rectBandedMatrix) {
        this.body = pSplineBody;
        this.h = rectBandedMatrix;
        int n = pSplineBody.interCount;
        int n2 = n - pSplineBody.extraCount;
        this.p = new double[2 * n2];
        this.r = new double[n2];
        this.multiples = new double[n];
        double d = 1.0;
        int n3 = 0;
        while (n3 < n) {
            this.multiples[n3] = d;
            d /= (double)(++n3);
        }
    }

    protected void calcDFg(RealVector realVector, RealVector realVector2) {
        SimpleMesh simpleMesh = this.body.getMesh();
        RealContainer realContainer = this.h.getContainer();
        int n = this.h.isToeplitz() ? 0 : this.h.bandWidth;
        int n2 = this.body.interCount;
        int n3 = n2 - this.body.extraCount;
        int n4 = simpleMesh.size - 1;
        RealPointer realPointer = realVector2.getPointer(n2 - 1, -1);
        RealPointer realPointer2 = realVector.getPointer();
        int n5 = this.h.nRows;
        double d = (n3 & 1) == 0 ? 1 : -1;
        int n6 = 0;
        int n7 = 0;
        while (n6 < n4) {
            int n8 = Math.min(n6 + 1, n3);
            int n9 = 0;
            while (n9 < n8) {
                double d2 = realContainer.postProduct(n7 - n9, n - 1, realPointer2, Math.min(n8 - n9, n5)) * d;
                double d3 = simpleMesh.distance(n6, n6 - n9);
                int n10 = 0;
                while (n10 < n3) {
                    realPointer.add(d2);
                    d2 *= d3 / (double)(++n10);
                    realPointer.next();
                }
                realPointer.shift(-n3);
                ++n9;
            }
            if (n8 == n3) {
                n7 += n - 1;
                --n5;
                realPointer2.next();
            }
            ++n6;
            realPointer.shift(-n2);
            ++n7;
        }
    }

    protected void calcDFl(RealVector realVector, RealVector realVector2) {
        SimpleMesh simpleMesh = this.body.getMesh();
        int n = this.body.interCount;
        int n2 = this.r.length;
        int n3 = simpleMesh.size;
        RealPointer realPointer = realVector.getPointer();
        if (n >= 2 * n2) {
            RealMath.assign(realVector2.getPointer(n - 2 * n2, n), realPointer, n3);
        }
        if (n2 == 1) {
            return;
        }
        RealPointer realPointer2 = realVector2.getPointer(n - n2, 1);
        int n4 = 1;
        int n5 = 0;
        while (n4 > 0) {
            this.calcLocalDFl(realPointer, realPointer2, n2, n, simpleMesh, n5);
            n4 = Math.min(n2, n3 - n2);
            realPointer.shift(n4);
            realPointer2.shift(n4 * n);
            n3 -= n4;
            n5 += n4;
        }
    }

    private void calcLocalDFl(RealPointer realPointer, RealPointer realPointer2, int n, int n2, SimpleMesh simpleMesh, int n3) {
        int n4;
        int n5 = this.p.length;
        this.p[0] = realPointer.get();
        int n6 = n - 1;
        while (n6 > 0) {
            this.p[n6] = realPointer2.previous().get();
            --n6;
        }
        realPointer2.shift(n - 1);
        this.r[0] = 0.0;
        n6 = 1;
        while (n6 < n) {
            n4 = n;
            while (n4 < n5) {
                this.p[n4] = realPointer2.get();
                ++n4;
                realPointer2.next();
            }
            realPointer2.shift(n2 - n);
            PSplineCalculator.recalculate(this.p, this.p, simpleMesh.distance(n3 + n6, n3 + n6 - 1), n5, n);
            this.r[n6] = realPointer.next().get() - this.p[0];
            n4 = n - 1;
            while (n4 > 0) {
                realPointer2.previous().set(this.p[n4]);
                --n4;
            }
            realPointer2.shift(n - 1);
            ++n6;
        }
        realPointer2.shift(-n2 * (n - 1));
        realPointer.shift(1 - n);
        n6 = 1;
        while (n6 < n) {
            n4 = n;
            while (n4-- > n6) {
                this.r[n4] = (this.r[n4] - this.r[n4 - 1]) / simpleMesh.distance(n3 + n4, n3 + n4 - n6);
            }
            ++n6;
        }
        this.p[n] = 0.0;
        n6 = 0;
        while (n6 < n) {
            this.p[n - 1] = this.r[n - 1];
            n4 = n - 1;
            while (n4-- > 0) {
                double d = simpleMesh.distance(n3 + n4, n3 + n6);
                this.p[n4] = this.r[n4] - d * this.p[n4 + 1];
                int n7 = n4 + 1;
                while (n7 < n) {
                    this.p[n7] = (double)(n7 - n4) * this.p[n7] - d * this.p[n7 + 1];
                    ++n7;
                }
            }
            n4 = n - 1;
            while (n4 > 0) {
                realPointer2.previous().add(this.p[n4]);
                --n4;
            }
            realPointer2.shift(n2 + n - 1);
            ++n6;
        }
        realPointer2.shift(-n2 * n);
    }

    public void calculate(RealVector realVector, RealVector realVector2, RealVector realVector3) {
        int n = this.body.getVectorLength();
        realVector3.assign(0.0, n);
        this.calcDFg(realVector, realVector3);
        this.calcDFl(realVector2, realVector3);
        int n2 = this.multiples.length;
        int n3 = 0;
        RealPointer realPointer = realVector3.getPointer();
        int n4 = 0;
        while (n4 < n) {
            if (n3 == n2) {
                n3 = 0;
            }
            realPointer.mul(this.multiples[n3]);
            ++n4;
            ++n3;
            realPointer.next();
        }
    }

    public double calculationCost() {
        int n = this.h.bandWidth;
        int n2 = this.body.interCount;
        int n3 = n2 - this.body.extraCount;
        return ((double)(n * (n - 1)) + 3.0 * (double)(n2 - this.body.extraCount)) * (double)(this.h.nColumns - 1) + 8.0 * (double)n3 * (double)n3 * (double)this.body.getMesh().size;
    }

    public static void recalculate(double[] dArray, double[] dArray2, double d, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            double d2 = 1.0;
            double d3 = 0.0;
            int n4 = n3;
            while (n4 < n) {
                d3 += dArray[n4] * d2;
                d2 *= d / (double)(++n4 - n3);
            }
            dArray2[n3] = d3;
            ++n3;
        }
    }
}

