/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.spline.base;

import ru.sscc.spline.base.ReducedMesh;
import ru.sscc.util.BoundingBox;
import ru.sscc.util.data.FloatVectors;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealVectors;

public class ScaledMesh
extends ReducedMesh {
    protected RealVectors points;
    protected double[] origin;
    protected double[] scale;

    public ScaledMesh(RealVectors realVectors) {
        super(realVectors.dimension, realVectors.dimension, realVectors.size);
        BoundingBox boundingBox = realVectors.boundingBox();
        int n = 0;
        while (n < this.initialDimension) {
            double d = boundingBox.width(n);
            this.scale[n] = d == 0.0 ? 1.0 : 1.0 / d;
            ++n;
        }
        this.prepareMesh(realVectors);
    }

    public ScaledMesh(RealVectors realVectors, RealPointer realPointer) {
        super(realVectors.dimension, realVectors.dimension, realVectors.size);
        this.scale = new double[this.reducedDimension];
        int n = 0;
        while (n < this.initialDimension) {
            this.scale[n] = realPointer.get();
            ++n;
            realPointer.next();
        }
        realPointer.shift(-this.initialDimension);
        this.prepareMesh(realVectors);
    }

    private void prepareMesh(RealVectors realVectors) {
        float[] fArray = new float[this.reducedDimension * this.size];
        this.origin = new double[this.reducedDimension];
        this.points = new FloatVectors(fArray, this.reducedDimension, this.size);
        RealPointer realPointer = realVectors.getPointer(0);
        int n = 0;
        while (n < this.reducedDimension) {
            this.origin[n] = realPointer.get();
            ++n;
            realPointer.next();
        }
        realPointer = realVectors.getPointers();
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.size) {
            n = 0;
            while (n < this.reducedDimension) {
                fArray[n3] = (float)(this.scale[n] * (realPointer.get() - this.origin[n]));
                ++n;
                ++n3;
                realPointer.next();
            }
            ++n2;
        }
    }

    public void putNode(int n, RealPointer realPointer) {
        this.points.assign(realPointer, n);
    }

    public void reducePoint(RealPointer realPointer, RealPointer realPointer2) {
        int n = 0;
        while (n < this.reducedDimension) {
            realPointer2.set(this.scale[n] * (realPointer.get() - this.origin[n]));
            ++n;
            realPointer.next();
            realPointer2.next();
        }
        realPointer.shift(-this.reducedDimension);
        realPointer2.shift(-this.reducedDimension);
    }

    public double squaredDistance(int n, RealPointer realPointer) {
        return this.points.squaredDistance(n, realPointer);
    }
}

