/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.spline.base;

import ru.sscc.spline.base.NonuniformPreparator;
import ru.sscc.spline.base.OrderedMesh;
import ru.sscc.spline.base.OrderedPreparator;
import ru.sscc.spline.base.SimpleMesh;
import ru.sscc.spline.base.SimpleMeshWorkspace;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealVector;

public class NonuniformMesh
extends OrderedMesh {
    protected float[] points = null;

    public NonuniformMesh(RealVector realVector) {
        this.size = realVector.length;
        this.points = new float[this.size];
        this.origin = realVector.get(0);
        this.points[0] = 0.0f;
        if (this.size < 2) {
            return;
        }
        double d = realVector.get(this.size - 1) - this.origin;
        double d2 = 0.0;
        this.scale = (double)(this.size - 1) / d;
        RealPointer realPointer = realVector.getPointer(1, 1);
        int n = 1;
        while (n < this.size) {
            double d3 = (realPointer.get() - this.origin) * this.scale;
            this.points[n] = (float)d3;
            if (d3 <= d2) {
                throw new IllegalArgumentException("Unordered mesh");
            }
            ++n;
            realPointer.next();
            d2 = d3;
        }
    }

    public final double distance(int n, int n2) {
        return (double)this.points[n] - (double)this.points[n2];
    }

    public void findCell(SimpleMeshWorkspace simpleMeshWorkspace, double d) {
        SimpleMesh.findCell(simpleMeshWorkspace, (d - this.origin) * this.scale, this.points, 0, this.size);
    }

    public final double get(int n) {
        return this.origin + (double)this.points[n] / this.scale;
    }

    public final boolean isUniform() {
        return false;
    }

    public final OrderedPreparator makePreparator(int n) {
        return new NonuniformPreparator(this.points, this.size, n);
    }
}

