/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.eval;

import org.apache.poi.hssf.record.formula.AddPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.NumericOperationEval;
import org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.eval.ValueEvalToNumericXlator;

public class AddEval
extends NumericOperationEval {
    private AddPtg delegate;
    private static final ValueEvalToNumericXlator NUM_XLATOR = new ValueEvalToNumericXlator(27);

    public AddEval(Ptg ptg) {
        this.delegate = (AddPtg)ptg;
    }

    public ValueEvalToNumericXlator getXlator() {
        return NUM_XLATOR;
    }

    public Eval evaluate(Eval[] args, int srcRow, short srcCol) {
        if (args.length != 2) {
            return ErrorEval.VALUE_INVALID;
        }
        double d = 0.0;
        for (int i = 0; i < 2; ++i) {
            ValueEval ve = this.singleOperandEvaluate(args[i], srcRow, srcCol);
            if (ve instanceof ErrorEval) {
                return ve;
            }
            if (ve instanceof NumericValueEval) {
                d += ((NumericValueEval)ve).getNumberValue();
                continue;
            }
            if (ve instanceof BlankEval) continue;
            return ErrorEval.VALUE_INVALID;
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return ErrorEval.NUM_ERROR;
        }
        return new NumberEval(d);
    }

    public int getNumberOfOperands() {
        return this.delegate.getNumberOfOperands();
    }

    public int getType() {
        return this.delegate.getType();
    }
}

