/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.eventusermodel;

import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.dummyrecord.LastCellOfRowDummyRecord;
import org.apache.poi.hssf.eventusermodel.dummyrecord.MissingCellDummyRecord;
import org.apache.poi.hssf.eventusermodel.dummyrecord.MissingRowDummyRecord;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NoteRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.RKRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RowRecord;

public class MissingRecordAwareHSSFListener
implements HSSFListener {
    private HSSFListener childListener;
    private int lastSeenRow = -1;
    private int lastSeenColumn = -1;

    public MissingRecordAwareHSSFListener(HSSFListener listener) {
        this.childListener = listener;
    }

    public void processRecord(Record record) {
        int thisRow = -1;
        int thisColumn = -1;
        switch (record.getSid()) {
            case 2057: {
                BOFRecord bof = (BOFRecord)record;
                if (bof.getType() == 5) {
                    this.lastSeenRow = -1;
                    this.lastSeenColumn = -1;
                    break;
                }
                if (bof.getType() != 16) break;
                this.lastSeenRow = -1;
                this.lastSeenColumn = -1;
                break;
            }
            case 133: {
                BoundSheetRecord bsr = (BoundSheetRecord)record;
                break;
            }
            case 520: {
                RowRecord rowrec = (RowRecord)record;
                if (this.lastSeenRow + 1 < rowrec.getRowNumber()) {
                    for (int i = this.lastSeenRow + 1; i < rowrec.getRowNumber(); ++i) {
                        MissingRowDummyRecord dr = new MissingRowDummyRecord(i);
                        this.childListener.processRecord(dr);
                    }
                }
                this.lastSeenRow = rowrec.getRowNumber();
                break;
            }
            case 513: {
                BlankRecord brec = (BlankRecord)record;
                thisRow = brec.getRow();
                thisColumn = brec.getColumn();
                break;
            }
            case 517: {
                BoolErrRecord berec = (BoolErrRecord)record;
                thisRow = berec.getRow();
                thisColumn = berec.getColumn();
                break;
            }
            case 6: {
                FormulaRecord frec = (FormulaRecord)record;
                thisRow = frec.getRow();
                thisColumn = frec.getColumn();
                break;
            }
            case 516: {
                LabelRecord lrec = (LabelRecord)record;
                thisRow = lrec.getRow();
                thisColumn = lrec.getColumn();
                break;
            }
            case 253: {
                LabelSSTRecord lsrec = (LabelSSTRecord)record;
                thisRow = lsrec.getRow();
                thisColumn = lsrec.getColumn();
                break;
            }
            case 28: {
                NoteRecord nrec = (NoteRecord)record;
                thisRow = nrec.getRow();
                thisColumn = nrec.getColumn();
                break;
            }
            case 515: {
                NumberRecord numrec = (NumberRecord)record;
                thisRow = numrec.getRow();
                thisColumn = numrec.getColumn();
                break;
            }
            case 638: {
                RKRecord rkrec = (RKRecord)record;
                thisRow = rkrec.getRow();
                thisColumn = rkrec.getColumn();
                break;
            }
        }
        if (thisRow != this.lastSeenRow) {
            for (int i = this.lastSeenRow; i < thisRow; ++i) {
                int cols = -1;
                if (i == this.lastSeenRow) {
                    cols = this.lastSeenColumn;
                }
                LastCellOfRowDummyRecord r = new LastCellOfRowDummyRecord(i, cols);
                this.childListener.processRecord(r);
            }
        }
        if (this.lastSeenRow != -1 && this.lastSeenColumn != -1 && thisRow == -1) {
            LastCellOfRowDummyRecord r = new LastCellOfRowDummyRecord(this.lastSeenRow, this.lastSeenColumn);
            this.childListener.processRecord(r);
            this.lastSeenRow = -1;
            this.lastSeenColumn = -1;
        }
        if (thisRow != this.lastSeenRow) {
            this.lastSeenColumn = -1;
        }
        if (this.lastSeenColumn != thisColumn - 1) {
            for (int i = this.lastSeenColumn + 1; i < thisColumn; ++i) {
                MissingCellDummyRecord r = new MissingCellDummyRecord(thisRow, i);
                this.childListener.processRecord(r);
            }
        }
        if (thisColumn != -1) {
            this.lastSeenRow = thisRow;
            this.lastSeenColumn = thisColumn;
        }
        this.childListener.processRecord(record);
    }
}

