/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.logging;

import java.text.Format;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    private static final String NL = System.getProperty("line.separator");
    public static final MessageFormat FORMAT_DEFAULT = new MessageFormat("{0,date,yyyy-MM-dd}  {0,time,HH:mm:ss.SSS}  {1}  {2}  {3}  | {4}{5}");
    public static final MessageFormat FORMAT_PLAIN = new MessageFormat("{4}{5}");
    private final Format mFormat;

    protected MessageFormat getFormatFromProperties() {
        String pname = String.valueOf(this.getClass().getName()) + ".format";
        String fmt = LogManager.getLogManager().getProperty(pname);
        return new MessageFormat(fmt);
    }

    public final MessageFormat getDefaultFormat() {
        try {
            return this.getFormatFromProperties();
        }
        catch (Exception e) {
            System.err.println("ERROR: Using default logger format, cannot use format from properties file, e=" + e);
            return FORMAT_DEFAULT;
        }
    }

    public LogFormatter() {
        this.mFormat = this.getDefaultFormat();
    }

    public LogFormatter(Format format) {
        this.mFormat = format;
    }

    public String format(LogRecord record) {
        LogParameter param = this.getLogParameter(record);
        String termination = LogParameter.FRAGMENTED_LOG_START.equals((Object)param) || LogParameter.FRAGMENTED_LOG_CONTINUE.equals((Object)param) ? "" : NL;
        if (LogParameter.FRAGMENTED_LOG_CONTINUE.equals((Object)param) || LogParameter.FRAGMENTED_LOG_END.equals((Object)param)) {
            return String.valueOf(record.getMessage()) + termination;
        }
        return this.mFormat.format(new Object[]{new Date(), LogFormatter.fixedLen(Thread.currentThread().getName(), 6, ' ', false), LogFormatter.fixedLen(record.getLoggerName(), 15, ' ', false), LogFormatter.fixedLen(record.getLevel().getName(), 7, ' ', false), record.getMessage(), termination});
    }

    private LogParameter getLogParameter(LogRecord record) {
        Object[] params = record.getParameters();
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                LogParameter[] logParameterArray = LogParameter.values();
                int n = logParameterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LogParameter param = logParameterArray[n2];
                    if (param.equals(params[i])) {
                        return param;
                    }
                    ++n2;
                }
                ++i;
            }
        }
        return null;
    }

    private static String fixedLen(String str, int len, char filler, boolean left) {
        if (str == null) {
            str = "" + null;
        }
        if (str.length() < len) {
            StringBuffer sb = new StringBuffer(str);
            do {
                if (left) {
                    sb.insert(0, filler);
                    continue;
                }
                sb.append(filler);
            } while (sb.length() < len);
            str = sb.toString();
        } else if (str.length() > len) {
            str = str.substring(0, len);
        }
        return str;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LogParameter {
        FRAGMENTED_LOG_START,
        FRAGMENTED_LOG_CONTINUE,
        FRAGMENTED_LOG_END;

    }
}

