/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.ints;

import ch.javasoft.util.ints.AbstractIntCollection;
import ch.javasoft.util.ints.IntCollection;
import ch.javasoft.util.ints.IntIterator;
import ch.javasoft.util.ints.IntList;
import ch.javasoft.util.ints.IntListIterator;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIntList
extends AbstractIntCollection
implements IntList,
Cloneable {
    public AbstractIntList() {
    }

    public AbstractIntList(int[] values) {
        super(values);
    }

    public AbstractIntList(IntCollection set) {
        super(set);
    }

    @Override
    public boolean addInt(int value) {
        return this.addInt(this.size(), value);
    }

    @Override
    public void add(int index, Integer element) {
        this.addInt(index, element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Integer> c) {
        boolean any = true;
        for (Integer n : c) {
            any |= this.addInt(index, n);
        }
        return any;
    }

    @Override
    public Integer get(int index) {
        return this.getInt(index);
    }

    public int indexOfInt(int value) {
        int i = 0;
        while (i < this.size()) {
            if (value == this.getInt(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int indexOf(Object o) {
        if (o instanceof Integer || o instanceof Short || o instanceof Byte) {
            return this.indexOfInt(((Number)o).intValue());
        }
        return -1;
    }

    public int lastIndexOfInt(int value) {
        int i = this.size() - 1;
        while (i >= 0) {
            if (value == this.getInt(i)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o instanceof Integer || o instanceof Short || o instanceof Byte) {
            return this.lastIndexOfInt(((Number)o).intValue());
        }
        return -1;
    }

    @Override
    public boolean containsInt(int value) {
        return this.indexOfInt(value) != -1;
    }

    @Override
    public Integer remove(int index) {
        return this.removeIntAt(index);
    }

    @Override
    public boolean removeInt(int value) {
        int index = this.indexOfInt(value);
        if (index != -1) {
            this.removeIntAt(index);
            return true;
        }
        return false;
    }

    public IntListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public IntIterator iterator() {
        return this.listIterator();
    }

    @Override
    public Integer set(int index, Integer element) {
        return this.setInt(index, element);
    }
}

