/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util;

public class Timer {
    private long mStart;
    private long mEnd;
    private long[] mIntermediates;
    private int mIntermediate;

    public Timer() {
        this(3);
    }

    public Timer(int intermediateCount) {
        this.mIntermediates = new long[intermediateCount];
    }

    public void start() {
        this.mStart = System.currentTimeMillis();
        this.mIntermediate = 0;
    }

    public void stop() {
        this.mEnd = System.currentTimeMillis();
        this.stopIntermediate(this.mEnd);
    }

    public void stopIntermediate() {
        this.stopIntermediate(System.currentTimeMillis());
    }

    private void stopIntermediate(long time) {
        if (this.mIntermediate == this.mIntermediates.length) {
            long[] intermediates = new long[this.mIntermediates.length * 2];
            System.arraycopy(this.mIntermediates, 0, intermediates, 0, this.mIntermediate);
            this.mIntermediates = intermediates;
        }
        this.mIntermediates[this.mIntermediate] = time;
        ++this.mIntermediate;
    }

    public void clearIntermediates() {
        this.mIntermediate = 0;
    }

    public String getString() {
        return Timer.getString(this.mStart, this.mEnd);
    }

    public String getStringIntermediate(int index) {
        return Timer.getString(index == 0 ? this.mStart : this.mIntermediates[index - 1], this.mIntermediates[index]);
    }

    public String getStringLastIntermediate() {
        return this.getStringIntermediate(this.mIntermediate - 1);
    }

    public long getTime() {
        return this.mEnd - this.mStart;
    }

    public long getIntermediateTime(int index) {
        if (index == 0) {
            return this.mIntermediates[index] - this.mStart;
        }
        return this.mIntermediates[index] - this.mIntermediates[index - 1];
    }

    public long getTotalIntermediateTime(int index) {
        return this.mIntermediates[index] - this.mStart;
    }

    private static String getString(long start, long end) {
        long delta = end - start;
        StringBuilder sb = new StringBuilder();
        sb.insert(0, Timer.fixSizeString(delta % 1000L, 3));
        if ((delta /= 1000L) == 0L) {
            return "0." + sb.toString();
        }
        sb.insert(0, String.valueOf(Timer.fixSizeString(delta % 60L, 2)) + ".");
        if ((delta /= 60L) == 0L) {
            return sb.toString();
        }
        sb.insert(0, String.valueOf(Timer.fixSizeString(delta % 60L, 2)) + ":");
        if ((delta /= 60L) == 0L) {
            return sb.toString();
        }
        sb.insert(0, String.valueOf(delta) + ":");
        return sb.toString();
    }

    private static String fixSizeString(long num, int size) {
        String zeros = "000";
        String str = String.valueOf(num);
        return String.valueOf("000".substring(0, size - str.length())) + str;
    }

    public static long tic() {
        return System.currentTimeMillis();
    }

    public static String toc(long tic) {
        long toc = System.currentTimeMillis();
        return Timer.getString(tic, toc);
    }

    public static long tocOut(long tic) {
        long toc = System.currentTimeMillis();
        System.out.print(Timer.getString(tic, toc));
        return toc;
    }

    public static long tocOutLn(long tic) {
        long toc = System.currentTimeMillis();
        System.out.println(Timer.getString(tic, toc));
        return toc;
    }
}

