/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.ops.matrix;

import ch.javasoft.math.NumberOperations;
import ch.javasoft.math.ops.DoubleOperations;
import ch.javasoft.smx.iface.ReadableDoubleMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.iface.ReadableVector;
import ch.javasoft.smx.iface.WritableMatrix;
import ch.javasoft.smx.iface.WritableVector;
import ch.javasoft.smx.impl.DefaultDoubleMatrix;
import ch.javasoft.smx.impl.DefaultDoubleVector;
import ch.javasoft.smx.ops.Add;
import ch.javasoft.smx.ops.MatrixOperations;
import ch.javasoft.smx.ops.Mul;
import ch.javasoft.smx.ops.Neg;
import ch.javasoft.smx.ops.ScalarOps;
import ch.javasoft.smx.ops.Sub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleMatrixOperations
implements MatrixOperations<Double> {
    private static DoubleMatrixOperations sInstance;

    public static DoubleMatrixOperations instance() {
        if (sInstance == null) {
            sInstance = new DoubleMatrixOperations();
        }
        return sInstance;
    }

    public ReadableMatrix<Double> createReadableMatrix(Double[][] values, boolean rowsInFirstDim) {
        return new DefaultDoubleMatrix(values, rowsInFirstDim);
    }

    @Override
    public ReadableMatrix<Double> createReadableMatrix(int rows, int cols) {
        return new DefaultDoubleMatrix(rows, cols);
    }

    public WritableMatrix<Double> createWritableMatrix(Double[][] values, boolean rowsInFirstDim) {
        return new DefaultDoubleMatrix(values, rowsInFirstDim);
    }

    @Override
    public WritableMatrix<Double> createWritableMatrix(int rows, int cols) {
        return new DefaultDoubleMatrix(rows, cols);
    }

    public ReadableVector<Double> createReadableVector(Double[] values, boolean columnVector) {
        return new DefaultDoubleVector(values, columnVector);
    }

    public WritableVector<Double> createWritableVector(Double[] values, boolean columnVector) {
        return new DefaultDoubleVector(values, columnVector);
    }

    @Override
    public ReadableVector<Double> createReadableVector(int size, boolean columnVector) {
        return new DefaultDoubleVector(size, columnVector);
    }

    @Override
    public WritableVector<Double> createWritableVector(int size, boolean columnVector) {
        return new DefaultDoubleVector(size, columnVector);
    }

    @Override
    public NumberOperations<Double> getNumberOperations() {
        return DoubleOperations.instance();
    }

    @Override
    public ReadableMatrix<Double> add(ReadableMatrix<Double> mxA, Double value) {
        if (mxA instanceof ReadableDoubleMatrix) {
            return ScalarOps.add((ReadableDoubleMatrix)mxA, value);
        }
        return ScalarOps.addGeneric(mxA, value);
    }

    @Override
    public ReadableMatrix<Double> add(ReadableMatrix<Double> mxA, ReadableMatrix<Double> mxB) {
        if (mxA instanceof ReadableDoubleMatrix && mxB instanceof ReadableDoubleMatrix) {
            return Add.add((ReadableDoubleMatrix)mxA, (ReadableDoubleMatrix)mxB);
        }
        return Add.addGeneric(mxA, mxB);
    }

    @Override
    public ReadableMatrix<Double> multiply(ReadableMatrix<Double> mxA, Double value) {
        if (mxA instanceof ReadableDoubleMatrix) {
            return ScalarOps.scale((ReadableDoubleMatrix)mxA, value);
        }
        return ScalarOps.scaleGeneric(mxA, value);
    }

    @Override
    public ReadableMatrix<Double> multiply(ReadableMatrix<Double> mxA, ReadableMatrix<Double> mxB) {
        if (mxA instanceof ReadableDoubleMatrix && mxB instanceof ReadableDoubleMatrix) {
            return Mul.multiply((ReadableDoubleMatrix)mxA, (ReadableDoubleMatrix)mxB);
        }
        return Mul.multiplyGeneric(mxA, mxB);
    }

    @Override
    public ReadableMatrix<Double> negate(ReadableMatrix<Double> matrix) {
        if (matrix instanceof ReadableDoubleMatrix) {
            return Neg.negate((ReadableDoubleMatrix)matrix);
        }
        return Neg.negateGeneric(matrix);
    }

    @Override
    public ReadableMatrix<Double> subtract(ReadableMatrix<Double> mxA, Double value) {
        return this.add(mxA, -value.doubleValue());
    }

    @Override
    public ReadableMatrix<Double> subtract(ReadableMatrix<Double> mxA, ReadableMatrix<Double> mxB) {
        if (mxA instanceof ReadableDoubleMatrix && mxB instanceof ReadableDoubleMatrix) {
            return Sub.subtract((ReadableDoubleMatrix)mxA, (ReadableDoubleMatrix)mxB);
        }
        return Sub.subtractGeneric(mxA, mxB);
    }

    @Override
    public ReadableMatrix<Double> transpose(ReadableMatrix<Double> matrix) {
        return matrix.transpose();
    }
}

