/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.ops;

import ch.javasoft.smx.iface.DoubleMatrix;
import ch.javasoft.smx.iface.IntMatrix;
import ch.javasoft.smx.iface.IntRationalMatrix;
import ch.javasoft.smx.iface.ReadableDoubleMatrix;
import ch.javasoft.smx.iface.ReadableIntRationalMatrix;
import ch.javasoft.smx.iface.WritableDoubleMatrix;
import ch.javasoft.smx.iface.WritableIntRationalMatrix;
import ch.javasoft.smx.impl.DefaultDoubleMatrix;
import ch.javasoft.smx.impl.DefaultIntMatrix;
import ch.javasoft.smx.impl.DefaultIntRationalMatrix;
import ch.javasoft.smx.ops.Transpose;
import ch.javasoft.util.numeric.IntegerUtil;

public class NullspaceRank {
    public static int rank(ReadableIntRationalMatrix src) {
        int rank = NullspaceRank.nullspaceRankInternal(src.toIntRationalMatrix(true), DefaultIntRationalMatrix.identity(src.getRowCount()));
        return rank;
    }

    public static int nullity(ReadableIntRationalMatrix src) {
        int rank = NullspaceRank.nullspaceRankInternal(src.toIntRationalMatrix(true), DefaultIntRationalMatrix.identity(src.getRowCount()));
        return src.getColumnCount() - rank;
    }

    public static IntMatrix nullspace(ReadableIntRationalMatrix src) {
        IntRationalMatrix srcT = Transpose.transpose(src);
        DefaultIntRationalMatrix dst = DefaultIntRationalMatrix.identity(srcT.getRowCount());
        int rank = NullspaceRank.nullspaceRankInternal(srcT, dst);
        int len = srcT.getRowCount();
        DefaultIntMatrix nullspace = new DefaultIntMatrix(len - rank, dst.getColumnCount());
        int row = rank;
        while (row < len) {
            int dividend;
            int sgn = 0;
            int scp = 1;
            int col = 0;
            while (col < len) {
                dividend = dst.getIntNumeratorAt(row, col);
                if (dividend != 0) {
                    int divisor = dst.getIntDenominatorAt(row, col);
                    scp /= IntegerUtil.gcd(scp, divisor);
                    scp *= divisor;
                    sgn += Integer.signum(dividend);
                }
                ++col;
            }
            if (Integer.signum(scp) != Integer.signum(sgn)) {
                scp = -scp;
            }
            col = 0;
            while (col < len) {
                int value;
                dividend = dst.getIntNumeratorAt(row, col);
                if (dividend == 0) {
                    value = 0;
                } else {
                    int divisor = dst.getIntDenominatorAt(row, col);
                    value = dividend * (scp / divisor);
                }
                nullspace.setValueAt(row - rank, col, value);
                ++col;
            }
            ++row;
        }
        return nullspace;
    }

    private static int nullspaceRankInternal(IntRationalMatrix src, WritableIntRationalMatrix dst) {
        int rows = src.getRowCount();
        int cols = src.getColumnCount();
        int[] rowMapping = new int[rows];
        int ii = 0;
        while (ii < rows) {
            rowMapping[ii] = ii;
            ++ii;
        }
        int col = 0;
        while (col < cols) {
            int rowPivot = col;
            if (rowPivot >= rows) {
                return rows;
            }
            int pivotDividend = src.getIntNumeratorAt(rowPivot, col);
            int row = rowPivot + 1;
            while (row < rows && pivotDividend == 0) {
                pivotDividend = src.getIntNumeratorAt(row, col);
                if (pivotDividend != 0) {
                    src.swapRows(rowPivot, row);
                    dst.swapRows(rowPivot, row);
                    int tmp = rowMapping[rowPivot];
                    rowMapping[rowPivot] = rowMapping[row];
                    rowMapping[row] = tmp;
                }
                ++row;
            }
            if (pivotDividend == 0) {
                return col;
            }
            int pivotDivisor = src.getIntDenominatorAt(rowPivot, col);
            src.multiplyRow(rowPivot, pivotDivisor, pivotDividend);
            dst.multiplyRow(rowPivot, pivotDivisor, pivotDividend);
            row = 0;
            while (row < rows) {
                int colPivotDividend;
                if (row != col && (colPivotDividend = src.getIntNumeratorAt(row, col)) != 0) {
                    int colPivotDivisor = src.getIntDenominatorAt(row, col);
                    src.addRowToOtherRow(rowPivot, -1, 1, row, colPivotDivisor, colPivotDividend);
                    dst.addRowToOtherRow(rowPivot, -1, 1, row, colPivotDivisor, colPivotDividend);
                }
                ++row;
            }
            ++col;
        }
        return cols;
    }

    public static int rank(ReadableDoubleMatrix src, double tolerance) {
        int rank = NullspaceRank.nullspaceRankInternal(src.toDoubleMatrix(true), DefaultDoubleMatrix.identity(src.getRowCount()), tolerance);
        return rank;
    }

    public static int nullity(ReadableDoubleMatrix src, double tolerance) {
        int rank = NullspaceRank.nullspaceRankInternal(src.toDoubleMatrix(true), DefaultDoubleMatrix.identity(src.getRowCount()), tolerance);
        return src.getColumnCount() - rank;
    }

    public static DoubleMatrix nullspace(ReadableDoubleMatrix src, double tolerance) {
        DoubleMatrix srcT = Transpose.transpose(src);
        DefaultDoubleMatrix dst = DefaultDoubleMatrix.identity(srcT.getRowCount());
        int rank = NullspaceRank.nullspaceRankInternal(srcT, dst, tolerance);
        int len = srcT.getRowCount();
        DefaultDoubleMatrix nullspace = new DefaultDoubleMatrix(len - rank, dst.getColumnCount());
        int row = rank;
        while (row < len) {
            double minValue = Double.MAX_VALUE;
            int sgn = 0;
            int col = 0;
            while (col < len) {
                double value = dst.getDoubleValueAt(row, col);
                if (value != 0.0) {
                    if (value < 0.0) {
                        --sgn;
                        if (minValue > -value) {
                            minValue = -value;
                        }
                    } else {
                        ++sgn;
                        if (minValue > value) {
                            minValue = value;
                        }
                    }
                }
                ++col;
            }
            double fac = (sgn < 0 ? -1.0 : 1.0) / minValue;
            int col2 = 0;
            while (col2 < len) {
                double value = fac * dst.getDoubleValueAt(row, col2);
                nullspace.setValueAt(row - rank, col2, value);
                ++col2;
            }
            ++row;
        }
        return nullspace;
    }

    private static int nullspaceRankInternal(DoubleMatrix src, WritableDoubleMatrix dst, double tolerance) {
        tolerance = Math.abs(tolerance);
        double negTolerance = -tolerance;
        int rows = src.getRowCount();
        int cols = src.getColumnCount();
        int[] rowMapping = new int[rows];
        int ii = 0;
        while (ii < rows) {
            rowMapping[ii] = ii;
            ++ii;
        }
        int col = 0;
        while (col < cols) {
            int rowPivot = col;
            if (rowPivot >= rows) {
                return rows;
            }
            double pivotValue = src.getDoubleValueAt(rowPivot, col);
            if (negTolerance < pivotValue && pivotValue < tolerance) {
                pivotValue = 0.0;
            }
            int row = rowPivot + 1;
            while (row < rows && pivotValue == 0.0) {
                pivotValue = src.getDoubleValueAt(rowPivot, col);
                if (negTolerance < pivotValue && pivotValue < tolerance) {
                    pivotValue = 0.0;
                }
                if (pivotValue == 0.0) {
                    src.swapRows(rowPivot, row);
                    dst.swapRows(rowPivot, row);
                    int tmp = rowMapping[rowPivot];
                    rowMapping[rowPivot] = rowMapping[row];
                    rowMapping[row] = tmp;
                }
                ++row;
            }
            if (pivotValue == 0.0) {
                return col;
            }
            double pivotMultiplyer = 1.0 / pivotValue;
            src.multiplyRow(rowPivot, pivotMultiplyer);
            dst.multiplyRow(rowPivot, pivotMultiplyer);
            int row2 = 0;
            while (row2 < rows) {
                if (row2 != col) {
                    double colPivotValue = src.getDoubleValueAt(row2, col);
                    if (negTolerance < colPivotValue && colPivotValue < tolerance) {
                        src.setValueAt(row2, col, 0.0);
                    } else {
                        double fac = -1.0 / colPivotValue;
                        src.addRowToOtherRow(rowPivot, 1.0, row2, fac);
                        dst.addRowToOtherRow(rowPivot, 1.0, row2, fac);
                    }
                }
                ++row2;
            }
            ++col;
        }
        return cols;
    }

    private NullspaceRank() {
    }
}

