/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.impl;

import ch.javasoft.smx.iface.DoubleMatrix;
import ch.javasoft.smx.impl.AbstractDoubleMatrix;

public class SubDoubleMatrix
extends AbstractDoubleMatrix {
    private static final int[] EMPTY_MAPPING = new int[0];
    private DoubleMatrix mBase;
    private int[] mRowMapping;
    private int[] mColMapping;

    public SubDoubleMatrix(DoubleMatrix base, boolean selectAllRows, boolean selectAllColumns) {
        this.mBase = base;
        if (selectAllRows) {
            this.selectAllRows();
        } else {
            this.mRowMapping = EMPTY_MAPPING;
        }
        if (selectAllColumns) {
            this.selectAllColumns();
        } else {
            this.mColMapping = EMPTY_MAPPING;
        }
    }

    public int selectRow(int rowInBaseMatrix) {
        this.mRowMapping = SubDoubleMatrix.addToArray(this.mRowMapping, rowInBaseMatrix);
        return this.mRowMapping.length - 1;
    }

    public int selectRows(int fromRowInBaseMatrix, int toRowInBaseMatrix) {
        int ret = -1;
        int row = fromRowInBaseMatrix;
        while (row < toRowInBaseMatrix) {
            int index = this.selectRow(row);
            if (row == fromRowInBaseMatrix) {
                ret = index;
            }
            ++row;
        }
        return ret;
    }

    public void selectAllRows() {
        this.mRowMapping = new int[this.mBase.getRowCount()];
        int ii = 0;
        while (ii < this.mRowMapping.length) {
            this.mRowMapping[ii] = ii;
            ++ii;
        }
    }

    public void switchSelectedRow(int row, int rowInBaseMatrix) {
        this.mRowMapping[row] = rowInBaseMatrix;
    }

    public int getMappedRow(int row) {
        return this.mRowMapping[row];
    }

    public int getUnmappedRow(int rowInBaseMatrix) {
        int ii = 0;
        while (ii < this.mRowMapping.length) {
            if (this.mRowMapping[ii] == rowInBaseMatrix) {
                return ii;
            }
            ++ii;
        }
        return -1;
    }

    public int[] getRowMapping() {
        return (int[])this.mRowMapping.clone();
    }

    public int selectColumn(int colInBaseMatrix) {
        this.mColMapping = SubDoubleMatrix.addToArray(this.mColMapping, colInBaseMatrix);
        return this.mColMapping.length - 1;
    }

    public int selectColumn(int fromColInBaseMatrix, int toColInBaseMatrix) {
        int ret = -1;
        int col = fromColInBaseMatrix;
        while (col < toColInBaseMatrix) {
            int index = this.selectColumn(col);
            if (col == fromColInBaseMatrix) {
                ret = index;
            }
            ++col;
        }
        return ret;
    }

    public void selectAllColumns() {
        this.mColMapping = new int[this.mBase.getColumnCount()];
        int ii = 0;
        while (ii < this.mColMapping.length) {
            this.mColMapping[ii] = ii;
            ++ii;
        }
    }

    public void switchSelectedColumn(int col, int colInBaseMatrix) {
        this.mColMapping[col] = colInBaseMatrix;
    }

    public void unselectRow(int row) {
        this.mRowMapping = SubDoubleMatrix.removeFromArray(this.mRowMapping, row);
    }

    public void unselectRows(int fromRow, int toRow) {
        int row = fromRow;
        while (row < toRow) {
            this.unselectRow(row);
            ++row;
        }
    }

    public void unselectAllRows() {
        this.mRowMapping = EMPTY_MAPPING;
    }

    public void unselectColumn(int col) {
        this.mColMapping = SubDoubleMatrix.removeFromArray(this.mColMapping, col);
    }

    public void unselectColumns(int fromCol, int toCol) {
        int col = fromCol;
        while (col < toCol) {
            this.unselectColumn(col);
            ++col;
        }
    }

    public void unselectAllColumns() {
        this.mColMapping = EMPTY_MAPPING;
    }

    public double getDoubleValueAt(int row, int col) {
        return this.mBase.getDoubleValueAt(this.mRowMapping[row], this.mColMapping[col]);
    }

    public void setValueAt(int row, int col, double value) {
        this.mBase.setValueAt(this.mRowMapping[row], this.mColMapping[col], value);
    }

    public void addRowToOtherRow(int srcRow, double srcFactor, int dstRow, double dstFactor) {
        this.mBase.addRowToOtherRow(this.mRowMapping[srcRow], srcFactor, this.mRowMapping[dstRow], dstFactor);
    }

    public void multiplyRow(int row, double factor) {
        this.mBase.multiplyRow(this.mRowMapping[row], factor);
    }

    public SubDoubleMatrix clone() {
        SubDoubleMatrix clone = new SubDoubleMatrix(this.mBase.clone(), false, false);
        clone.mRowMapping = (int[])this.mRowMapping.clone();
        clone.mColMapping = (int[])this.mColMapping.clone();
        return clone;
    }

    public SubDoubleMatrix newInstance(int rows, int cols) {
        return new SubDoubleMatrix(this.mBase.newInstance(rows, cols), true, true);
    }

    public SubDoubleMatrix newInstance(Double[][] data, boolean rowsInDim1) {
        return new SubDoubleMatrix(this.mBase.newInstance(data, rowsInDim1), true, true);
    }

    public int getRowCount() {
        return this.mRowMapping.length;
    }

    public int getColumnCount() {
        return this.mColMapping.length;
    }

    public void swapRows(int rowA, int rowB) {
        if (rowA == rowB) {
            return;
        }
        int tmp = this.mRowMapping[rowA];
        this.mRowMapping[rowA] = this.mRowMapping[rowB];
        this.mRowMapping[rowB] = tmp;
    }

    private static int[] addToArray(int[] array, int value) {
        int[] newArray = new int[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[newArray.length - 1] = value;
        return newArray;
    }

    private static int[] removeFromArray(int[] array, int pos) {
        int[] newArray = new int[array.length - 1];
        System.arraycopy(array, 0, newArray, 0, pos);
        System.arraycopy(array, pos + 1, newArray, pos, newArray.length - pos);
        return newArray;
    }

    public SubDoubleMatrix transpose() {
        SubDoubleMatrix tr = new SubDoubleMatrix(this.mBase.transpose(), false, false);
        tr.mColMapping = (int[])this.mRowMapping.clone();
        tr.mRowMapping = (int[])this.mColMapping.clone();
        return tr;
    }
}

