/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.smx.impl;

import ch.javasoft.math.BigFraction;
import ch.javasoft.smx.iface.BigIntegerRationalMatrix;
import ch.javasoft.smx.iface.ReadableVector;
import ch.javasoft.smx.iface.WritableVector;
import ch.javasoft.smx.impl.DefaultBigIntegerRationalMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBigIntegerVector
extends DefaultBigIntegerRationalMatrix
implements ReadableVector<BigFraction>,
WritableVector<BigFraction>,
BigIntegerRationalMatrix {
    private final boolean isColumnVector;

    public DefaultBigIntegerVector(int size, boolean isColumnVector) {
        super(isColumnVector ? size : 1, isColumnVector ? 1 : size);
        this.isColumnVector = isColumnVector;
    }

    public DefaultBigIntegerVector(BigFraction[] values, boolean isColumnVector) {
        super(new BigFraction[][]{values}, !isColumnVector);
        this.isColumnVector = isColumnVector;
    }

    @Override
    public DefaultBigIntegerVector clone() {
        int size = this.getSize();
        DefaultBigIntegerVector clone = new DefaultBigIntegerVector(size, this.isColumnVector);
        int i = 0;
        while (i < size) {
            clone.setValueAt(i, this.getNumberValueAt(i));
            ++i;
        }
        return clone;
    }

    @Override
    public DefaultBigIntegerVector transpose() {
        int size = this.getSize();
        DefaultBigIntegerVector clone = new DefaultBigIntegerVector(size, !this.isColumnVector);
        int i = 0;
        while (i < size) {
            clone.setValueAt(i, this.getNumberValueAt(i));
            ++i;
        }
        return clone;
    }

    @Override
    public BigFraction getNumberValueAt(int index) {
        return this.isColumnVector ? this.getNumberValueAt(index, 0) : this.getNumberValueAt(0, index);
    }

    @Override
    public ReadableVector<BigFraction> toReadableVector(boolean enforceNewInstance) {
        return enforceNewInstance ? this.clone() : this;
    }

    @Override
    public WritableVector<BigFraction> toWritableVector(boolean enforceNewInstance) {
        return enforceNewInstance ? this.clone() : this;
    }

    @Override
    public int getSize() {
        return this.getColumnCount() * this.getRowCount();
    }

    @Override
    public boolean isColumnVector() {
        return this.isColumnVector;
    }

    @Override
    public boolean isRowVector() {
        return !this.isColumnVector;
    }

    @Override
    public void setValueAt(int index, BigFraction value) {
        if (this.isColumnVector) {
            this.setValueAt(index, 0, value);
        } else {
            this.setValueAt(0, index, value);
        }
    }

    @Override
    public void swapValues(int indexA, int indexB) {
        BigFraction valA = this.getNumberValueAt(indexA);
        this.setValueAt(indexA, this.getNumberValueAt(indexB));
        this.setValueAt(indexB, valA);
    }
}

