/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.polco.adapter;

import ch.javasoft.metabolic.efm.config.Arithmetic;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;

public class Options {
    private final Map<String, String[]> opts = new LinkedHashMap<String, String[]>();

    public Options() {
        this.put("-kind", "text");
        this.put("-iq", "in.iq");
        this.put("-out", "text", "out.rays");
    }

    public void setArithmetic(Arithmetic core) {
        this.put("-arithmetic", core.getNiceName());
    }

    public void setArithmetic(Arithmetic core, Arithmetic post) {
        this.put("-arithmetic", core.getNiceName(), post.getNiceName());
    }

    public void setArithmetic(Arithmetic core, Arithmetic post, Arithmetic pre) {
        this.put("-arithmetic", core.getNiceName(), post.getNiceName(), pre.getNiceName());
    }

    public void setZero(double zeroCore) {
        this.put("-zero", String.valueOf(Math.abs(zeroCore)));
    }

    public void setZero(double zeroCore, double zeroPost) {
        this.put("-zero", String.valueOf(Math.abs(zeroCore)), String.valueOf(Math.abs(zeroPost)));
    }

    public void setZero(double zeroCore, double zeroPost, double zeroPre) {
        this.put("-zero", String.valueOf(Math.abs(zeroCore)), String.valueOf(Math.abs(zeroPost)), String.valueOf(Math.abs(zeroPre)));
    }

    public void setMaxThreads(int maxThreads) {
        this.put("-maxthreads", String.valueOf(maxThreads));
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.put(algorithm);
    }

    public void setModel(Model model) {
        this.put(model);
    }

    public void setAdjacencyMethod(String adj) {
        this.put("-adj", adj);
    }

    public void setSortInput(String sorting) {
        this.put("sortinput", sorting);
    }

    public void setSortInitial(String sorting) {
        this.put("sortinput", sorting);
    }

    public void setCompression(Compression compression) {
        this.put(compression);
    }

    public void setMemory(Memory memory) {
        this.put(memory);
    }

    public void setTmpDir(File tmpDir) {
        this.put("-tmpdir", tmpDir.getAbsolutePath());
    }

    public void setLoglevel(Level level) {
        this.put("-level", level.getName());
    }

    public void setLogFormat(LogFormat format) {
        this.put(format);
    }

    public void setLogFile(File file) {
        if (file == null) {
            this.opts.remove("-log");
        } else {
            this.put("-log", "file", file.getAbsolutePath());
        }
    }

    private void put(GenericOption option) {
        this.put(option.getOptionName(), option.getOptionValues());
    }

    private void put(String optionName, String ... optionValues) {
        this.opts.put(optionName, optionValues);
    }

    public Options merge(Options other) {
        Options merge = new Options();
        merge.opts.putAll(other.opts);
        merge.opts.putAll(this.opts);
        return merge;
    }

    protected String[] toArgs() {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : this.opts.keySet()) {
            list.add(key);
            list.addAll(Arrays.asList(this.opts.get(key)));
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Algorithm implements GenericOption
    {
        standard,
        borndie;


        @Override
        public String getOptionName() {
            return "-algorithm";
        }

        @Override
        public String[] getOptionValues() {
            return new String[]{this.name()};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Compression implements GenericOption
    {
        standard{

            public String[] getOptionValues() {
                return new String[]{"default"};
            }
        }
        ,
        off;


        @Override
        public String getOptionName() {
            return "-compression";
        }

        @Override
        public String[] getOptionValues() {
            return new String[]{this.name()};
        }
    }

    private static interface GenericOption {
        public String getOptionName();

        public String[] getOptionValues();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LogFormat implements GenericOption
    {
        standard,
        plain;


        @Override
        public String getOptionName() {
            return "-format";
        }

        @Override
        public String[] getOptionValues() {
            return new String[]{this.name()};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Memory implements GenericOption
    {
        in_core,
        out_core,
        sort_out_core;


        @Override
        public String getOptionName() {
            return "-memory";
        }

        @Override
        public String[] getOptionValues() {
            return new String[]{this.name().replace('_', '-')};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Model implements GenericOption
    {
        nullspace,
        canonical;


        @Override
        public String getOptionName() {
            return "-model";
        }

        @Override
        public String[] getOptionValues() {
            return new String[]{this.name()};
        }
    }
}

