/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.impl;

import ch.javasoft.math.BigFraction;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.MetabolicNetworkVisitor;
import ch.javasoft.metabolic.Metabolite;
import ch.javasoft.metabolic.MetaboliteRatio;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.ReactionConstraints;
import ch.javasoft.metabolic.impl.AbstractMetabolicNetwork;
import ch.javasoft.metabolic.impl.AbstractReaction;
import ch.javasoft.metabolic.impl.DefaultMetabolicNetwork;
import ch.javasoft.metabolic.impl.DefaultMetabolite;
import ch.javasoft.metabolic.impl.DefaultReactionConstraints;
import ch.javasoft.metabolic.util.StoichiometricMatrices;
import ch.javasoft.smx.iface.BigIntegerRationalMatrix;
import ch.javasoft.smx.iface.ReadableBigIntegerRationalMatrix;
import ch.javasoft.smx.impl.DefaultBigIntegerRationalMatrix;
import ch.javasoft.util.IntArray;
import ch.javasoft.util.genarr.ArrayIterable;
import ch.javasoft.util.genarr.GenericArray;
import ch.javasoft.util.genarr.GenericFixSizeArray;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FractionNumberStoichMetabolicNetwork
extends AbstractMetabolicNetwork {
    private final String[] mMetaboliteNames;
    private final String[] mReactionNames;
    private final boolean[] mReversible;
    private final BigIntegerRationalMatrix mStoich;
    private Map<String, Integer> tMetaIndexByName = null;
    private Map<String, Integer> tReacIndexByName = null;
    private GenericArray<Metabolite> tMetabolies = null;
    private GenericArray<Reaction> tReactions = null;

    public FractionNumberStoichMetabolicNetwork(BigIntegerRationalMatrix stoich, boolean[] reversible) {
        this(DefaultMetabolicNetwork.metaboliteNames(stoich.getRowCount()), DefaultMetabolicNetwork.reactionNames(stoich.getColumnCount()), stoich, reversible);
    }

    public FractionNumberStoichMetabolicNetwork(String[] metaboliteNames, String[] reactionNames, BigIntegerRationalMatrix stoich, boolean[] reversible) {
        this.mMetaboliteNames = metaboliteNames;
        this.mReactionNames = reactionNames;
        this.mReversible = reversible;
        this.mStoich = stoich;
    }

    protected Map<String, Integer> getMetaIndicesByName() {
        if (this.tMetaIndexByName == null) {
            this.tMetaIndexByName = new HashMap<String, Integer>();
            int i = 0;
            while (i < this.mMetaboliteNames.length) {
                this.tMetaIndexByName.put(this.mMetaboliteNames[i], i);
                ++i;
            }
        }
        return this.tMetaIndexByName;
    }

    protected Map<String, Integer> getReacIndicesByName() {
        if (this.tReacIndexByName == null) {
            this.tReacIndexByName = new HashMap<String, Integer>();
            int i = 0;
            while (i < this.mReactionNames.length) {
                this.tReacIndexByName.put(this.mReactionNames[i], i);
                ++i;
            }
        }
        return this.tReacIndexByName;
    }

    @Override
    public Metabolite getMetabolite(String name) {
        int index = this.getMetaboliteIndex(name);
        if (index < 0) {
            throw new IllegalArgumentException("no such metabolite: " + name);
        }
        return this.getMetabolites().get(index);
    }

    @Override
    public int getMetaboliteIndex(String name) {
        Integer index = this.getMetaIndicesByName().get(name);
        return index == null ? -1 : index;
    }

    @Override
    public ArrayIterable<? extends Metabolite> getMetabolites() {
        if (this.tMetabolies == null) {
            this.tMetabolies = new GenericFixSizeArray<Metabolite>(this.mMetaboliteNames.length);
            int i = 0;
            while (i < this.mMetaboliteNames.length) {
                this.tMetabolies.set(i, new DefaultMetabolite(this.mMetaboliteNames[i]));
                ++i;
            }
        }
        return this.tMetabolies;
    }

    @Override
    public Reaction getReaction(String name) {
        int index = this.getReactionIndex(name);
        if (index < 0) {
            throw new IllegalArgumentException("no such reaction: " + name);
        }
        return this.getReactions().get(index);
    }

    @Override
    public int getReactionIndex(String name) {
        Integer index = this.getReacIndicesByName().get(name);
        return index == null ? -1 : index;
    }

    @Override
    public ArrayIterable<? extends Reaction> getReactions() {
        if (this.tReactions == null) {
            this.tReactions = new GenericFixSizeArray<Reaction>(this.mReactionNames.length);
            int i = 0;
            while (i < this.mReactionNames.length) {
                this.tReactions.set(i, new BigIntegerReaction(i));
                ++i;
            }
        }
        return this.tReactions;
    }

    public ReadableBigIntegerRationalMatrix<?> getStoichiometricMatrix() {
        return this.mStoich;
    }

    public static ReadableBigIntegerRationalMatrix getStoich(MetabolicNetwork net) {
        if (net instanceof FractionNumberStoichMetabolicNetwork) {
            return ((FractionNumberStoichMetabolicNetwork)net).getStoichiometricMatrix();
        }
        return new DefaultBigIntegerRationalMatrix(StoichiometricMatrices.createStoichiometricMatrix(net), true, true);
    }

    public static abstract class AbstractBigIntegerMetaboliteRatio
    implements MetaboliteRatio {
        protected final int mReacIndex;
        protected final int mMetaIndex;

        public AbstractBigIntegerMetaboliteRatio(int reacIndex, int metaIndex) {
            this.mReacIndex = reacIndex;
            this.mMetaIndex = metaIndex;
        }

        protected abstract ReadableBigIntegerRationalMatrix getStoich();

        public void accept(MetabolicNetworkVisitor visitor) {
            visitor.visitMetaboliteRatio(this);
        }

        public double getRatio() {
            return this.getStoich().getDoubleValueAt(this.mMetaIndex, this.mReacIndex);
        }

        public BigFraction getNumberRatio() {
            return this.getStoich().getBigFractionValueAt(this.mMetaIndex, this.mReacIndex);
        }

        public boolean isEduct() {
            return this.getStoich().getSignumAt(this.mMetaIndex, this.mReacIndex) < 0;
        }

        public boolean isIntegerRatio() {
            return this.getNumberRatio().reduce().getDenominator().compareTo(BigInteger.ONE) == 0;
        }

        public String toString() {
            return this.toString(this.getNumberRatio(), this.getMetabolite());
        }

        public String toStringAbs() {
            return this.toString(this.getNumberRatio().abs(), this.getMetabolite());
        }

        private String toString(BigFraction ratio, Metabolite meta) {
            return ratio.isOne() ? meta.toString() : ratio + " " + meta;
        }

        public MetaboliteRatio invert() {
            return new MetaboliteRatio(){
                final BigFraction ratio;
                {
                    this.ratio = AbstractBigIntegerMetaboliteRatio.this.getNumberRatio().negate();
                }

                public Metabolite getMetabolite() {
                    return AbstractBigIntegerMetaboliteRatio.this.getMetabolite();
                }

                public Number getNumberRatio() {
                    return this.ratio;
                }

                public double getRatio() {
                    return this.ratio.doubleValue();
                }

                public MetaboliteRatio invert() {
                    return AbstractBigIntegerMetaboliteRatio.this;
                }

                public boolean isEduct() {
                    return !AbstractBigIntegerMetaboliteRatio.this.isEduct();
                }

                public boolean isIntegerRatio() {
                    return AbstractBigIntegerMetaboliteRatio.this.isIntegerRatio();
                }

                public String toStringAbs() {
                    return AbstractBigIntegerMetaboliteRatio.this.toStringAbs();
                }

                public void accept(MetabolicNetworkVisitor visitor) {
                    visitor.visitMetaboliteRatio(this);
                }
            };
        }

        public int hashCode() {
            return this.getMetabolite().hashCode() ^ this.getNumberRatio().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj.getClass() == this.getClass()) {
                AbstractBigIntegerMetaboliteRatio ratio = (AbstractBigIntegerMetaboliteRatio)obj;
                return this.getMetabolite().equals(ratio.getMetabolite()) && this.getNumberRatio().equalsNumerically(ratio.getNumberRatio());
            }
            return false;
        }
    }

    private class BigIntegerMetaboliteRatio
    extends AbstractBigIntegerMetaboliteRatio {
        public BigIntegerMetaboliteRatio(int reacIndex, int metaIndex) {
            super(reacIndex, metaIndex);
        }

        public Metabolite getMetabolite() {
            return FractionNumberStoichMetabolicNetwork.this.getMetabolites().get(this.mMetaIndex);
        }

        protected ReadableBigIntegerRationalMatrix getStoich() {
            return FractionNumberStoichMetabolicNetwork.this.mStoich;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BigIntegerReaction
    extends AbstractReaction {
        private final int mReactionIndex;
        private final int[] mMetaIndices;

        public BigIntegerReaction(int reactionIndex) {
            IntArray metaIndices = new IntArray();
            int meta = 0;
            while (meta < FractionNumberStoichMetabolicNetwork.this.mMetaboliteNames.length) {
                if (FractionNumberStoichMetabolicNetwork.this.mStoich.getSignumAt(meta, reactionIndex) != 0) {
                    metaIndices.add(meta);
                }
                ++meta;
            }
            this.mReactionIndex = reactionIndex;
            this.mMetaIndices = metaIndices.toArray();
        }

        @Override
        public ReactionConstraints getConstraints() {
            return FractionNumberStoichMetabolicNetwork.this.mReversible[this.mReactionIndex] ? DefaultReactionConstraints.DEFAULT_REVERSIBLE : DefaultReactionConstraints.DEFAULT_IRREVERSIBLE;
        }

        @Override
        public ArrayIterable<? extends MetaboliteRatio> getMetaboliteRatios() {
            GenericFixSizeArray<BigIntegerMetaboliteRatio> ratios = new GenericFixSizeArray<BigIntegerMetaboliteRatio>(this.mMetaIndices.length);
            int i = 0;
            while (i < this.mMetaIndices.length) {
                int meta = this.mMetaIndices[i];
                ratios.set(i, new BigIntegerMetaboliteRatio(this.mReactionIndex, meta));
                ++i;
            }
            return ratios;
        }

        @Override
        public String getName() {
            return FractionNumberStoichMetabolicNetwork.this.mReactionNames[this.mReactionIndex];
        }
    }
}

