/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.generate;

import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.Metabolite;
import ch.javasoft.metabolic.MetaboliteRatio;
import ch.javasoft.metabolic.Reaction;
import ch.javasoft.metabolic.compartment.CompartmentMetabolicNetwork;
import ch.javasoft.metabolic.compartment.CompartmentMetabolite;
import ch.javasoft.metabolic.generate.LogPkg;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Logger;

public class SbmlGenerator {
    private static final Logger LOG = LogPkg.LOGGER;
    private final MetabolicNetwork mNet;
    private final String mModelName;
    private final CompartmentHandler mCompartmentHandler;
    public static final CompartmentHandler DEFAULT_COMPARTMENT_HANDLER = new DefaultCompartmentHandler();
    private static final NumberFormat NUMBER_FORMAT = new DecimalFormat("0.0###################");

    public SbmlGenerator(MetabolicNetwork net, String modelName) {
        this(net, modelName, net instanceof CompartmentMetabolicNetwork ? new CompartmentMetabolicNetworkHandler((CompartmentMetabolicNetwork)net) : DEFAULT_COMPARTMENT_HANDLER);
    }

    public SbmlGenerator(MetabolicNetwork net, String modelName, CompartmentHandler cmpHandler) {
        this.mNet = net;
        this.mModelName = modelName;
        this.mCompartmentHandler = cmpHandler;
    }

    public void write(OutputStream out) {
        this.write(new OutputStreamWriter(out));
    }

    public void write(File file) throws IOException {
        this.write(new FileWriter(file));
    }

    public void write(Writer writer) {
        this.write(writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer));
    }

    public void write(PrintWriter printWriter) {
        LOG.fine("writing sbml ...");
        TokWriter writer = new TokWriter(printWriter);
        SbmlGenerator.writeEncodingNode(writer);
        SbmlGenerator.openRootNode(writer);
        SbmlGenerator.openNode(writer, "model", "name", this.mModelName);
        SbmlGenerator.openNode(writer, "listOfCompartments");
        this.writeCompartments(writer);
        SbmlGenerator.closeNode(writer, "listOfCompartments");
        SbmlGenerator.openNode(writer, "listOfSpecies");
        this.writeMetabolites(writer);
        SbmlGenerator.closeNode(writer, "listOfSpecies");
        SbmlGenerator.openNode(writer, "listOfReactions");
        this.writeReactions(writer);
        SbmlGenerator.closeNode(writer, "listOfReactions");
        SbmlGenerator.closeNode(writer, "model");
        SbmlGenerator.closeRootNode(writer);
        printWriter.flush();
        LOG.fine("writing sbml complete.");
    }

    private void writeCompartments(TokWriter writer) {
        for (String cmp : this.mCompartmentHandler.compartments()) {
            SbmlGenerator.openCloseNode(writer, "compartment", new String[]{"id", "name", "size"}, new String[]{SbmlGenerator.encodeId(cmp), cmp, "0.0"});
        }
    }

    private void writeMetabolites(TokWriter writer) {
        HashSet<String> metaNames = new HashSet<String>();
        HashSet<String> xtMetaNames = new HashSet<String>();
        for (Metabolite metabolite : this.mNet.getMetabolites()) {
            if (this.mCompartmentHandler.exportMetabolite(metabolite)) {
                String metaName = metabolite.getName();
                String cmp = this.mCompartmentHandler.compartmentForMetabolite(metabolite);
                SbmlGenerator.openCloseNode(writer, "species", new String[]{"id", "name", "compartment", "initialConcentration"}, new String[]{SbmlGenerator.encodeId(metaName), metaName, SbmlGenerator.encodeId(cmp), "1.0"});
                if (metaNames.contains(metaName)) {
                    throw new RuntimeException("duplicate metabolite: " + metaName);
                }
                metaNames.add(metaName);
                continue;
            }
            LOG.info("... ommitted metabolite: " + metabolite);
        }
        for (Reaction reaction : this.mNet.getReactions()) {
            CompartmentMetabolite xtMeta;
            if (!reaction.isExternal() || !this.mCompartmentHandler.exportReaction(reaction) || !this.mCompartmentHandler.exportMetabolite(xtMeta = this.mCompartmentHandler.externalReactionMetabolite(reaction))) continue;
            String metaName = xtMeta.getName();
            String cmp = xtMeta.getCompartment();
            if (metaNames.contains(metaName)) {
                throw new RuntimeException("duplicate metabolite: " + metaName);
            }
            if (xtMetaNames.contains(metaName)) continue;
            xtMetaNames.add(metaName);
            SbmlGenerator.openCloseNode(writer, "species", new String[]{"id", "name", "compartment", "initialConcentration"}, new String[]{SbmlGenerator.encodeId(metaName), metaName, SbmlGenerator.encodeId(cmp), "1.0"});
        }
    }

    private void writeReactions(TokWriter writer) {
        for (Reaction reaction : this.mNet.getReactions()) {
            if (this.mCompartmentHandler.exportReaction(reaction)) {
                String reacId = reaction.getName();
                String reacName = reaction.getFullName();
                SbmlGenerator.openNode(writer, "reaction", new String[]{"id", "name", "reversible"}, new String[]{SbmlGenerator.encodeId(reacId), reacName, Boolean.toString(reaction.getConstraints().isReversible())});
                SbmlGenerator.openNode(writer, "listOfReactants");
                if (reaction.isUptake()) {
                    CompartmentMetabolite compartmentMetabolite = this.mCompartmentHandler.externalReactionMetabolite(reaction);
                    SbmlGenerator.openCloseNode(writer, "speciesReference", new String[]{"species", "stoichiometry"}, new String[]{SbmlGenerator.encodeId(compartmentMetabolite.getName()), NUMBER_FORMAT.format(1.0)});
                } else {
                    for (MetaboliteRatio metaboliteRatio : reaction.getEductRatios()) {
                        SbmlGenerator.openCloseNode(writer, "speciesReference", new String[]{"species", "stoichiometry"}, new String[]{SbmlGenerator.encodeId(metaboliteRatio.getMetabolite().getName()), NUMBER_FORMAT.format(-metaboliteRatio.getRatio())});
                    }
                }
                SbmlGenerator.closeNode(writer, "listOfReactants");
                SbmlGenerator.openNode(writer, "listOfProducts");
                if (reaction.isExtract()) {
                    CompartmentMetabolite compartmentMetabolite = this.mCompartmentHandler.externalReactionMetabolite(reaction);
                    SbmlGenerator.openCloseNode(writer, "speciesReference", new String[]{"species", "stoichiometry"}, new String[]{SbmlGenerator.encodeId(compartmentMetabolite.getName()), NUMBER_FORMAT.format(1.0)});
                } else {
                    for (MetaboliteRatio metaboliteRatio : reaction.getProductRatios()) {
                        SbmlGenerator.openCloseNode(writer, "speciesReference", new String[]{"species", "stoichiometry"}, new String[]{SbmlGenerator.encodeId(metaboliteRatio.getMetabolite().getName()), NUMBER_FORMAT.format(metaboliteRatio.getRatio())});
                    }
                }
                SbmlGenerator.closeNode(writer, "listOfProducts");
                SbmlGenerator.closeNode(writer, "reaction");
                continue;
            }
            LOG.info("... ommitted reaction: " + reaction.getName());
        }
    }

    private static void writeEncodingNode(TokWriter writer) {
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }

    private static void openRootNode(TokWriter writer) {
        SbmlGenerator.openNode(writer, "sbml", new String[]{"xmlns", "level", "version"}, new String[]{"http://www.sbml.org/sbml/level2", "2", "1"});
    }

    private static void closeRootNode(TokWriter writer) {
        SbmlGenerator.closeNode(writer, "sbml");
    }

    private static void openNode(TokWriter writer, String nodeName) {
        SbmlGenerator.openNode(writer, nodeName, null, null);
    }

    private static void openNode(TokWriter writer, String nodeName, String attributeName, String attributeValue) {
        SbmlGenerator.openNode(writer, nodeName, new String[]{attributeName}, new String[]{attributeValue});
    }

    private static void openNode(TokWriter writer, String nodeName, String[] attributeNames, String[] attributeValues) {
        SbmlGenerator.openNode(writer, nodeName, attributeNames, attributeValues, false);
    }

    private static void openCloseNode(TokWriter writer, String nodeName, String[] attributeNames, String[] attributeValues) {
        SbmlGenerator.openNode(writer, nodeName, attributeNames, attributeValues, true);
    }

    private static void openNode(TokWriter writer, String nodeName, String[] attributeNames, String[] attributeValues, boolean alsoClose) {
        writer.print("<" + nodeName);
        if (attributeNames != null && attributeNames.length > 0) {
            int ii = 0;
            while (ii < attributeNames.length) {
                writer.print(" ");
                writer.print(String.valueOf(attributeNames[ii]) + "=\"" + attributeValues[ii] + "\"");
                ++ii;
            }
        }
        if (alsoClose) {
            writer.println("/>");
        } else {
            writer.println(">");
            writer.incIndention();
        }
    }

    private static void closeNode(TokWriter writer, String nodeName) {
        writer.decIndention();
        writer.println("</" + nodeName + ">");
    }

    private static String encodeId(String id) {
        StringBuilder sb = new StringBuilder(id.length());
        int ii = 0;
        while (ii < id.length()) {
            char ch = id.charAt(ii);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_' || ch >= '0' && ch <= '9') {
                if (ii == 0 && ch >= '0' && ch <= '9') {
                    sb.append('_');
                }
                sb.append(ch);
            } else {
                sb.append('_');
            }
            ++ii;
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CompartmentHandler {
        public Iterable<String> compartments();

        public String compartmentForMetabolite(Metabolite var1);

        public CompartmentMetabolite externalReactionMetabolite(Reaction var1);

        public boolean exportMetabolite(Metabolite var1);

        public boolean exportReaction(Reaction var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CompartmentMetabolicNetworkHandler
    implements CompartmentHandler {
        private final CompartmentMetabolicNetwork net;

        public CompartmentMetabolicNetworkHandler(CompartmentMetabolicNetwork cmpNet) {
            this.net = cmpNet;
        }

        @Override
        public Iterable<String> compartments() {
            return this.net.getCompartmentNames();
        }

        @Override
        public String compartmentForMetabolite(Metabolite meta) {
            return this.net.getMetabolite(meta.getName()).getCompartment();
        }

        @Override
        public CompartmentMetabolite externalReactionMetabolite(Reaction reac) {
            throw new RuntimeException("please specify an individual compartment handler");
        }

        @Override
        public boolean exportMetabolite(Metabolite meta) {
            return true;
        }

        @Override
        public boolean exportReaction(Reaction reac) {
            return !reac.isExternal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultCompartmentHandler
    implements CompartmentHandler {
        public static final String DEFAULT_COMPARTMENT = "default";
        public static final String EXTERNAL_COMPARTMENT = "external";
        public static final String EXTERNAL_METABOLITE_PRE = "external_";
        protected final String mDefaultCompartmentName;
        protected final String mExternalCompartmentName;
        private final Iterable<String> mCompartments;

        public DefaultCompartmentHandler() {
            this(DEFAULT_COMPARTMENT, EXTERNAL_COMPARTMENT);
        }

        public DefaultCompartmentHandler(String defaultCompartmentName, String externalCompartmentName) {
            this.mDefaultCompartmentName = defaultCompartmentName;
            this.mExternalCompartmentName = externalCompartmentName;
            this.mCompartments = Arrays.asList(defaultCompartmentName, externalCompartmentName);
        }

        @Override
        public Iterable<String> compartments() {
            return this.mCompartments;
        }

        @Override
        public String compartmentForMetabolite(Metabolite meta) {
            return this.mDefaultCompartmentName;
        }

        @Override
        public CompartmentMetabolite externalReactionMetabolite(Reaction reac) {
            String name = reac.isUptake() && reac.getProductRatios().length() == 1 ? reac.getProductRatios().get(0).getMetabolite().getName() : (reac.isExtract() && reac.getEductRatios().length() == 1 ? reac.getEductRatios().get(0).getMetabolite().getName() : reac.getFullName());
            return this.externalReactionMetabolite(name);
        }

        protected CompartmentMetabolite externalReactionMetabolite(String name) {
            return new CompartmentMetabolite(EXTERNAL_METABOLITE_PRE + name, this.mExternalCompartmentName);
        }

        @Override
        public boolean exportMetabolite(Metabolite meta) {
            return true;
        }

        @Override
        public boolean exportReaction(Reaction reac) {
            return true;
        }
    }

    private static class TokWriter {
        public final PrintWriter pw;
        private int indent = 0;
        private boolean afterLine = true;

        public TokWriter(PrintWriter writer) {
            this.pw = writer;
        }

        public void println(String str) {
            if (this.afterLine) {
                this.pw.print(this.indention());
            }
            this.pw.println(str);
            this.afterLine = true;
        }

        public void print(String str) {
            if (this.afterLine) {
                this.pw.print(this.indention());
                this.afterLine = false;
            }
            this.pw.print(str);
        }

        public String indention() {
            StringBuilder sb = new StringBuilder(this.indent);
            int ii = 0;
            while (ii < this.indent) {
                sb.append('\t');
                ++ii;
            }
            return sb.toString();
        }

        public void incIndention() {
            ++this.indent;
        }

        public void decIndention() {
            --this.indent;
        }
    }
}

