/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.tree.concurrent;

import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.concurrent.ConcurrentToken;
import ch.javasoft.metabolic.efm.concurrent.ThreadFinalizer;
import ch.javasoft.metabolic.efm.model.AdjEnumModel;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.tree.AdjacencyFilter;
import ch.javasoft.metabolic.efm.tree.AdjacencyPrecondition;
import ch.javasoft.metabolic.efm.tree.BitPatternTree;
import ch.javasoft.metabolic.efm.tree.impl.DefaultTreePairTraverser;
import ch.javasoft.metabolic.efm.tree.impl.SubtreePairTraverser;
import ch.javasoft.util.ExceptionUtil;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentSubtreePairTraverser<T extends ConcurrentToken>
extends DefaultTreePairTraverser<T> {
    private static final int MAX_LEVEL_DEPTH = 6;
    private final ThreadFinalizer threadFinalizer;

    public ConcurrentSubtreePairTraverser(EfmModel efmModel, AdjacencyPrecondition<T> precondition, AdjacencyFilter<T> filter, final AdjEnumModel itModel, final BitPatternTree posTree, final BitPatternTree negTree) {
        super(efmModel, precondition, filter);
        this.threadFinalizer = new ThreadFinalizer(){

            public void finalizeCurrentThread() throws Exception {
                itModel.closeForThread();
                posTree.closeForCurrentThread();
                negTree.closeForCurrentThread();
            }
        };
    }

    @Override
    public <Col extends Column, N extends Number> void traverse(ColumnHome<N, Col> columnHome, AdjEnumModel<Col> iterationModel, T token, BitPatternTree posTree, BitPatternTree negTree) throws IOException {
        AtomicInteger jobs = new AtomicInteger(4096);
        int threads = token.drainPermits();
        int i = 0;
        while (i < threads) {
            Callable<Void> callable = this.createCallable(columnHome, iterationModel, token, posTree, negTree, 6, jobs);
            Thread thread = token.createChildThread(callable, this.threadFinalizer);
            thread.start();
            ++i;
        }
        Callable<Void> callable = this.createCallable(columnHome, iterationModel, token, posTree, negTree, 6, jobs);
        try {
            callable.call();
            token.waitForChildThreads();
        }
        catch (Exception e) {
            throw ExceptionUtil.toRuntimeExceptionOr(IOException.class, e);
        }
    }

    private <Col extends Column, N extends Number> Callable<Void> createCallable(final ColumnHome<N, Col> columnHome, final AdjEnumModel<Col> iterationModel, final T token, final BitPatternTree posTree, final BitPatternTree negTree, final int maxLevelDepth, final AtomicInteger jobs) throws IOException {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                int job = jobs.decrementAndGet();
                while (job >= 0) {
                    SubtreePairTraverser<ConcurrentToken> st = new SubtreePairTraverser<ConcurrentToken>(maxLevelDepth, job, ConcurrentSubtreePairTraverser.this);
                    st.traverse(columnHome, iterationModel, token, posTree, negTree);
                    job = jobs.decrementAndGet();
                }
                return null;
            }
        };
    }
}

