/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.dist.impl.file;

import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.dist.DistributedAdjEnum;
import ch.javasoft.metabolic.efm.dist.impl.DistServer;
import ch.javasoft.metabolic.efm.dist.impl.DistributableAdjEnum;
import ch.javasoft.metabolic.efm.dist.impl.file.FileBasedDistJobController;
import ch.javasoft.metabolic.efm.model.AdjEnumModel;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.model.ModelPersister;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBasedDistributableAdjEnum
implements DistributableAdjEnum {
    public static final String NAME = "distributable-file";

    @Override
    public String name() {
        return NAME;
    }

    protected File getConfigFile(File dir) {
        return new File(dir, "config.efm");
    }

    protected File getEfmModelFile(File dir) {
        return new File(dir, "efm-model.efm");
    }

    protected File getStoichFile(File dir) {
        return new File(dir, "stoich.bin");
    }

    protected File getAdjModelFile(File dir) {
        return new File(dir, String.valueOf(this.name()) + ".properties");
    }

    @Override
    public <Col extends Column, N extends Number> FileBasedDistJobController initialize(ColumnHome<N, Col> columnHome, Config config, EfmModel efmModel, AdjEnumModel<Col> adjModel, int nodeCount) throws IOException {
        try {
            File tmpDir = config.getTempDir().getPersonalizedDir();
            DistributedAdjEnum delegate = config.getAdjMethodFactory().createDistributedAdjEnumFromConfig();
            delegate.execCentralized(columnHome, config, efmModel, adjModel);
            ModelPersister persister = delegate.getModelPersister();
            config.writeTo(this.getConfigFile(tmpDir));
            persister.writeStoich(efmModel.getStoichRational(), this.getStoichFile(tmpDir));
            persister.writeEfmModel(columnHome, efmModel, this.getEfmModelFile(tmpDir));
            persister.writeAdjEnumModel(columnHome, adjModel, this.getAdjModelFile(tmpDir));
            DistServer<Col> server = new DistServer<Col>(columnHome, config, adjModel, nodeCount);
            String configFileName = this.getConfigFile(tmpDir).getName();
            String stoichFileName = this.getStoichFile(tmpDir).getName();
            String efmModelFileName = this.getEfmModelFile(tmpDir).getName();
            String adjModelFileName = this.getAdjModelFile(tmpDir).getName();
            String masterHostName = FileBasedDistributableAdjEnum.getHostName();
            int masterPort = server.getPort();
            server.start();
            return new FileBasedDistJobController(config, server, configFileName, stoichFileName, efmModelFileName, adjModelFileName, masterHostName, masterPort);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static final String getHostName() throws IOException {
        return InetAddress.getLocalHost().getHostName();
    }
}

