/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.concurrent;

import ch.javasoft.metabolic.efm.concurrent.ConcurrentToken;
import ch.javasoft.metabolic.efm.concurrent.ThreadFinalizer;
import ch.javasoft.metabolic.efm.progress.ProgressAggregator;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConcurrentToken
implements ConcurrentToken {
    private static final Object DUMMY = new Object();
    private final ProgressAggregator progressAggregator;
    private final AtomicReference<Exception> exception = new AtomicReference();
    private final Map<Thread, Object> childThreads = new ConcurrentHashMap<Thread, Object>();

    protected AbstractConcurrentToken() {
        this.progressAggregator = null;
    }

    protected AbstractConcurrentToken(ProgressAggregator progressAggregator) throws IOException {
        this.progressAggregator = progressAggregator;
    }

    @Override
    public Thread createChildThread(final Callable<Void> callable, final ThreadFinalizer finalizer) {
        Thread thread = new Thread(){

            public void run() {
                block3: {
                    try {
                        callable.call();
                        AbstractConcurrentToken.this.childThreads.remove(this);
                        if (finalizer != null) {
                            finalizer.finalizeCurrentThread();
                        }
                    }
                    catch (Exception e) {
                        AbstractConcurrentToken.this.childThreads.remove(this);
                        if (!AbstractConcurrentToken.this.exception.compareAndSet(null, e)) break block3;
                        AbstractConcurrentToken.this.handleException(this, e);
                    }
                }
            }
        };
        this.childThreads.put(thread, DUMMY);
        return thread;
    }

    private void handleException(Thread thread, Exception e) {
        Set<Thread> children = this.childThreads.keySet();
        while (!children.isEmpty()) {
            for (Thread child : children) {
                child.interrupt();
            }
            children = this.childThreads.keySet();
        }
    }

    @Override
    public void waitForChildThreads() throws InterruptedException {
        Set<Thread> children = this.childThreads.keySet();
        while (!children.isEmpty()) {
            for (Thread child : children) {
                child.join();
            }
            children = this.childThreads.keySet();
        }
        if (this.progressAggregator != null) {
            try {
                this.progressAggregator.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (this.exception.get() != null) {
            throw new RuntimeException(this.exception.get());
        }
    }

    @Override
    public boolean isProgressIncrementNotifiable(int e) {
        return this.progressAggregator == null ? false : e <= this.progressAggregator.getSmallestIncrement();
    }

    @Override
    public void notifyProgressIncrement(int e) throws IOException {
        if (this.isProgressIncrementNotifiable(e)) {
            this.progressAggregator.updateProgress(e);
        }
    }
}

