/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.column;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.jbase.EntityMarshaller;
import ch.javasoft.jbase.VariableWidthTable;
import ch.javasoft.jbase.concurrent.ConcurrentTable;
import ch.javasoft.math.BigFraction;
import ch.javasoft.math.NumberOperations;
import ch.javasoft.math.ops.BigIntegerOperations;
import ch.javasoft.metabolic.FluxDistribution;
import ch.javasoft.metabolic.MetabolicNetwork;
import ch.javasoft.metabolic.efm.column.AbstractColumn;
import ch.javasoft.metabolic.efm.column.AbstractHome;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.config.Arithmetic;
import ch.javasoft.metabolic.efm.memory.outcore.Cache;
import ch.javasoft.metabolic.efm.model.ColumnInspectorModifier;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.model.IterationStateModel;
import ch.javasoft.metabolic.efm.model.IterationStepModel;
import ch.javasoft.metabolic.efm.util.BitSetUtil;
import ch.javasoft.metabolic.impl.FractionNumberFluxDistribution;
import ch.javasoft.smx.iface.ReadableBigIntegerMatrix;
import ch.javasoft.smx.iface.ReadableBigIntegerRationalMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.impl.DefaultBigIntegerMatrix;
import ch.javasoft.smx.ops.Gauss;
import ch.javasoft.util.Arrays;
import ch.javasoft.util.ByteArray;
import ch.javasoft.util.numeric.BigIntegerUtil;
import ch.javasoft.util.numeric.Zero;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawBigIntegerColumn
extends AbstractColumn {
    private int mBoolSize;
    private int mNumericSize;
    private final IBitSet mBitSet;
    private byte[] mNumericBytes;
    public static final Home HOME = new Home(){

        @Override
        public Arithmetic getArithmetic() {
            return Arithmetic.rawint;
        }

        @Override
        public NumberOperations<BigInteger> getNumberOperations() {
            return BigIntegerOperations.instance();
        }

        @Override
        public RawBigIntegerColumn newInstance(int booleanSize, int numericSize) {
            throw new RuntimeException("not implemented");
        }

        public RawBigIntegerColumn[] newInstances(ReadableMatrix<BigInteger> matrix, int booleanSize) {
            int rows = matrix.getRowCount();
            int cols = matrix.getColumnCount();
            RawBigIntegerColumn[] res = new RawBigIntegerColumn[cols];
            int col = 0;
            while (col < cols) {
                BigInteger[] vals = new BigInteger[rows];
                int row = 0;
                while (row < rows) {
                    vals[row] = matrix.getNumberValueAt(row, col);
                    ++row;
                }
                res[col] = new RawBigIntegerColumn(booleanSize, vals.length, BitSetUtil.factory().create(rows), RawBigIntegerColumn.fromBigIntegers(vals));
                ++col;
            }
            return res;
        }

        @Override
        public RawBigIntegerColumn readFrom(DataInput dataIn, int booleanSize, int numericSize) throws IOException {
            IBitSet bitSet = this.readBinaryFrom(dataIn, booleanSize);
            int byteLen = dataIn.readInt();
            byte[] bytes = new byte[byteLen];
            dataIn.readFully(bytes);
            return new RawBigIntegerColumn(booleanSize, numericSize, bitSet, bytes);
        }

        @Override
        public void writeTo(RawBigIntegerColumn column, DataOutput dataOut) throws IOException {
            this.writeBinaryTo(column, dataOut);
            dataOut.writeInt(column.mNumericBytes.length);
            dataOut.write(column.mNumericBytes);
        }

        @Override
        public EntityMarshaller<RawBigIntegerColumn> getEntityMarshaller(final int booleanSize, final int numericSize) throws IOException {
            return new EntityMarshaller<RawBigIntegerColumn>(){

                @Override
                public RawBigIntegerColumn readFrom(DataInput in) throws IOException {
                    return (RawBigIntegerColumn)HOME.readFrom(in, booleanSize, numericSize);
                }

                @Override
                public void writeTo(RawBigIntegerColumn entity, DataOutput out) throws IOException {
                    HOME.writeTo(entity, out);
                }
            };
        }

        @Override
        public ConcurrentTable<RawBigIntegerColumn> createTable(File folder, String fileName, int booleanSize, int numericSize) throws IOException {
            int boolByteLen = BitSetUtil.byteSize(booleanSize);
            int numericByteLen = numericSize * 12;
            return new ConcurrentTable<RawBigIntegerColumn>(VariableWidthTable.create(folder, fileName, boolByteLen + numericByteLen, this.getEntityMarshaller(booleanSize, numericSize), Cache.BigIntegerMemoryTable.getCacheTableSize(), Cache.BigIntegerMemoryTable.getCacheEntrySize()));
        }

        @Override
        public ConcurrentTable<RawBigIntegerColumn> openTable(File folder, String fileName, int booleanSize, int numericSize) throws IOException {
            return new ConcurrentTable<RawBigIntegerColumn>(VariableWidthTable.open(folder, fileName, this.getEntityMarshaller(booleanSize, numericSize), Cache.BigIntegerMemoryTable.getCacheTableSize(), Cache.BigIntegerMemoryTable.getCacheEntrySize()));
        }

        public FluxDistribution createFluxDistribution(MetabolicNetwork net, BigInteger[] values) {
            return new FractionNumberFluxDistribution(net, values);
        }

        @Override
        public ReadableMatrix<BigInteger> convertMatrix(ReadableMatrix matrix, boolean allowRowScaling, boolean allowColumnScaling) {
            if (matrix instanceof ReadableBigIntegerMatrix) {
                return ((ReadableBigIntegerMatrix)matrix).toBigIntegerMatrix(false);
            }
            int rows = matrix.getRowCount();
            int cols = matrix.getColumnCount();
            DefaultBigIntegerMatrix mx = new DefaultBigIntegerMatrix(rows, cols);
            if (allowRowScaling) {
                int row = 0;
                while (row < rows) {
                    BigInteger lcm = BigInteger.ONE;
                    int col = 0;
                    while (col < cols) {
                        BigFraction val = BigFraction.valueOf(matrix.getNumberValueAt(row, col));
                        lcm = BigIntegerUtil.lcm(lcm, val.getDenominator());
                        ++col;
                    }
                    BigFraction scale = BigFraction.valueOf(lcm.abs());
                    int col2 = 0;
                    while (col2 < cols) {
                        BigFraction val = BigFraction.valueOf(matrix.getNumberValueAt(row, col2));
                        BigFraction scaled = val.multiply(scale).reduce();
                        if (!scaled.isInteger()) {
                            throw new RuntimeException("internal error: could not scale to integer: " + scaled);
                        }
                        mx.setValueAt(row, col2, scaled.toBigInteger());
                        ++col2;
                    }
                    ++row;
                }
            } else if (allowColumnScaling) {
                int col = 0;
                while (col < cols) {
                    BigInteger lcm = BigInteger.ONE;
                    int row = 0;
                    while (row < rows) {
                        BigFraction val = BigFraction.valueOf(matrix.getNumberValueAt(row, col));
                        lcm = BigIntegerUtil.lcm(lcm, val.getDenominator());
                        ++row;
                    }
                    BigFraction scale = BigFraction.valueOf(lcm.abs());
                    int row2 = 0;
                    while (row2 < rows) {
                        BigFraction val = BigFraction.valueOf(matrix.getNumberValueAt(row2, col));
                        BigFraction scaled = val.multiply(scale).reduce();
                        if (!scaled.isInteger()) {
                            throw new RuntimeException("internal error: could not scale to integer: " + scaled);
                        }
                        mx.setValueAt(row2, col, scaled.toBigInteger());
                        ++row2;
                    }
                    ++col;
                }
            } else {
                throw new IllegalArgumentException("either allowRowScaling or allowColumnScaling must be true");
            }
            return mx;
        }

        @Override
        public ReadableMatrix<BigInteger> castMatrix(ReadableMatrix matrix) {
            if (matrix instanceof ReadableBigIntegerMatrix) {
                return ((ReadableBigIntegerMatrix)matrix).toBigIntegerMatrix(false);
            }
            throw new ClassCastException("not a ReadableBigIntegerMatrix: " + matrix.getClass().getName());
        }

        @Override
        public RawBigIntegerColumn castColumn(Column column) {
            return (RawBigIntegerColumn)column;
        }

        @Override
        public BigInteger castNumber(Number number) {
            return (BigInteger)number;
        }

        @Override
        public int rank(ReadableMatrix matrix, Zero zero) {
            return new Gauss(zero.mZeroPos).rank((ReadableBigIntegerRationalMatrix)matrix);
        }
    };

    public RawBigIntegerColumn(int boolSize) {
        this.mBoolSize = boolSize;
        this.mBitSet = BitSetUtil.factory().create(boolSize);
        this.mNumericBytes = new byte[0];
    }

    protected RawBigIntegerColumn(int boolSize, int numericSize, IBitSet bitSet, byte[] numericBytes) {
        this.mBoolSize = boolSize;
        this.mNumericSize = numericSize;
        this.mBitSet = bitSet;
        this.mNumericBytes = numericBytes;
    }

    @Override
    public IBitSet bitValues() {
        return this.mBitSet;
    }

    @Override
    public <N extends Number> N getNumeric(ColumnHome<N, ?> columnHome, int row) {
        return columnHome.castNumber(RawBigIntegerColumn.toBigInteger(this.mNumericBytes, row));
    }

    private static BigInteger toBigInteger(byte[] bytes, int row) {
        int offset = RawBigIntegerColumn.getOffset(bytes, row);
        byte first = bytes[offset];
        if (first == 0) {
            return BigInteger.ZERO;
        }
        if ((0x80 & first) == 0) {
            return new BigInteger(Arrays.copyOfRange(bytes, offset + 1, offset + 1 + first));
        }
        int len = Integer.MAX_VALUE & (first << 24 | bytes[offset + 1] << 16 | bytes[offset + 2] << 8 | bytes[offset + 3]);
        return new BigInteger(Arrays.copyOfRange(bytes, offset + 4, offset + 4 + len));
    }

    private static int toSignum(byte[] bytes, int row) {
        int offset = RawBigIntegerColumn.getOffset(bytes, row);
        byte first = bytes[offset];
        if (first == 0) {
            return 0;
        }
        byte mostsig = (0x80 & first) == 0 ? bytes[offset + 1] : bytes[offset + 4];
        return mostsig == 0 ? 0 : (mostsig < 0 ? -1 : 1);
    }

    private static int getOffset(byte[] bytes, int row) {
        int offset = 0;
        while (row > 0) {
            byte first = bytes[offset];
            if (first == 0) {
                ++offset;
            } else if ((0x80 & first) == 0) {
                ++offset;
                offset += first;
            } else {
                int len = Integer.MAX_VALUE & (first << 24 | bytes[offset + 1] << 16 | bytes[offset + 2] << 8 | bytes[offset + 3]);
                offset += len + 4;
            }
            --row;
        }
        return offset;
    }

    private BigInteger[] toBigIntegers() {
        BigInteger[] res = new BigInteger[this.mNumericSize];
        int offset = 0;
        int i = 0;
        while (i < res.length) {
            offset += RawBigIntegerColumn.toBigInteger(res, i, this.mNumericBytes, offset);
            ++i;
        }
        return res;
    }

    private static int toBigInteger(BigInteger[] result, int resultIndex, byte[] bytes, int offset) {
        byte first = bytes[offset];
        if (first == 0) {
            result[resultIndex] = BigInteger.ZERO;
            return 1;
        }
        if ((0x80 & first) == 0) {
            result[resultIndex] = new BigInteger(Arrays.copyOfRange(bytes, offset + 1, offset + 1 + first));
            return 1 + first;
        }
        int len = Integer.MAX_VALUE & (first << 24 | bytes[offset + 1] << 16 | bytes[offset + 2] << 8 | bytes[offset + 3]);
        result[resultIndex] = new BigInteger(Arrays.copyOfRange(bytes, offset + 4, offset + 4 + len));
        return 4 + len;
    }

    private static byte[] fromBigIntegers(BigInteger[] values) {
        ByteArray buf = new ByteArray();
        int i = 0;
        while (i < values.length) {
            if (values[i].signum() == 0) {
                buf.add((byte)0);
            } else {
                byte[] bytes = values[i].toByteArray();
                int len = bytes.length;
                if (len <= 127) {
                    buf.add((byte)len);
                } else {
                    buf.add((byte)(0x80 | len >> 24));
                    buf.add((byte)(len >> 16));
                    buf.add((byte)(len >> 8));
                    buf.add((byte)len);
                }
                int j = 0;
                while (j < bytes.length) {
                    buf.add(bytes[j]);
                    ++j;
                }
            }
            ++i;
        }
        return buf.toArray();
    }

    @Override
    public int booleanSize() {
        return this.mBoolSize;
    }

    @Override
    public int numericSize() {
        return this.mNumericSize;
    }

    public int size() {
        return this.mBoolSize + this.mNumericSize;
    }

    @Override
    public int getNumericSignum(Zero zero, int row) {
        return RawBigIntegerColumn.toSignum(this.mNumericBytes, row);
    }

    @Override
    public int getHyperplaneSign(EfmModel model, IterationStateModel iteration) {
        return RawBigIntegerColumn.getColumnInspectorModifier(model, BigInteger.class, BigInteger[].class).getHyperplaneSign(this.columnHome(), model, this.mBitSet, this.mBoolSize, this.toBigIntegers(), iteration);
    }

    @Override
    public <Col extends Column> Col convert(ColumnHome<?, Col> columnHome, EfmModel model, IterationStepModel iteration, boolean clone) {
        BigInteger[] bigInts = this.toBigIntegers();
        ColumnInspectorModifier<BigInteger, BigInteger[]> modifier = RawBigIntegerColumn.getColumnInspectorModifier(model, BigInteger.class, BigInteger[].class);
        IBitSet newBin = modifier.convertBinary(this.columnHome(), model, this.mBitSet, this.mBoolSize, bigInts, iteration, clone);
        BigInteger[] newNum = modifier.convertNumeric(this.columnHome(), model, this.mBitSet, this.mBoolSize, bigInts, iteration, clone);
        if (clone) {
            return columnHome.castColumn(new RawBigIntegerColumn(iteration.getNextState().getBooleanSize(), newNum.length, newBin, RawBigIntegerColumn.fromBigIntegers(newNum)));
        }
        this.mBoolSize = iteration.getNextState().getBooleanSize();
        if (this.mBitSet != newBin) {
            this.mBitSet.clear();
            this.mBitSet.or(newBin);
        }
        this.mNumericSize = newNum.length;
        this.mNumericBytes = RawBigIntegerColumn.fromBigIntegers(newNum);
        return columnHome.castColumn(this);
    }

    @Override
    public <Col extends Column> Col mergeWith(ColumnHome<?, Col> columnHome, EfmModel model, Col other, IterationStepModel iteration) {
        return columnHome.castColumn(this.mergeWith(model, (RawBigIntegerColumn)other, iteration));
    }

    public RawBigIntegerColumn mergeWith(EfmModel model, RawBigIntegerColumn other, IterationStepModel iteration) {
        BigInteger[] myBigInts = this.toBigIntegers();
        BigInteger[] otBigInts = other.toBigIntegers();
        ColumnInspectorModifier<BigInteger, BigInteger[]> modifier = RawBigIntegerColumn.getColumnInspectorModifier(model, BigInteger.class, BigInteger[].class);
        IBitSet newBin = modifier.mergeBinary(this.columnHome(), model, this.mBitSet, this.mBoolSize, myBigInts, other.mBitSet, other.mBoolSize, otBigInts, iteration);
        BigInteger[] newNum = modifier.mergeNumeric(this.columnHome(), model, this.mBitSet, this.mBoolSize, myBigInts, other.mBitSet, other.mBoolSize, otBigInts, iteration);
        return new RawBigIntegerColumn(iteration.getNextState().getBooleanSize(), newNum.length, newBin, RawBigIntegerColumn.fromBigIntegers(newNum));
    }

    @Override
    public void writeTo(DataOutput dataOut) throws IOException {
        this.columnHome().writeTo(this, dataOut);
    }

    @Override
    public RawBigIntegerColumn clone() {
        return new RawBigIntegerColumn(this.mBoolSize, this.mNumericSize, this.mBitSet.clone(), Arrays.copyOf(this.mNumericBytes, this.mNumericBytes.length));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RawBigIntegerColumn) {
            RawBigIntegerColumn col = (RawBigIntegerColumn)obj;
            return this.mBoolSize == col.mBoolSize && this.mBitSet.equals(col.mBitSet) && java.util.Arrays.equals(this.mNumericBytes, col.mNumericBytes);
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        int ii = 0;
        while (ii < this.mBoolSize) {
            sb.append(this.mBitSet.get(ii) ? (char)'1' : '0');
            ++ii;
        }
        BigInteger[] bigInts = this.toBigIntegers();
        int ii2 = 0;
        while (ii2 < bigInts.length) {
            if (this.mBoolSize > 0 || ii2 > 0) {
                sb.append(", ");
            }
            sb.append(bigInts[ii2]);
            ++ii2;
        }
        sb.append('}');
        return sb.toString();
    }

    public Home columnHome() {
        return HOME;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Home
    extends AbstractHome<BigInteger, RawBigIntegerColumn>
    implements ColumnHome<BigInteger, RawBigIntegerColumn> {
    }
}

