/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.borndie.memory;

import ch.javasoft.metabolic.efm.borndie.BornDieController;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.memory.IndexableMemory;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.model.DefaultIterationStateModel;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.model.IterationStateModel;
import ch.javasoft.util.Arrays;
import ch.javasoft.util.IntArray;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredSortablePosMemory<Col extends Column>
implements SortableMemory<Col>,
Cloneable {
    private final IndexableMemory<Col> baseMemory;
    private final int partnerDieRow;
    private final int[] mapping;

    public FilteredSortablePosMemory(BornDieController<Col> controller, IndexableMemory<Col> baseMemory, int partnerDieRow) throws IOException {
        this.baseMemory = baseMemory;
        this.partnerDieRow = partnerDieRow;
        DefaultIterationStateModel itModel = new DefaultIterationStateModel(controller.getModel(), partnerDieRow + 1);
        this.mapping = this.filter(baseMemory, controller.getModel(), itModel);
    }

    protected FilteredSortablePosMemory(IndexableMemory<Col> baseMemory, int partnerDieRow, int[] mapping) {
        this.baseMemory = baseMemory;
        this.partnerDieRow = partnerDieRow;
        this.mapping = mapping;
    }

    private int[] filter(IndexableMemory<Col> srcMemory, EfmModel efmModel, IterationStateModel itModel) throws IOException {
        IntArray mapping = new IntArray();
        int cols = srcMemory.getColumnCount();
        int i = 0;
        while (i < cols) {
            Col col = srcMemory.getColumn(i);
            if (col.getHyperplaneSign(efmModel, itModel) > 0) {
                mapping.add(i);
            }
            ++i;
        }
        return mapping.toArray();
    }

    @Override
    public String fileId() throws IOException {
        return String.valueOf(this.baseMemory.fileId()) + "-pd" + this.partnerDieRow;
    }

    @Override
    public int getColumnCount() throws IOException {
        return this.mapping.length;
    }

    @Override
    public Col getColumn(int index) throws IOException {
        return this.baseMemory.getColumn(this.mapping[index]);
    }

    @Override
    public Iterator<Col> iterator() {
        return new Iterator<Col>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < FilteredSortablePosMemory.this.mapping.length;
            }

            @Override
            public Col next() {
                try {
                    Object col = FilteredSortablePosMemory.this.getColumn(this.index);
                    ++this.index;
                    return col;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("not modifiable");
            }
        };
    }

    @Override
    public void swapColumns(int indexA, int indexB) throws IOException {
        IntArray.swap(this.mapping, indexA, indexB);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close(boolean erase) throws IOException {
        if (erase) {
            throw new IllegalArgumentException("cannot erase a filtered memory");
        }
        this.baseMemory.close(false);
    }

    public FilteredSortablePosMemory<Col> clone() {
        return new FilteredSortablePosMemory<Col>(this.baseMemory, this.partnerDieRow, Arrays.copyOf(this.mapping, this.mapping.length));
    }
}

