/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.adj.incore.tree.urank.modp;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.math.Prime;
import ch.javasoft.metabolic.efm.adj.incore.tree.urank.RankUpdateRoot;
import ch.javasoft.metabolic.efm.rankup.PreprocessableMatrix;
import ch.javasoft.metabolic.efm.rankup.PreprocessedMatrix;
import ch.javasoft.metabolic.efm.rankup.RankUpRoot;
import ch.javasoft.metabolic.efm.util.BitSetUtil;
import ch.javasoft.metabolic.efm.util.ModUtil;
import ch.javasoft.util.Arrays;
import ch.javasoft.util.IntArray;

public class ModPrimePreprocessedMatrix
implements PreprocessedMatrix {
    private static final int[] PRIMES = ModPrimePreprocessedMatrix.initPrimes(1);
    private final Data[] data;

    public ModPrimePreprocessedMatrix(ModPrimePreprocessedMatrix copyOf) {
        this.data = new Data[copyOf.data.length];
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = copyOf.data[i].clone();
            ++i;
        }
    }

    public ModPrimePreprocessedMatrix(PreprocessableMatrix owner, RankUpdateRoot root) {
        int stoichRank = root.getStoichRank();
        int[] colmap = root.getColMapping();
        IBitSet bits = BitSetUtil.factory().create(colmap.length);
        int i = 0;
        while (i < colmap.length) {
            bits.set(i);
            ++i;
        }
        this.data = new Data[PRIMES.length];
        i = 0;
        while (i < this.data.length) {
            IBitSet unused = bits.clone();
            int[][] matrix = ModUtil.toIntArrayNoInversion(root.getStoichRational(), PRIMES[i]);
            int rank = ModPrimePreprocessedMatrix.computeRank(matrix, i, stoichRank, stoichRank, 0, colmap, unused, unused, owner.nodeCutSet);
            this.data[i] = new Data(matrix, rank, unused);
            ++i;
        }
    }

    public ModPrimePreprocessedMatrix(PreprocessableMatrix owner, RankUpdateRoot root, ModPrimePreprocessedMatrix parentProcessed) {
        this.data = new Data[PRIMES.length];
        int i = 0;
        while (i < this.data.length) {
            IBitSet unused = parentProcessed.data[i].unusedBits.clone();
            int[][] matrix = parentProcessed.data[i].matrix;
            int stoichRank = root.getStoichRank();
            int[] colmap = root.getColMapping();
            int rank = ModPrimePreprocessedMatrix.computeRank(matrix, i, stoichRank, stoichRank, parentProcessed.data[i].rank, colmap, unused, unused, owner.nodeCutSet);
            this.data[i] = new Data(matrix, rank, unused);
            ++i;
        }
    }

    public boolean hasRequiredRank(RankUpRoot root, IBitSet intersectionSet) {
        int stoichRank = root.getStoichRank();
        int reqRank = root.getRequiredRank() - intersectionSet.cardinality();
        int[] colmap = root.getColMapping();
        return reqRank <= this.getMaxRank() || reqRank <= this.computeRank(stoichRank, reqRank, colmap, intersectionSet);
    }

    public int getMaxRank() {
        int rank = 0;
        int i = 0;
        while (i < this.data.length) {
            rank = Math.max(rank, this.data[i].rank);
            ++i;
        }
        return rank;
    }

    public String toString() {
        return "preprocessed(" + this.getMaxRank() + ")";
    }

    public ModPrimePreprocessedMatrix clone() {
        return new ModPrimePreprocessedMatrix(this);
    }

    private int computeRank(int stoichRank, int stopRank, int[] fixcolmap, IBitSet setToCompute) {
        int maxRank = 0;
        int i = 0;
        while (i < this.data.length) {
            int cur = ModPrimePreprocessedMatrix.computeRank(this.data[i].matrix, i, stoichRank, stopRank, this.data[i].rank, fixcolmap, this.data[i].unusedBits, null, setToCompute);
            if (stopRank <= cur) {
                return cur;
            }
            maxRank = Math.max(maxRank, cur);
            ++i;
        }
        return maxRank;
    }

    private static int computeRank(int[][] mx, int which, int stoichRank, int stopRank, int rank, int[] fixcolmap, IBitSet unusedBits, IBitSet unusedBitsOut, IBitSet setToCompute) {
        int iprime = PRIMES[which];
        int bits = fixcolmap.length;
        int[] colmap = new int[bits];
        int[] bitmap = new int[bits];
        int colsAct = rank;
        int colsPas = bits;
        int bit = unusedBits.nextSetBit(0);
        while (bit >= 0) {
            if (!setToCompute.get(bit)) {
                bitmap[colsAct] = bit;
                colmap[colsAct] = fixcolmap[bit];
                ++colsAct;
            } else {
                colmap[--colsPas] = fixcolmap[bit];
            }
            bit = unusedBits.nextSetBit(bit + 1);
        }
        if (colsPas != colsAct) {
            throw new RuntimeException("internal error, colsPas should be same as colsAct: " + colsPas + "!=" + colsAct);
        }
        int colsTot = bits;
        int rows = mx.length;
        int pivs = Math.min(stopRank, Math.min(rows, colsAct));
        int ipiv = rank;
        while (ipiv < pivs) {
            int prow = ipiv;
            int picol = ipiv;
            int pval = 0;
            int icol = ipiv;
            while (icol < colsAct && pval == 0) {
                int row = ipiv;
                while (row < rows && pval == 0) {
                    int col = colmap[icol];
                    prow = row;
                    picol = icol;
                    pval = mx[row][col];
                    ++row;
                }
                ++icol;
            }
            if (pval == 0) {
                return ipiv;
            }
            if (prow != ipiv) {
                Arrays.swap((Object[])mx, prow, ipiv);
            }
            if (picol != ipiv) {
                IntArray.swap(colmap, picol, ipiv);
                IntArray.swap(bitmap, picol, ipiv);
            }
            if (unusedBitsOut != null) {
                unusedBitsOut.clear(bitmap[ipiv]);
            }
            int pivrow = ipiv;
            int pivcol = colmap[ipiv];
            int[] prowvals = mx[pivrow];
            int row = ipiv + 1;
            while (row < rows) {
                long rpiv = mx[row][pivcol];
                mx[row][pivcol] = 0;
                int icol2 = ipiv + 1;
                while (icol2 < colsTot) {
                    int col = colmap[icol2];
                    long old = mx[row][col];
                    long val = (old * (long)pval - (long)prowvals[col] * rpiv) % (long)iprime;
                    mx[row][col] = (int)val;
                    ++icol2;
                }
                ++row;
            }
            ++ipiv;
        }
        return pivs;
    }

    private static int[] initPrimes(int cnt) {
        int[] primes = new int[cnt];
        int i = 0;
        while (i < primes.length) {
            primes[i] = Prime.getPrime31(i);
            ++i;
        }
        return primes;
    }

    private static class Data {
        final int[][] matrix;
        final int rank;
        final IBitSet unusedBits;

        public Data(int[][] matrix, int rank, IBitSet unusedBits) {
            this.matrix = matrix;
            this.rank = rank;
            this.unusedBits = unusedBits;
        }

        public Data clone() {
            return new Data(IntArray.clone(this.matrix), this.rank, this.unusedBits.clone());
        }
    }
}

