/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.adj.incore;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.lang.reflect.Array;
import ch.javasoft.math.Prime;
import ch.javasoft.metabolic.efm.adj.incore.AbstractAdjacencyEnumerator;
import ch.javasoft.metabolic.efm.adj.incore.RankAdjacencyEnumerator;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.column.ColumnPair;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.memory.SortableMemory;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.util.BitSetUtil;
import ch.javasoft.metabolic.efm.util.MappingUtil;
import ch.javasoft.metabolic.efm.util.ModUtil;
import ch.javasoft.smx.iface.BigIntegerRationalMatrix;
import ch.javasoft.smx.iface.ReadableBigIntegerRationalMatrix;
import ch.javasoft.smx.iface.ReadableDoubleMatrix;
import ch.javasoft.smx.iface.ReadableMatrix;
import ch.javasoft.smx.impl.DefaultBigIntegerRationalMatrix;
import ch.javasoft.smx.ops.Gauss;
import ch.javasoft.util.Arrays;
import ch.javasoft.util.numeric.Zero;
import java.io.IOException;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModRankTestAdjacencyEnumerator
extends AbstractAdjacencyEnumerator
implements RankAdjacencyEnumerator {
    public static final String NAME = "mod-rank";
    private static final int PRIME = Prime.getPrimeBelow((int)Math.sqrt(1.073741823E9));
    protected final boolean mIsMinCardinalityTested;
    private int[] mColMapping;
    private int[][] mStoichRed;
    private IBitSet[] mRowsAnyInCol;
    private IBitSet[] mColsAnyInRow;

    public ModRankTestAdjacencyEnumerator() {
        this(false);
    }

    public ModRankTestAdjacencyEnumerator(boolean isMinCardinalityTested) {
        this.mIsMinCardinalityTested = isMinCardinalityTested;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public <Col extends Column, N extends Number> void initialize(ColumnHome<N, Col> columnHome, Config config, EfmModel model) {
        super.initialize(columnHome, config, model);
        int[] colMapping = MappingUtil.getInitialMapping(model.getStoichRational().getColumnCount());
        this.mStoichRed = this.getReducedStoichMatrix(config.zero(), model.getStoichRational(), colMapping);
        int[] newMapping = new int[colMapping.length];
        int ii = 0;
        while (ii < newMapping.length) {
            newMapping[ii] = colMapping[model.getReactionSorting()[ii]];
            ++ii;
        }
        this.mColMapping = newMapping;
        int rows = this.mStoichRed.length;
        int cols = this.mStoichRed.length == 0 ? 0 : this.mStoichRed[0].length;
        try {
            this.mRowsAnyInCol = Array.newInstanceInstantiate(BitSetUtil.factory().getBitSetClass(), rows);
            this.mColsAnyInRow = Array.newInstanceInstantiate(BitSetUtil.factory().getBitSetClass(), cols);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                if (this.mConfig.zero().isNonZero(this.mStoichRed[row][col])) {
                    this.mRowsAnyInCol[row].set(col);
                    this.mColsAnyInRow[col].set(row);
                }
                ++col;
            }
            ++row;
        }
    }

    @Override
    public void adjacentPairs(Queue<ColumnPair> adjacentPairs, SortableMemory<Column> zerCols, SortableMemory<Column> posCols, SortableMemory<Column> negCols) throws IOException {
        for (Column colP : posCols) {
            for (Column colN : negCols) {
                ColumnPair<Column> pair = new ColumnPair<Column>(colP, colN);
                IBitSet and = pair.intersectBitValues();
                if (!this.hasRequiredRank(and)) continue;
                adjacentPairs.add(pair);
            }
        }
    }

    private int[][] getReducedStoichMatrix(Zero zero, ReadableMatrix<? extends Number> stoich, int[] colMapping) {
        BigIntegerRationalMatrix mx = ModRankTestAdjacencyEnumerator.convertToBigIntegerRationalMatrix(stoich);
        int fullRank = new Gauss(0.0).rowEchelon(mx, true, null, colMapping);
        MappingUtil.invertMapping(colMapping);
        return ModUtil.toIntArrayNoInversion(mx, PRIME, fullRank);
    }

    private static BigIntegerRationalMatrix convertToBigIntegerRationalMatrix(ReadableMatrix<? extends Number> mx) {
        if (mx instanceof ReadableBigIntegerRationalMatrix) {
            return ((ReadableBigIntegerRationalMatrix)mx).toBigIntegerRationalMatrix(true);
        }
        if (mx instanceof ReadableDoubleMatrix) {
            double[] values = ((ReadableDoubleMatrix)mx).toDoubleArray();
            return new DefaultBigIntegerRationalMatrix(values, mx.getRowCount(), mx.getColumnCount(), false);
        }
        throw new RuntimeException("unsupported matrix type: " + mx.getClass().getName());
    }

    protected int[][] getRemainingMatrix(IBitSet zeroColumns, int[] rankSoFarPtr) {
        int stoichRows = this.mStoichRed.length;
        int stoichCols = stoichRows == 0 ? 0 : this.mStoichRed[0].length;
        int zeroCnt = 0;
        int[] keptCols = new int[stoichCols];
        int keptColCnt = 0;
        int[] keptRows = new int[stoichRows];
        int keptRowCnt = 0;
        int ii = 0;
        while (ii < stoichCols) {
            int col = this.mColMapping[ii];
            if (zeroColumns.get(ii)) {
                if (col < stoichRows) {
                    keptRows[keptRowCnt++] = col;
                }
                ++zeroCnt;
            } else {
                keptCols[keptColCnt++] = col;
            }
            ++ii;
        }
        int[][] arr = new int[keptRowCnt][keptColCnt];
        int zeroCols = 0;
        int newCol = 0;
        int iCol = 0;
        while (iCol < keptColCnt) {
            int col = keptCols[iCol];
            boolean any = false;
            int iRow = 0;
            while (iRow < keptRowCnt) {
                int val;
                int row = keptRows[iRow];
                arr[iRow][newCol] = val = this.mStoichRed[row][col];
                any |= val != 0;
                ++iRow;
            }
            if (any) {
                ++newCol;
            } else {
                ++zeroCols;
            }
            ++iCol;
        }
        rankSoFarPtr[0] = stoichRows + zeroCnt - keptRowCnt;
        if (zeroCols > 0) {
            int[][] zarr = new int[keptRowCnt][keptColCnt - zeroCols];
            int i = 0;
            while (i < zarr.length) {
                System.arraycopy(arr[i], 0, zarr[i], 0, zarr[i].length);
                ++i;
            }
            return zarr;
        }
        return arr;
    }

    public int getRequiredZeroBitCount() {
        return this.getRequiredRank() - this.mStoichRed.length;
    }

    public int getRequiredRank() {
        int rows = this.mStoichRed.length;
        if (rows == 0) {
            return 0;
        }
        return this.mStoichRed[0].length - 2;
    }

    @Override
    public boolean hasRequiredZeroBitCount(IBitSet zeroColumns) {
        return zeroColumns.cardinality() >= this.getRequiredZeroBitCount();
    }

    @Override
    public boolean isRequiredZeroBitCount(int count) {
        return count >= this.getRequiredZeroBitCount();
    }

    @Override
    public boolean hasRequiredRank(IBitSet zeroColumns) {
        int reqRank = this.getRequiredRank();
        if (this.mIsMinCardinalityTested || zeroColumns.cardinality() >= this.getRequiredZeroBitCount()) {
            int[] rankPtr = new int[1];
            int[][] mx = this.getRemainingMatrix(zeroColumns, rankPtr);
            int rankSoFar = rankPtr[0];
            return this.isRankGaussFullPivoting(mx, rankSoFar, reqRank);
        }
        return false;
    }

    protected boolean isRankGaussFullPivoting(int[][] arr, int rankSoFar, int rank) {
        int rows = arr.length;
        int cols = rows == 0 ? 0 : arr[0].length;
        int maxRank = Math.min(rows, cols);
        int pivot = 0;
        while (pivot < maxRank) {
            int prow = pivot;
            int pcol = pivot;
            int pval = 0;
            int row = pivot;
            while (row < rows && pval == 0) {
                int col = pivot;
                while (col < cols && pval == 0) {
                    prow = row;
                    pcol = col;
                    pval = arr[row][col];
                    ++col;
                }
                ++row;
            }
            if (pval == 0) {
                return pivot + rankSoFar >= rank;
            }
            if (prow != pivot) {
                Arrays.swapRow(arr, prow, pivot);
            }
            if (pcol != pivot) {
                Arrays.swapCol(arr, pcol, pivot);
            }
            int[] pivrow = arr[pivot];
            int row2 = pivot + 1;
            while (row2 < rows) {
                int rpiv = arr[row2][pivot];
                arr[row2][pivot] = 0;
                int col = pivot + 1;
                while (col < cols) {
                    arr[row2][col] = (arr[row2][col] * pval - pivrow[col] * rpiv) % PRIME;
                    ++col;
                }
                ++row2;
            }
            ++pivot;
        }
        return maxRank + rankSoFar >= rank;
    }
}

