/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.metabolic.efm.adj.incore;

import ch.javasoft.bitset.IBitSet;
import ch.javasoft.lang.reflect.Array;
import ch.javasoft.metabolic.efm.adj.incore.DefaultRankTestAdjacencyEnumerator;
import ch.javasoft.metabolic.efm.column.Column;
import ch.javasoft.metabolic.efm.column.ColumnHome;
import ch.javasoft.metabolic.efm.config.Config;
import ch.javasoft.metabolic.efm.model.EfmModel;
import ch.javasoft.metabolic.efm.util.BitSetUtil;
import ch.javasoft.util.Arrays;
import ch.javasoft.util.numeric.Zero;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastRankTestAdjacencyEnumerator
extends DefaultRankTestAdjacencyEnumerator {
    public static final String NAME = "fast-rank";
    private IBitSet[] mRowsAnyInCol;
    private IBitSet[] mColsAnyInRow;

    public FastRankTestAdjacencyEnumerator() {
        this(false);
    }

    public FastRankTestAdjacencyEnumerator(boolean isMinCardinalityTested) {
        super(isMinCardinalityTested);
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public <Col extends Column, N extends Number> void initialize(ColumnHome<N, Col> columnHome, Config config, EfmModel model) {
        super.initialize(columnHome, config, model);
        int rows = this.mStoichRed.length;
        int cols = this.mStoichRed.length == 0 ? 0 : this.mStoichRed[0].length;
        try {
            this.mRowsAnyInCol = Array.newInstanceInstantiate(BitSetUtil.factory().getBitSetClass(), rows);
            this.mColsAnyInRow = Array.newInstanceInstantiate(BitSetUtil.factory().getBitSetClass(), cols);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                if (this.mConfig.zero().isNonZero(this.mStoichRed[row][col])) {
                    this.mRowsAnyInCol[row].set(col);
                    this.mColsAnyInRow[col].set(row);
                }
                ++col;
            }
            ++row;
        }
    }

    @Override
    protected double[][] getRemainingMatrix(IBitSet zeroColumns, int[] rankSoFarPtr) {
        int col;
        Zero zero = this.mConfig.zero();
        int stoichRows = this.mStoichRed.length;
        int stoichCols = stoichRows == 0 ? 0 : this.mStoichRed[0].length;
        int zeroSetCnt = 0;
        int zeroColCnt = 0;
        int zeroRowCnt = 0;
        int[] keptCols = new int[stoichCols];
        int keptColCnt = 0;
        int[] keptRows = new int[stoichRows];
        int keptRowCnt = 0;
        IBitSet rowsAny = BitSetUtil.factory().create();
        IBitSet colsAny = BitSetUtil.factory().create();
        int ii = 0;
        while (ii < stoichCols) {
            col = this.mColMapping[ii];
            if (zeroColumns.get(ii)) {
                if (col < stoichRows) {
                    keptRows[keptRowCnt++] = col;
                    colsAny.or(this.mRowsAnyInCol[col]);
                }
                ++zeroSetCnt;
            } else {
                keptCols[keptColCnt++] = col;
                rowsAny.or(this.mColsAnyInRow[col]);
            }
            ++ii;
        }
        int i = 0;
        while (i < keptRowCnt) {
            int row = keptRows[i];
            if (!rowsAny.get(row)) {
                Arrays.swap(keptRows, i, --keptRowCnt);
                ++zeroRowCnt;
                continue;
            }
            ++i;
        }
        i = 0;
        while (i < keptColCnt) {
            col = keptCols[i];
            if (!colsAny.get(col)) {
                Arrays.swap(keptCols, i, --keptColCnt);
                ++zeroColCnt;
                continue;
            }
            ++i;
        }
        double[][] arr = new double[keptRowCnt][keptColCnt];
        int zeroCols = 0;
        int oneValueCols = 0;
        int newCol = 0;
        int iCol = 0;
        while (iCol < keptColCnt) {
            int col2 = keptCols[iCol];
            int cntNonZeros = 0;
            int rowNonZero = -1;
            int iRow = 0;
            while (iRow < keptRowCnt - oneValueCols) {
                double val;
                int row = keptRows[iRow];
                arr[iRow][newCol] = val = this.mStoichRed[row][col2];
                if (zero.isNonZero(val)) {
                    rowNonZero = iRow;
                    ++cntNonZeros;
                }
                ++iRow;
            }
            if (cntNonZeros == 1) {
                Arrays.swapRow(arr, rowNonZero, keptRowCnt - ++oneValueCols);
                Arrays.swap(keptRows, rowNonZero, keptRowCnt - oneValueCols);
            } else if (cntNonZeros > 1) {
                ++newCol;
            } else {
                ++zeroCols;
            }
            ++iCol;
        }
        rankSoFarPtr[0] = stoichRows + zeroSetCnt - zeroRowCnt - (keptRowCnt - oneValueCols);
        if (zeroCols + oneValueCols > 0) {
            double[][] zarr = new double[keptRowCnt - oneValueCols][keptColCnt - zeroCols - oneValueCols];
            int i2 = 0;
            while (i2 < zarr.length) {
                System.arraycopy(arr[i2], 0, zarr[i2], 0, zarr[i2].length);
                ++i2;
            }
            return zarr;
        }
        return arr;
    }
}

