/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.operator.impl;

import ch.javasoft.math.BigFraction;
import ch.javasoft.math.array.ArrayOperations;
import ch.javasoft.math.array.NumberArrayOperations;
import ch.javasoft.math.array.NumberOperators;
import ch.javasoft.math.array.impl.DefaultArrayOperations;
import ch.javasoft.math.linalg.DefaultLinAlgOperations;
import ch.javasoft.math.linalg.GaussPivotingFactory;
import ch.javasoft.math.linalg.LinAlgOperations;
import ch.javasoft.math.linalg.impl.BigFractionGaussPivoting;
import ch.javasoft.math.operator.AbstractBinaryOperator;
import ch.javasoft.math.operator.AbstractBooleanBinaryOperator;
import ch.javasoft.math.operator.AbstractBooleanUnaryOperator;
import ch.javasoft.math.operator.AbstractIntBinaryOperator;
import ch.javasoft.math.operator.AbstractIntUnaryOperator;
import ch.javasoft.math.operator.AbstractNullaryOperator;
import ch.javasoft.math.operator.AbstractUnaryOperator;
import ch.javasoft.math.operator.AggregatingBinaryOperator;
import ch.javasoft.math.operator.AggregatingUnaryOperator;
import ch.javasoft.math.operator.BinaryOperator;
import ch.javasoft.math.operator.BooleanBinaryOperator;
import ch.javasoft.math.operator.BooleanUnaryOperator;
import ch.javasoft.math.operator.ConvertingUnaryOperator;
import ch.javasoft.math.operator.DivisionSupport;
import ch.javasoft.math.operator.IntBinaryOperator;
import ch.javasoft.math.operator.IntUnaryOperator;
import ch.javasoft.math.operator.NullaryOperator;
import ch.javasoft.math.operator.UnaryOperator;
import java.math.BigInteger;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigFractionOperators
implements NumberOperators<BigFraction, BigFraction[]> {
    public static final BigFractionOperators INSTANCE = new BigFractionOperators();
    private final LinAlgOperations<BigFraction, BigFraction[]> linAlgOps;
    private final NullaryOperator<BigFraction, BigFraction[]>[] nullary = BigFractionOperators.initNullary();
    private final UnaryOperator<BigFraction, BigFraction[]>[] unary = BigFractionOperators.initUnary();
    private final BooleanUnaryOperator<BigFraction, BigFraction[]>[] boolUnary = BigFractionOperators.initBoolUnary();
    private final IntUnaryOperator<BigFraction, BigFraction[]>[] intUnary = BigFractionOperators.initIntUnary();
    private final ConvertingUnaryOperator<Number, Number[], BigFraction, BigFraction[]> converter = this.initConverter();
    private final BinaryOperator<BigFraction, BigFraction[]>[] binary = BigFractionOperators.initBinary();
    private final BooleanBinaryOperator<BigFraction, BigFraction[]>[] boolBinary = BigFractionOperators.initBoolBinary();
    private final IntBinaryOperator<BigFraction, BigFraction[]>[] intBinary = BigFractionOperators.initIntBinary();
    private final AggregatingUnaryOperator<BigFraction, BigFraction[]>[] aggUnary = BigFractionOperators.initAggUnary();
    private final AggregatingBinaryOperator<BigFraction, BigFraction[]>[] aggBinary = BigFractionOperators.initAggBinary();

    protected BigFractionOperators() {
        this.linAlgOps = new DefaultLinAlgOperations<BigFraction, BigFraction[]>(this, new DefaultArrayOperations((Class<C[]>)BigFraction[].class), BigFractionGaussPivoting.LEN_PRODUCT_L);
    }

    @Override
    public Class<BigFraction> numberClass() {
        return BigFraction.class;
    }

    @Override
    public Class<BigFraction[]> arrayClass() {
        return BigFraction[].class;
    }

    @Override
    public DivisionSupport getDivisionSupport() {
        return DivisionSupport.EXACT;
    }

    @Override
    public LinAlgOperations<BigFraction, BigFraction[]> getLinAlgOperations() {
        return this.linAlgOps;
    }

    @Override
    public LinAlgOperations<BigFraction, BigFraction[]> getLinAlgOperations(GaussPivotingFactory<BigFraction, BigFraction[]> gaussPivotingFactory) {
        return new DefaultLinAlgOperations<BigFraction, BigFraction[]>(this.getNumberArrayOperations(), gaussPivotingFactory);
    }

    @Override
    public ArrayOperations<BigFraction[]> getArrayOperations() {
        return this.linAlgOps.getArrayOperations();
    }

    @Override
    public NumberArrayOperations<BigFraction, BigFraction[]> getNumberArrayOperations() {
        return this.linAlgOps.getNumberArrayOperations();
    }

    @Override
    public BigFraction zero() {
        return BigFraction.ZERO;
    }

    @Override
    public BigFraction one() {
        return BigFraction.ONE;
    }

    @Override
    public NullaryOperator<BigFraction, BigFraction[]> constant(BigFraction value) {
        if (value.isZero()) {
            return this.nullary(NullaryOperator.Id.zero);
        }
        if (value.isOne()) {
            return this.nullary(NullaryOperator.Id.one);
        }
        return new BigFractionConstOperator(value);
    }

    @Override
    public ConvertingUnaryOperator<Number, Number[], BigFraction, BigFraction[]> converter() {
        return this.converter;
    }

    @Override
    public NullaryOperator<BigFraction, BigFraction[]> nullary(NullaryOperator.Id id) {
        return this.nullary[id.ordinal()];
    }

    @Override
    public UnaryOperator<BigFraction, BigFraction[]> unary(UnaryOperator.Id id) {
        return this.unary[id.ordinal()];
    }

    @Override
    public BooleanUnaryOperator<BigFraction, BigFraction[]> booleanUnary(BooleanUnaryOperator.Id id) {
        return this.boolUnary[id.ordinal()];
    }

    @Override
    public IntUnaryOperator<BigFraction, BigFraction[]> intUnary(IntUnaryOperator.Id id) {
        return this.intUnary[id.ordinal()];
    }

    @Override
    public BinaryOperator<BigFraction, BigFraction[]> binary(BinaryOperator.Id id) {
        return this.binary[id.ordinal()];
    }

    @Override
    public BooleanBinaryOperator<BigFraction, BigFraction[]> booleanBinary(BooleanBinaryOperator.Id id) {
        return this.boolBinary[id.ordinal()];
    }

    @Override
    public IntBinaryOperator<BigFraction, BigFraction[]> intBinary(IntBinaryOperator.Id id) {
        return this.intBinary[id.ordinal()];
    }

    @Override
    public AggregatingUnaryOperator<BigFraction, BigFraction[]> aggregatingUnary(AggregatingUnaryOperator.Id id) {
        return this.aggUnary[id.ordinal()];
    }

    @Override
    public AggregatingBinaryOperator<BigFraction, BigFraction[]> aggregatingBinary(AggregatingBinaryOperator.Id id) {
        return this.aggBinary[id.ordinal()];
    }

    private static NullaryOperator<BigFraction, BigFraction[]>[] initNullary() {
        NullaryOperator[] ops = new NullaryOperator[NullaryOperator.Id.values().length];
        ops[NullaryOperator.Id.zero.ordinal()] = new BigFractionConstOperator(BigFraction.ZERO);
        ops[NullaryOperator.Id.one.ordinal()] = new BigFractionConstOperator(BigFraction.ONE);
        ops[NullaryOperator.Id.random.ordinal()] = new AbstractNullaryOperator<BigFraction, BigFraction[]>(){
            private final Random rnd = new Random();

            @Override
            public BigFraction operate() {
                return BigFraction.valueOf(this.rnd.nextLong(), this.rnd.nextLong());
            }

            @Override
            public void operate(BigFraction[] dst, int dstIndex) {
                dst[dstIndex] = BigFraction.valueOf(this.rnd.nextLong(), this.rnd.nextLong());
            }
        };
        return BigFractionOperators.checkComplete(ops, NullaryOperator.Id.values());
    }

    private static UnaryOperator<BigFraction, BigFraction[]>[] initUnary() {
        UnaryOperator[] ops = new UnaryOperator[UnaryOperator.Id.values().length];
        ops[UnaryOperator.Id.identity.ordinal()] = new AbstractUnaryOperator<BigFraction, BigFraction[]>(){

            @Override
            public BigFraction operate(BigFraction operand) {
                return operand;
            }

            @Override
            public BigFraction operate(BigFraction[] src, int srcIndex) {
                return src[srcIndex];
            }

            @Override
            public void operate(BigFraction[] src, int srcIndex, BigFraction[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex];
            }
        };
        ops[UnaryOperator.Id.normalize.ordinal()] = new AbstractUnaryOperator<BigFraction, BigFraction[]>(){

            @Override
            public BigFraction operate(BigFraction operand) {
                return operand.reduce();
            }

            @Override
            public BigFraction operate(BigFraction[] src, int srcIndex) {
                return src[srcIndex].reduce();
            }

            @Override
            public void operate(BigFraction[] src, int srcIndex, BigFraction[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].reduce();
            }
        };
        ops[UnaryOperator.Id.abs.ordinal()] = new AbstractUnaryOperator<BigFraction, BigFraction[]>(){

            @Override
            public BigFraction operate(BigFraction operand) {
                return operand.abs();
            }

            @Override
            public BigFraction operate(BigFraction[] src, int srcIndex) {
                return src[srcIndex].abs();
            }

            @Override
            public void operate(BigFraction[] src, int srcIndex, BigFraction[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].abs();
            }
        };
        ops[UnaryOperator.Id.negate.ordinal()] = new AbstractUnaryOperator<BigFraction, BigFraction[]>(){

            @Override
            public BigFraction operate(BigFraction operand) {
                return operand.negate();
            }

            @Override
            public BigFraction operate(BigFraction[] src, int srcIndex) {
                return src[srcIndex].negate();
            }

            @Override
            public void operate(BigFraction[] src, int srcIndex, BigFraction[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].negate();
            }
        };
        ops[UnaryOperator.Id.invert.ordinal()] = new AbstractUnaryOperator<BigFraction, BigFraction[]>(){

            @Override
            public BigFraction operate(BigFraction operand) {
                return operand.invert();
            }

            @Override
            public BigFraction operate(BigFraction[] src, int srcIndex) {
                return src[srcIndex].invert();
            }

            @Override
            public void operate(BigFraction[] src, int srcIndex, BigFraction[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].invert();
            }
        };
        ops[UnaryOperator.Id.square.ordinal()] = new AbstractUnaryOperator<BigFraction, BigFraction[]>(){

            @Override
            public BigFraction operate(BigFraction operand) {
                return operand.pow(2);
            }

            @Override
            public BigFraction operate(BigFraction[] src, int srcIndex) {
                return src[srcIndex].pow(2);
            }

            @Override
            public void operate(BigFraction[] src, int srcIndex, BigFraction[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].pow(2);
            }
        };
        return BigFractionOperators.checkComplete(ops, UnaryOperator.Id.values());
    }

    private static IntUnaryOperator<BigFraction, BigFraction[]>[] initIntUnary() {
        IntUnaryOperator[] ops = new IntUnaryOperator[IntUnaryOperator.Id.values().length];
        ops[IntUnaryOperator.Id.signum.ordinal()] = new AbstractIntUnaryOperator<BigFraction, BigFraction[]>(){

            @Override
            public int intOperate(BigFraction operand) {
                return operand.signum();
            }

            @Override
            public int intOperate(BigFraction[] operand, int index) {
                return operand[index].signum();
            }

            @Override
            public void operate(BigFraction[] src, int srcIndex, int[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].signum();
            }
        };
        return BigFractionOperators.checkComplete(ops, IntUnaryOperator.Id.values());
    }

    private ConvertingUnaryOperator<Number, Number[], BigFraction, BigFraction[]> initConverter() {
        return new ConvertingUnaryOperator<Number, Number[], BigFraction, BigFraction[]>(){

            @Override
            public BigFraction operate(Number operand) {
                return BigFraction.valueOf(operand);
            }

            @Override
            public void operate(Number[] src, int srcIndex, BigFraction[] dst, int dstIndex) {
                dst[dstIndex] = BigFraction.valueOf(src[srcIndex]);
            }
        };
    }

    private static BooleanUnaryOperator<BigFraction, BigFraction[]>[] initBoolUnary() {
        BooleanUnaryOperator[] ops = new BooleanUnaryOperator[BooleanUnaryOperator.Id.values().length];
        ops[BooleanUnaryOperator.Id.isZero.ordinal()] = new AbstractBooleanUnaryOperator<BigFraction, BigFraction[]>(){

            @Override
            public boolean booleanOperate(BigFraction operand) {
                return operand.isZero();
            }

            @Override
            public boolean booleanOperate(BigFraction[] src, int srcIndex) {
                return src[srcIndex].isZero();
            }

            @Override
            public void operate(BigFraction[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].isZero();
            }
        };
        ops[BooleanUnaryOperator.Id.isNonZero.ordinal()] = new AbstractBooleanUnaryOperator<BigFraction, BigFraction[]>(){

            @Override
            public boolean booleanOperate(BigFraction operand) {
                return operand.isNonZero();
            }

            @Override
            public boolean booleanOperate(BigFraction[] src, int srcIndex) {
                return src[srcIndex].isNonZero();
            }

            @Override
            public void operate(BigFraction[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].isNonZero();
            }
        };
        ops[BooleanUnaryOperator.Id.isOne.ordinal()] = new AbstractBooleanUnaryOperator<BigFraction, BigFraction[]>(){

            @Override
            public boolean booleanOperate(BigFraction operand) {
                return operand.isOne();
            }

            @Override
            public boolean booleanOperate(BigFraction[] src, int srcIndex) {
                return src[srcIndex].isOne();
            }

            @Override
            public void operate(BigFraction[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].isOne();
            }
        };
        ops[BooleanUnaryOperator.Id.isPositive.ordinal()] = new AbstractBooleanUnaryOperator<BigFraction, BigFraction[]>(){

            @Override
            public boolean booleanOperate(BigFraction operand) {
                return operand.isPositive();
            }

            @Override
            public boolean booleanOperate(BigFraction[] src, int srcIndex) {
                return src[srcIndex].isPositive();
            }

            @Override
            public void operate(BigFraction[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].isPositive();
            }
        };
        ops[BooleanUnaryOperator.Id.isNegative.ordinal()] = new AbstractBooleanUnaryOperator<BigFraction, BigFraction[]>(){

            @Override
            public boolean booleanOperate(BigFraction operand) {
                return operand.isNegative();
            }

            @Override
            public boolean booleanOperate(BigFraction[] src, int srcIndex) {
                return src[srcIndex].isNegative();
            }

            @Override
            public void operate(BigFraction[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].isNegative();
            }
        };
        ops[BooleanUnaryOperator.Id.isNonPositive.ordinal()] = new AbstractBooleanUnaryOperator<BigFraction, BigFraction[]>(){

            @Override
            public boolean booleanOperate(BigFraction operand) {
                return operand.isNonPositive();
            }

            @Override
            public boolean booleanOperate(BigFraction[] src, int srcIndex) {
                return src[srcIndex].isNonPositive();
            }

            @Override
            public void operate(BigFraction[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].isNonPositive();
            }
        };
        ops[BooleanUnaryOperator.Id.isNonNegative.ordinal()] = new AbstractBooleanUnaryOperator<BigFraction, BigFraction[]>(){

            @Override
            public boolean booleanOperate(BigFraction operand) {
                return operand.isNonNegative();
            }

            @Override
            public boolean booleanOperate(BigFraction[] src, int srcIndex) {
                return src[srcIndex].isNonNegative();
            }

            @Override
            public void operate(BigFraction[] src, int srcIndex, boolean[] dst, int dstIndex) {
                dst[dstIndex] = src[srcIndex].isNonNegative();
            }
        };
        return BigFractionOperators.checkComplete(ops, BooleanUnaryOperator.Id.values());
    }

    private static BinaryOperator<BigFraction, BigFraction[]>[] initBinary() {
        BinaryOperator[] ops = new BinaryOperator[BinaryOperator.Id.values().length];
        ops[BinaryOperator.Id.add.ordinal()] = new AbstractBinaryOperator<BigFraction, BigFraction[]>(){

            @Override
            public BigFraction operate(BigFraction operand1, BigFraction operand2) {
                return operand1.add(operand2);
            }

            @Override
            public void operate(BigFraction[] operand1, int index1, BigFraction[] operand2, int index2, BigFraction[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].add(operand2[index2]);
            }
        };
        ops[BinaryOperator.Id.subtract.ordinal()] = new AbstractBinaryOperator<BigFraction, BigFraction[]>(){

            @Override
            public BigFraction operate(BigFraction operand1, BigFraction operand2) {
                return operand1.subtract(operand2);
            }

            @Override
            public void operate(BigFraction[] operand1, int index1, BigFraction[] operand2, int index2, BigFraction[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].subtract(operand2[index2]);
            }
        };
        ops[BinaryOperator.Id.multiply.ordinal()] = new AbstractBinaryOperator<BigFraction, BigFraction[]>(){

            @Override
            public BigFraction operate(BigFraction operand1, BigFraction operand2) {
                return operand1.multiply(operand2);
            }

            @Override
            public void operate(BigFraction[] operand1, int index1, BigFraction[] operand2, int index2, BigFraction[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].multiply(operand2[index2]);
            }
        };
        ops[BinaryOperator.Id.divide.ordinal()] = new AbstractBinaryOperator<BigFraction, BigFraction[]>(){

            @Override
            public BigFraction operate(BigFraction operand1, BigFraction operand2) {
                return operand1.divide(operand2);
            }

            @Override
            public void operate(BigFraction[] operand1, int index1, BigFraction[] operand2, int index2, BigFraction[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].divide(operand2[index2]);
            }
        };
        ops[BinaryOperator.Id.min.ordinal()] = new AbstractBinaryOperator<BigFraction, BigFraction[]>(){

            @Override
            public BigFraction operate(BigFraction operand1, BigFraction operand2) {
                return operand1.min(operand2);
            }

            @Override
            public void operate(BigFraction[] operand1, int index1, BigFraction[] operand2, int index2, BigFraction[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].min(operand2[index2]);
            }
        };
        ops[BinaryOperator.Id.max.ordinal()] = new AbstractBinaryOperator<BigFraction, BigFraction[]>(){

            @Override
            public BigFraction operate(BigFraction operand1, BigFraction operand2) {
                return operand1.max(operand2);
            }

            @Override
            public void operate(BigFraction[] operand1, int index1, BigFraction[] operand2, int index2, BigFraction[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].max(operand2[index2]);
            }
        };
        return BigFractionOperators.checkComplete(ops, BinaryOperator.Id.values());
    }

    private static BooleanBinaryOperator<BigFraction, BigFraction[]>[] initBoolBinary() {
        BooleanBinaryOperator[] ops = new BooleanBinaryOperator[BooleanBinaryOperator.Id.values().length];
        ops[BooleanBinaryOperator.Id.less.ordinal()] = new AbstractBooleanBinaryOperator<BigFraction, BigFraction[]>(){

            @Override
            public boolean booleanOperate(BigFraction operand1, BigFraction operand2) {
                return operand1.compareTo(operand2) < 0;
            }

            @Override
            public boolean booleanOperate(BigFraction[] operand1, int index1, BigFraction[] operand2, int index2) {
                return operand1[index1].compareTo(operand2[index2]) < 0;
            }

            @Override
            public void operate(BigFraction[] operand1, int index1, BigFraction[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].compareTo(operand2[index2]) < 0;
            }
        };
        ops[BooleanBinaryOperator.Id.lessOrEqual.ordinal()] = new AbstractBooleanBinaryOperator<BigFraction, BigFraction[]>(){

            @Override
            public boolean booleanOperate(BigFraction operand1, BigFraction operand2) {
                return operand1.compareTo(operand2) <= 0;
            }

            @Override
            public boolean booleanOperate(BigFraction[] operand1, int index1, BigFraction[] operand2, int index2) {
                return operand1[index1].compareTo(operand2[index2]) <= 0;
            }

            @Override
            public void operate(BigFraction[] operand1, int index1, BigFraction[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].compareTo(operand2[index2]) <= 0;
            }
        };
        ops[BooleanBinaryOperator.Id.equal.ordinal()] = new AbstractBooleanBinaryOperator<BigFraction, BigFraction[]>(){

            @Override
            public boolean booleanOperate(BigFraction operand1, BigFraction operand2) {
                return operand1.equalsNumerically(operand2);
            }

            @Override
            public boolean booleanOperate(BigFraction[] operand1, int index1, BigFraction[] operand2, int index2) {
                return operand1[index1].equalsNumerically(operand2[index2]);
            }

            @Override
            public void operate(BigFraction[] operand1, int index1, BigFraction[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].equalsNumerically(operand2[index2]);
            }
        };
        ops[BooleanBinaryOperator.Id.unequal.ordinal()] = new AbstractBooleanBinaryOperator<BigFraction, BigFraction[]>(){

            @Override
            public boolean booleanOperate(BigFraction operand1, BigFraction operand2) {
                return !operand1.equalsNumerically(operand2);
            }

            @Override
            public boolean booleanOperate(BigFraction[] operand1, int index1, BigFraction[] operand2, int index2) {
                return !operand1[index1].equalsNumerically(operand2[index2]);
            }

            @Override
            public void operate(BigFraction[] operand1, int index1, BigFraction[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = !operand1[index1].equalsNumerically(operand2[index2]);
            }
        };
        ops[BooleanBinaryOperator.Id.greaterOrEqual.ordinal()] = new AbstractBooleanBinaryOperator<BigFraction, BigFraction[]>(){

            @Override
            public boolean booleanOperate(BigFraction operand1, BigFraction operand2) {
                return operand1.compareTo(operand2) >= 0;
            }

            @Override
            public boolean booleanOperate(BigFraction[] operand1, int index1, BigFraction[] operand2, int index2) {
                return operand1[index1].compareTo(operand2[index2]) >= 0;
            }

            @Override
            public void operate(BigFraction[] operand1, int index1, BigFraction[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].compareTo(operand2[index2]) >= 0;
            }
        };
        ops[BooleanBinaryOperator.Id.greater.ordinal()] = new AbstractBooleanBinaryOperator<BigFraction, BigFraction[]>(){

            @Override
            public boolean booleanOperate(BigFraction operand1, BigFraction operand2) {
                return operand1.compareTo(operand2) > 0;
            }

            @Override
            public boolean booleanOperate(BigFraction[] operand1, int index1, BigFraction[] operand2, int index2) {
                return operand1[index1].compareTo(operand2[index2]) > 0;
            }

            @Override
            public void operate(BigFraction[] operand1, int index1, BigFraction[] operand2, int index2, boolean[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].compareTo(operand2[index2]) > 0;
            }
        };
        return BigFractionOperators.checkComplete(ops, BooleanBinaryOperator.Id.values());
    }

    private static IntBinaryOperator<BigFraction, BigFraction[]>[] initIntBinary() {
        IntBinaryOperator[] ops = new IntBinaryOperator[IntBinaryOperator.Id.values().length];
        ops[IntBinaryOperator.Id.compare.ordinal()] = new AbstractIntBinaryOperator<BigFraction, BigFraction[]>(){

            @Override
            public int intOperate(BigFraction operand1, BigFraction operand2) {
                return operand1.compareTo(operand2);
            }

            @Override
            public int intOperate(BigFraction[] operand1, int index1, BigFraction[] operand2, int index2) {
                return operand1[index1].compareTo(operand2[index2]);
            }

            @Override
            public void operate(BigFraction[] operand1, int index1, BigFraction[] operand2, int index2, int[] dst, int dstIndex) {
                dst[dstIndex] = operand1[index1].compareTo(operand2[index2]);
            }
        };
        return BigFractionOperators.checkComplete(ops, IntBinaryOperator.Id.values());
    }

    private static AggregatingUnaryOperator<BigFraction, BigFraction[]>[] initAggUnary() {
        AggregatingUnaryOperator[] ops = new AggregatingUnaryOperator[AggregatingUnaryOperator.Id.values().length];
        ops[AggregatingUnaryOperator.Id.min.ordinal()] = new BigFractionAggregatingUnaryOperator(){

            public BigFraction operate(BigFraction[] src, int srcIndexFrom, int length) {
                if (length == 0) {
                    return null;
                }
                BigFraction min = src[srcIndexFrom];
                int i = 1;
                while (i < length) {
                    min = min.min(src[srcIndexFrom + i]);
                    ++i;
                }
                return min;
            }

            public BigFraction operate(BigFraction[][] src, int srcRowFrom, int srcColFrom, int rows, int cols) {
                if (rows == 0 || cols == 0) {
                    return null;
                }
                BigFraction min = src[srcRowFrom][srcColFrom];
                int r = 0;
                while (r < rows) {
                    int c = 0;
                    while (c < cols) {
                        min = min.min(src[srcRowFrom + r][srcColFrom + c]);
                        ++c;
                    }
                    ++r;
                }
                return min;
            }
        };
        ops[AggregatingUnaryOperator.Id.max.ordinal()] = new BigFractionAggregatingUnaryOperator(){

            public BigFraction operate(BigFraction[] src, int srcIndexFrom, int length) {
                if (length == 0) {
                    return null;
                }
                BigFraction max = src[srcIndexFrom];
                int i = 1;
                while (i < length) {
                    max = max.max(src[srcIndexFrom + i]);
                    ++i;
                }
                return max;
            }

            public BigFraction operate(BigFraction[][] src, int srcRowFrom, int srcColFrom, int rows, int cols) {
                if (rows == 0 || cols == 0) {
                    return null;
                }
                BigFraction max = src[srcRowFrom][srcColFrom];
                int r = 0;
                while (r < rows) {
                    int c = 0;
                    while (c < cols) {
                        max = max.max(src[srcRowFrom + r][srcColFrom + c]);
                        ++c;
                    }
                    ++r;
                }
                return max;
            }
        };
        ops[AggregatingUnaryOperator.Id.sum.ordinal()] = new BigFractionAggregatingUnaryOperator(){

            public BigFraction operate(BigFraction[] src, int srcIndexFrom, int length) {
                BigFraction sum = BigFraction.ZERO;
                int i = 0;
                while (i < length) {
                    sum = sum.add(src[srcIndexFrom + i]);
                    ++i;
                }
                return sum;
            }

            public BigFraction operate(BigFraction[][] src, int srcRowFrom, int srcColFrom, int rows, int cols) {
                BigFraction sum = BigFraction.ZERO;
                int r = 0;
                while (r < rows) {
                    int c = 0;
                    while (c < cols) {
                        sum = sum.add(src[srcRowFrom + r][srcColFrom + c]);
                        ++c;
                    }
                    ++r;
                }
                return sum;
            }
        };
        ops[AggregatingUnaryOperator.Id.prod.ordinal()] = new BigFractionAggregatingUnaryOperator(){

            public BigFraction operate(BigFraction[] src, int srcIndexFrom, int length) {
                BigFraction sum = BigFraction.ONE;
                int i = 0;
                while (i < length) {
                    sum = sum.multiply(src[srcIndexFrom + i]);
                    ++i;
                }
                return sum;
            }

            public BigFraction operate(BigFraction[][] src, int srcRowFrom, int srcColFrom, int rows, int cols) {
                BigFraction sum = BigFraction.ONE;
                int r = 0;
                while (r < rows) {
                    int c = 0;
                    while (c < cols) {
                        sum = sum.multiply(src[srcRowFrom + r][srcColFrom + c]);
                        ++c;
                    }
                    ++r;
                }
                return sum;
            }
        };
        ops[AggregatingUnaryOperator.Id.sumSquared.ordinal()] = new BigFractionAggregatingUnaryOperator(){

            public BigFraction operate(BigFraction[] src, int srcIndexFrom, int length) {
                BigFraction sum = BigFraction.ZERO;
                int i = 0;
                while (i < length) {
                    sum = sum.add(src[srcIndexFrom + i].pow(2));
                    ++i;
                }
                return sum;
            }

            public BigFraction operate(BigFraction[][] src, int srcRowFrom, int srcColFrom, int rows, int cols) {
                BigFraction sum = BigFraction.ZERO;
                int r = 0;
                while (r < rows) {
                    int c = 0;
                    while (c < cols) {
                        sum = sum.add(src[srcRowFrom + r][srcColFrom + c].pow(2));
                        ++c;
                    }
                    ++r;
                }
                return sum;
            }
        };
        ops[AggregatingUnaryOperator.Id.normDivisor.ordinal()] = new BigFractionAggregatingUnaryOperator(){

            public BigFraction operate(BigFraction[] src, int srcIndexFrom, int length) {
                if (length == 0) {
                    return BigFraction.ZERO;
                }
                BigInteger num = src[srcIndexFrom].getNumerator().abs();
                BigInteger den = src[srcIndexFrom].isZero() ? BigInteger.ZERO : src[srcIndexFrom].getDenominator();
                int i = 1;
                while (i < length) {
                    if (num.equals(BigInteger.ONE) && den.equals(BigInteger.ONE)) break;
                    BigFraction val = src[srcIndexFrom + i];
                    num = num.gcd(val.getNumerator());
                    if (val.signum() != 0) {
                        den = den.gcd(val.getDenominator());
                    }
                    ++i;
                }
                return num.signum() == 0 ? BigFraction.ZERO : BigFraction.valueOf(num, den);
            }

            public BigFraction operate(BigFraction[][] src, int srcRowFrom, int srcColFrom, int rows, int cols) {
                if (rows == 0 || cols == 0) {
                    return BigFraction.ZERO;
                }
                BigInteger num = src[srcRowFrom][srcColFrom].getNumerator().abs();
                BigInteger den = src[srcRowFrom][srcColFrom].isZero() ? BigInteger.ZERO : src[srcRowFrom][srcColFrom].getDenominator();
                int r = 0;
                while (r < rows) {
                    int c = 0;
                    while (c < cols) {
                        if (num.equals(BigInteger.ONE) && den.equals(BigInteger.ONE)) break;
                        BigFraction val = src[srcRowFrom + r][srcColFrom + c];
                        num = num.gcd(val.getNumerator());
                        if (val.signum() != 0) {
                            den = den.gcd(val.getDenominator());
                        }
                        ++c;
                    }
                    ++r;
                }
                return num.signum() == 0 ? BigFraction.ZERO : BigFraction.valueOf(num, den);
            }
        };
        ops[AggregatingUnaryOperator.Id.squeezeDivisor.ordinal()] = new BigFractionAggregatingUnaryOperator(){

            public BigFraction operate(BigFraction[] src, int srcIndexFrom, int length) {
                if (length == 0) {
                    return BigFraction.ZERO;
                }
                BigInteger num = src[srcIndexFrom].getNumerator().abs();
                BigInteger den = src[srcIndexFrom].getDenominator();
                int i = 1;
                while (i < length) {
                    BigFraction val = src[srcIndexFrom + i];
                    num = num.gcd(val.getNumerator());
                    if (val.signum() != 0) {
                        BigInteger gcd = den.gcd(val.getDenominator());
                        den = den.multiply(val.getDenominator().abs()).divide(gcd);
                    }
                    ++i;
                }
                return num.signum() == 0 ? BigFraction.ZERO : BigFraction.valueOf(num, den);
            }

            public BigFraction operate(BigFraction[][] src, int srcRowFrom, int srcColFrom, int rows, int cols) {
                if (rows == 0 || cols == 0) {
                    return BigFraction.ZERO;
                }
                BigInteger num = src[srcRowFrom][srcColFrom].getNumerator().abs();
                BigInteger den = src[srcRowFrom][srcColFrom].getDenominator();
                int r = 0;
                while (r < rows) {
                    int c = 0;
                    while (c < cols) {
                        BigFraction val = src[srcRowFrom + r][srcColFrom + c];
                        num = num.gcd(val.getNumerator());
                        if (val.signum() != 0) {
                            BigInteger gcd = den.gcd(val.getDenominator());
                            den = den.multiply(val.getDenominator().abs()).divide(gcd);
                        }
                        ++c;
                    }
                    ++r;
                }
                return num.signum() == 0 ? BigFraction.ZERO : BigFraction.valueOf(num, den);
            }
        };
        return BigFractionOperators.checkComplete(ops, AggregatingUnaryOperator.Id.values());
    }

    private static AggregatingBinaryOperator<BigFraction, BigFraction[]>[] initAggBinary() {
        AggregatingBinaryOperator[] ops = new AggregatingBinaryOperator[AggregatingBinaryOperator.Id.values().length];
        ops[AggregatingBinaryOperator.Id.innerProduct.ordinal()] = new BigFractionAggregatingBinaryOperator(){

            public BigFraction operate(BigFraction[] src1, int src1IndexFrom, BigFraction[] src2, int src2IndexFrom, int length) {
                BigFraction sum = BigFraction.ZERO;
                int i = 0;
                while (i < length) {
                    sum = sum.add(src1[src1IndexFrom + i].multiply(src2[src2IndexFrom + i]));
                    ++i;
                }
                return sum;
            }

            public BigFraction operate(BigFraction[][] src1, int src1RowFrom, int src1Col, BigFraction[] src2, int src2IndexFrom, int length) {
                BigFraction sum = BigFraction.ZERO;
                int i = 0;
                while (i < length) {
                    sum = sum.add(src1[src1RowFrom + i][src1Col].multiply(src2[src2IndexFrom + i]));
                    ++i;
                }
                return sum;
            }

            public BigFraction operate(BigFraction[][] src1, int src1RowFrom, int src1Col, BigFraction[][] src2, int src2RowFrom, int src2Col, int length) {
                BigFraction sum = BigFraction.ZERO;
                int i = 0;
                while (i < length) {
                    sum = sum.add(src1[src1RowFrom + i][src1Col].multiply(src2[src2RowFrom + i][src2Col]));
                    ++i;
                }
                return sum;
            }
        };
        return BigFractionOperators.checkComplete(ops, AggregatingBinaryOperator.Id.values());
    }

    private static <A> A[] checkComplete(A[] arr, Enum[] ids) {
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == null) {
                throw new RuntimeException("internal error, implementation missing for " + arr.getClass().getComponentType().getName() + " for constant " + ids[i]);
            }
            ++i;
        }
        return arr;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class BigFractionAggregatingBinaryOperator
    implements AggregatingBinaryOperator<BigFraction, BigFraction[]> {
        private BigFractionAggregatingBinaryOperator() {
        }

        @Override
        public void operate(BigFraction[] src1, int src1IndexFrom, BigFraction[] src2, int src2IndexFrom, BigFraction[] dst, int dstIndex, int length) {
            dst[dstIndex] = (BigFraction)this.operate(src1, src1IndexFrom, src2, src2IndexFrom, length);
        }

        public void operate(BigFraction[][] src1, int src1RowFrom, int src1Col, BigFraction[] src2, int src2IndexFrom, BigFraction[] dst, int dstIndex, int length) {
            dst[dstIndex] = (BigFraction)this.operate((A[])src1, src1RowFrom, src1Col, src2, src2IndexFrom, length);
        }

        public void operate(BigFraction[][] src1, int src1RowFrom, int src1Col, BigFraction[][] src2, int src2RowFrom, int src2Col, BigFraction[] dst, int dstIndex, int length) {
            dst[dstIndex] = (BigFraction)this.operate((A[])src1, src1RowFrom, src1Col, (A[])src2, src2RowFrom, src2Col, length);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class BigFractionAggregatingUnaryOperator
    implements AggregatingUnaryOperator<BigFraction, BigFraction[]> {
        private BigFractionAggregatingUnaryOperator() {
        }

        @Override
        public void operate(BigFraction[] src, int srcIndexFrom, int srcIndexTo, BigFraction[] dst, int dstIndex) {
            dst[dstIndex] = (BigFraction)this.operate(src, srcIndexFrom, srcIndexTo);
        }

        public void operate(BigFraction[][] src, int srcRowFrom, int srcColFrom, int rows, int cols, BigFraction[] dst, int dstIndex) {
            dst[dstIndex] = (BigFraction)this.operate((A[])src, srcRowFrom, srcColFrom, rows, cols);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BigFractionConstOperator
    extends AbstractNullaryOperator<BigFraction, BigFraction[]> {
        private final BigFraction value;

        public BigFractionConstOperator(BigFraction value) {
            this.value = value;
        }

        @Override
        public BigFraction operate() {
            return this.value;
        }

        @Override
        public void operate(BigFraction[] dst, int dstIndex) {
            dst[dstIndex] = this.value;
        }
    }
}

