/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.operator.compose;

import ch.javasoft.math.array.ArrayOperations;
import ch.javasoft.math.operator.BinaryOperator;
import ch.javasoft.math.operator.NAryOperator;
import ch.javasoft.math.operator.compose.TempArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NAryNAryOperator<T extends Number, A>
implements NAryOperator<T, A> {
    private final BinaryOperator<T, A> operator;
    private final NAryOperator<T, A> operand1;
    private final NAryOperator<T, A> operand2;
    private final TempArray<A> temp;

    public NAryNAryOperator(ArrayOperations<A> ops, BinaryOperator<T, A> operator, NAryOperator<T, A> operand1, NAryOperator<T, A> operand2) {
        this.operator = operator;
        this.operand1 = operand1;
        this.operand2 = operand2;
        this.temp = new TempArray<A>(ops, 2);
    }

    @Override
    public int getOperandCount() {
        return this.operand1.getOperandCount() + this.operand2.getOperandCount();
    }

    @Override
    public T operate(int offset, T ... operands) {
        Number operated1 = (Number)this.operand1.operate(offset, operands);
        Number operated2 = (Number)this.operand2.operate(offset + this.operand1.getOperandCount(), operands);
        return (T)this.operator.operate(operated1, operated2);
    }

    @Override
    public void operate(int offset, A[] operands, int[] indices, A dst, int dstIndex) {
        A tmp = this.temp.get();
        this.operand1.operate(offset, operands, indices, tmp, 0);
        this.operand2.operate(offset + this.operand1.getOperandCount(), operands, indices, tmp, 1);
        this.operator.operate(tmp, 0, tmp, 1, dst, dstIndex);
    }
}

