/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.math.array.sort;

import ch.javasoft.math.array.ArrayOperations;
import ch.javasoft.math.array.NumberOperators;
import ch.javasoft.math.operator.IntUnaryOperator;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FewestNegPosArrayComparator<N extends Number, A>
implements Comparator<A> {
    private final ArrayOperations<A> aops;
    private final IntUnaryOperator<N, A> signum;

    public FewestNegPosArrayComparator(NumberOperators<N, A> operators) {
        this.aops = operators.getArrayOperations();
        this.signum = operators.intUnary(IntUnaryOperator.Id.signum);
    }

    @Override
    public int compare(A o1, A o2) {
        int len1 = this.aops.getLength(o1);
        int neg1 = 0;
        int pos1 = 0;
        int i = 0;
        while (i < len1) {
            int sgn = this.signum.intOperate(o1, i);
            if (sgn < 0) {
                ++neg1;
            } else if (sgn > 0) {
                ++pos1;
            }
            ++i;
        }
        int len2 = this.aops.getLength(o2);
        int neg2 = 0;
        int pos2 = 0;
        int i2 = 0;
        while (i2 < len2) {
            int sgn = this.signum.intOperate(o2, i2);
            if (sgn < 0) {
                ++neg2;
            } else if (sgn > 0) {
                ++pos2;
            }
            ++i2;
        }
        long delta = (long)pos1 * (long)neg1 - (long)pos2 * (long)neg2;
        return delta < 0L ? -1 : (delta > 0L ? 1 : 0);
    }
}

