/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.job;

import ch.javasoft.io.Print;
import ch.javasoft.io.WriterOutputStream;
import ch.javasoft.job.AbstractJob;
import ch.javasoft.job.ExecException;
import ch.javasoft.job.ExitValueException;
import ch.javasoft.job.JobMonitor;
import ch.javasoft.job.JobResult;
import ch.javasoft.job.JobResultFactory;
import ch.javasoft.job.PipeJob;
import ch.javasoft.job.StdErrNonEmptyException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecJobMonitor
implements JobMonitor<Void> {
    private final Process mProcess;
    private final List<InputStream> mCloseInOnTerminate = new ArrayList<InputStream>();
    private final List<OutputStream> mCloseOutOnTerminate = new ArrayList<OutputStream>();
    private final List<JobMonitor> mPipeJobs = new ArrayList<JobMonitor>();
    private JobResult<Void> mResult;

    protected ExecJobMonitor(Process process) {
        this.mProcess = process;
    }

    protected static ExecJobMonitor createForException(Throwable th) {
        ExecJobMonitor hdl = new ExecJobMonitor(null){

            public boolean isRunning() {
                return false;
            }
        };
        JobResult<Void> result = JobResultFactory.createJobResultForException(th);
        hdl.setResult(result);
        return hdl;
    }

    protected Process getProcess() {
        return this.mProcess;
    }

    protected synchronized void setResult(JobResult<Void> result) {
        this.mResult = result;
        this.closeStreams();
    }

    @Override
    public void interrupt() {
        if (this.mProcess != null) {
            this.mProcess.destroy();
        }
    }

    @Override
    public boolean isRunning() {
        try {
            this.mProcess.exitValue();
            return false;
        }
        catch (IllegalThreadStateException ex) {
            return true;
        }
    }

    @Override
    public synchronized JobResult<Void> getJobResult() {
        return this.mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public JobResult<Void> waitForResult() throws InterruptedException {
        this.mProcess.waitFor();
        for (JobMonitor pipeJob : this.mPipeJobs) {
            pipeJob.waitForResult();
        }
        var1_2 = this;
        synchronized (var1_2) {
            this.mPipeJobs.clear();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl13 : MonitorExitStatement: MONITOREXIT : var1_2
            if (true) ** GOTO lbl17
        }
        do {
            Thread.yield();
lbl17:
            // 2 sources

        } while (this.getJobResult() == null);
        return this.getJobResult();
    }

    public <E extends Throwable> void waitForResultThrowException(Class<E> exClass) throws E {
        try {
            JobResult<Void> res = this.waitForResult();
            if (res.isException()) {
                throw res.getException();
            }
        }
        catch (Throwable ex) {
            if (exClass.isAssignableFrom(ex.getClass())) {
                throw ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            if (ex instanceof Error) {
                throw (Error)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    public String waitForStdOutString() throws ExecException, ExitValueException, StdErrNonEmptyException, InterruptedException {
        StringWriter out = new StringWriter();
        StringWriter err = new StringWriter();
        this.pipeTo(new WriterOutputStream(out), new WriterOutputStream(err), true);
        JobResult<Void> res = this.waitForResult();
        if (res.isException()) {
            Throwable th = res.getException();
            if (th instanceof ExecException) {
                throw (ExecException)th;
            }
            throw new ExecException(th);
        }
        String errStr = err.toString();
        String outStr = out.toString();
        if (errStr.length() > 0) {
            throw new StdErrNonEmptyException(outStr, errStr);
        }
        return outStr;
    }

    public InputStream getErrorStream() {
        if (this.mProcess == null) {
            return null;
        }
        return this.mProcess.getErrorStream();
    }

    public InputStream getInputStream() {
        if (this.mProcess == null) {
            return null;
        }
        return this.mProcess.getInputStream();
    }

    public OutputStream getOutputStream() {
        if (this.mProcess == null) {
            return null;
        }
        return this.mProcess.getOutputStream();
    }

    public void pushInput(final String ... inputLines) {
        if (this.mProcess == null) {
            throw this.createIllegalThreadStateException();
        }
        final PrintStream ps = Print.createStream(this.getOutputStream());
        AbstractJob<Void> job = new AbstractJob<Void>(){

            @Override
            public Void run() throws Throwable {
                String[] stringArray = inputLines;
                int n = inputLines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    ps.println(line);
                    ++n2;
                }
                ps.close();
                return null;
            }
        };
        job.exec();
    }

    public void pipeFrom(ExecJobMonitor src, boolean closeOnTerminate) {
        this.pipeIn(src.getInputStream(), closeOnTerminate);
        this.pipeIn(src.getErrorStream(), closeOnTerminate);
    }

    public void pipeTo(ExecJobMonitor dst, boolean closeOnTerminate) {
        this.pipeOut(dst.getOutputStream(), closeOnTerminate);
        this.pipeErr(dst.getOutputStream(), closeOnTerminate);
    }

    public void pipeTo(OutputStream out, OutputStream err, boolean closeOnTerminate) {
        this.pipeOut(out, closeOnTerminate);
        this.pipeErr(err, closeOnTerminate);
    }

    public void pipeFrom(InputStream in, boolean closeOnTerminate) {
        this.pipeIn(in, closeOnTerminate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pipeOut(OutputStream out, boolean closeOnTerminate) {
        if (this.mProcess == null) {
            throw this.createIllegalThreadStateException();
        }
        this.pipe(this.getInputStream(), out);
        if (closeOnTerminate) {
            ExecJobMonitor execJobMonitor = this;
            synchronized (execJobMonitor) {
                this.mCloseOutOnTerminate.add(out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pipeErr(OutputStream err, boolean closeOnTerminate) {
        if (this.mProcess == null) {
            throw this.createIllegalThreadStateException();
        }
        this.pipe(this.getErrorStream(), err);
        if (closeOnTerminate) {
            ExecJobMonitor execJobMonitor = this;
            synchronized (execJobMonitor) {
                this.mCloseOutOnTerminate.add(err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pipeIn(InputStream in, boolean closeOnTerminate) {
        if (this.mProcess == null) {
            throw this.createIllegalThreadStateException();
        }
        this.pipe(in, this.getOutputStream());
        if (closeOnTerminate) {
            ExecJobMonitor execJobMonitor = this;
            synchronized (execJobMonitor) {
                this.mCloseInOnTerminate.add(in);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pipe(InputStream in, OutputStream out) {
        JobMonitor pipeMonitor = new PipeJob(in, out).exec();
        ExecJobMonitor execJobMonitor = this;
        synchronized (execJobMonitor) {
            this.mPipeJobs.add(pipeMonitor);
        }
    }

    protected synchronized void closeStreams() {
        for (InputStream in : this.mCloseInOnTerminate) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (OutputStream out : this.mCloseOutOnTerminate) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private IllegalThreadStateException createIllegalThreadStateException() {
        return new IllegalThreadStateException(this.getJobResult().getException().toString());
    }
}

